/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity;

import com.willr27.blocklings.entity.BlocklingsEntityTypes;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blocklings", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityGeneration {
    public static final EntityClassification BLOCKLING = EntityClassification.create((String)"BLOCKLING", (String)"blockling", (int)30, (boolean)true, (boolean)true, (int)128);

    public static void init() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BlocklingsEntityTypes.BLOCKLING.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BlocklingEntity::checkBlocklingSpawnRules);
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        EntityGeneration.addEntityToAllBiomes(event.getSpawns(), (EntityType)BlocklingsEntityTypes.BLOCKLING.get(), 100, 4, 8);
    }

    private static void addEntityToAllBiomesExceptThese(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, RegistryKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(RegistryKey::func_240901_a_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (!isBiomeSelected) {
            EntityGeneration.addEntityToAllBiomes(event.getSpawns(), type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToSpecificBiomes(BiomeLoadingEvent event, EntityType<?> type, int weight, int minCount, int maxCount, RegistryKey<Biome> ... biomes) {
        boolean isBiomeSelected = Arrays.stream(biomes).map(RegistryKey::func_240901_a_).map(Object::toString).anyMatch(s -> s.equals(event.getName().toString()));
        if (isBiomeSelected) {
            EntityGeneration.addEntityToAllBiomes(event.getSpawns(), type, weight, minCount, maxCount);
        }
    }

    private static void addEntityToAllBiomes(MobSpawnInfoBuilder spawns, EntityType<?> type, int weight, int minCount, int maxCount) {
        List base = spawns.getSpawner(type.func_220339_d());
        base.add(new MobSpawnInfo.Spawners(type, weight, minCount, maxCount));
    }
}

