/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling;

import com.google.common.collect.Iterables;
import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.block.BlocklingsBlocks;
import com.willr27.blocklings.client.gui.BlocklingGuiHandler;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import com.willr27.blocklings.entity.blockling.BlocklingType;
import com.willr27.blocklings.entity.blockling.action.BlocklingActions;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.entity.blockling.skill.BlocklingSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.CombatSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.FarmingSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.GeneralSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.MiningSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.WoodcuttingSkills;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.interop.TinkersConstructProxy;
import com.willr27.blocklings.inventory.EquipmentInventory;
import com.willr27.blocklings.item.BlocklingItem;
import com.willr27.blocklings.item.BlocklingWhistleItem;
import com.willr27.blocklings.item.BlocklingsItems;
import com.willr27.blocklings.network.messages.BlocklingAttackTargetMessage;
import com.willr27.blocklings.network.messages.BlocklingNameMessage;
import com.willr27.blocklings.network.messages.BlocklingScaleMessage;
import com.willr27.blocklings.network.messages.BlocklingTypeMessage;
import com.willr27.blocklings.util.IReadWriteNBT;
import com.willr27.blocklings.util.ObjectUtil;
import com.willr27.blocklings.util.ToolUtil;
import com.willr27.blocklings.util.Version;
import com.willr27.blocklings.util.WorldUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

@Mod.EventBusSubscriber(modid="blocklings", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BlocklingEntity
extends TameableEntity
implements IEntityAdditionalSpawnData,
IReadWriteNBT {
    @Nonnull
    private BlocklingType naturalBlocklingType = BlocklingType.GRASS;
    @Nonnull
    private BlocklingType blocklingType = BlocklingType.GRASS;
    private int blocklingTypeVariant = 0;
    @Nonnull
    private final BlocklingAttributes stats = new BlocklingAttributes(this);
    @Nonnull
    private final BlocklingSkills skills = new BlocklingSkills(this);
    @Nonnull
    private final BlocklingTasks tasks = new BlocklingTasks(this);
    @Nonnull
    private final BlocklingActions actions = new BlocklingActions(this);
    @Nonnull
    private final EquipmentInventory equipmentInv = new EquipmentInventory(this);
    @Nonnull
    public final BlocklingGuiHandler guiHandler = new BlocklingGuiHandler(this);
    private float scale = 1.0f;
    private int attacksRecently = 0;
    private int oresMinedRecently = 0;
    private int logsChoppedRecently = 0;
    private int cropsHarvestedRecently = 0;
    public boolean wasLastAttackHunt = false;
    private boolean hasPlayerResetCrouchBetweenInteractions = true;
    @Nullable
    private BlockPos currentLightPos = null;

    public BlocklingEntity(@Nonnull EntityType<? extends BlocklingEntity> type, @Nonnull World world) {
        super(type, world);
        this.setScale(1.0f, false);
        this.stats.initUpdateCallbacks();
        if (!this.field_70170_p.func_201670_d()) {
            this.blocklingTypeVariant = this.func_70681_au().nextInt(3);
            this.setNaturalBlocklingType(BlocklingType.TYPES.get(this.func_70681_au().nextInt(BlocklingType.TYPES.size())), false);
            this.setBlocklingType(this.naturalBlocklingType, false);
            this.setScale(this.func_70681_au().nextFloat() * 0.5f + 0.45f, false);
            this.stats.init();
        }
        this.actions.ticks20.addCallback(this::updatePassiveAbilities);
        this.actions.logRegenerationCooldown.addCallback(this::updateLogPassiveAbility);
        this.equipmentInv.updateToolAttributes();
        this.func_70606_j(this.func_110138_aP());
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        this.updateLightPos(true);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 0.0).func_233815_a_(Attributes.field_233825_h_, 0.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficultyInstance, @Nonnull SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT entityTag) {
        this.tasks.initDefaultTasks();
        if (spawnReason == SpawnReason.SPAWN_EGG && entityTag != null) {
            this.func_70037_a(entityTag);
        }
        return super.func_213386_a(world, difficultyInstance, spawnReason, entityData, entityTag);
    }

    public void func_213281_b(@Nonnull CompoundNBT tag) {
        super.func_213281_b(tag);
        CompoundNBT blocklingTag = new CompoundNBT();
        blocklingTag.func_74778_a("blocklings_version", Blocklings.VERSION.toString());
        this.writeToNBT(blocklingTag);
        tag.func_218657_a("blockling", (INBT)blocklingTag);
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT blocklingTag) {
        blocklingTag.func_74778_a("original_type", this.naturalBlocklingType.key);
        blocklingTag.func_74778_a("type", this.blocklingType.key);
        blocklingTag.func_74768_a("variant", this.blocklingTypeVariant);
        blocklingTag.func_74776_a("scale", this.scale);
        blocklingTag.func_218657_a("equipment_inv", (INBT)this.equipmentInv.writeToNBT());
        blocklingTag.func_218657_a("attributes", (INBT)this.stats.writeToNBT());
        blocklingTag.func_218657_a("tasks", (INBT)this.tasks.writeToNBT());
        blocklingTag.func_218657_a("skills", (INBT)this.skills.writeToNBT());
        return blocklingTag;
    }

    public void func_70037_a(@Nonnull CompoundNBT tag) {
        super.func_70037_a(tag);
        CompoundNBT blocklingTag = tag.func_74775_l("blockling");
        if (blocklingTag != null) {
            this.readFromNBT(blocklingTag, ObjectUtil.coalesce(new Version(blocklingTag.func_74779_i("blocklings_version")), Blocklings.VERSION));
        }
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT blocklingTag, @Nonnull Version tagVersion) {
        CompoundNBT skillsTag;
        CompoundNBT tasksTag;
        CompoundNBT statsTag;
        this.blocklingTypeVariant = blocklingTag.func_74762_e("variant");
        this.naturalBlocklingType = BlocklingType.find(blocklingTag.func_74779_i("original_type"), tagVersion);
        this.blocklingType = BlocklingType.find(blocklingTag.func_74779_i("type"), tagVersion);
        this.setScale(blocklingTag.func_74760_g("scale"), false);
        float health = this.func_110143_aJ();
        CompoundNBT equipmentInvTag = blocklingTag.func_74775_l("equipment_inv");
        if (equipmentInvTag != null) {
            this.equipmentInv.readFromNBT(equipmentInvTag, tagVersion);
        }
        if ((statsTag = blocklingTag.func_74775_l("attributes")) != null) {
            this.stats.readFromNBT(statsTag, tagVersion);
        }
        if ((tasksTag = blocklingTag.func_74775_l("tasks")) != null) {
            this.tasks.readFromNBT(tasksTag, tagVersion);
        }
        if ((skillsTag = blocklingTag.func_74775_l("skills")) != null) {
            this.skills.readFromNBT(skillsTag, tagVersion);
        }
        this.equipmentInv.updateToolAttributes();
        this.stats.updateTypeBonuses(false);
        this.func_70606_j(health);
    }

    public void writeSpawnData(@Nonnull PacketBuffer buf) {
        buf.writeInt(BlocklingType.TYPES.indexOf(this.naturalBlocklingType));
        buf.writeInt(BlocklingType.TYPES.indexOf(this.blocklingType));
        buf.writeInt(this.blocklingTypeVariant);
        buf.writeFloat(this.scale);
        this.equipmentInv.encode(buf);
        this.stats.encode(buf);
        this.tasks.encode(buf);
        this.skills.encode(buf);
    }

    public void readSpawnData(@Nonnull PacketBuffer buf) {
        this.naturalBlocklingType = BlocklingType.TYPES.get(buf.readInt());
        this.blocklingType = BlocklingType.TYPES.get(buf.readInt());
        this.blocklingTypeVariant = buf.readInt();
        this.setScale(buf.readFloat(), false);
        this.equipmentInv.decode(buf);
        this.stats.decode(buf);
        this.tasks.decode(buf);
        this.skills.decode(buf);
        this.equipmentInv.updateToolAttributes();
        this.stats.updateTypeBonuses(false);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.hasPlayerResetCrouchBetweenInteractions) {
            this.hasPlayerResetCrouchBetweenInteractions = !this.func_70909_n() || this.func_70902_q() != null && !this.func_70902_q().func_213453_ef();
        }
        this.skills.tick();
        this.actions.tick();
        this.updateLightPos(false);
        this.checkAndUpdateCooldowns();
        this.equipmentInv.detectAndSendChanges();
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        this.tasks.tick();
    }

    public void updateLogPassiveAbility() {
        int radius = 8;
        float healAmount = 2.0f;
        if (this.naturalBlocklingType == BlocklingType.OAK_LOG || this.blocklingType == BlocklingType.OAK_LOG) {
            for (int i = -8; i <= 8; ++i) {
                for (int j = -8; j <= 8; ++j) {
                    for (int k = -8; k <= 8; ++k) {
                        WorldUtil.Tree treeToTest;
                        BlockPos testPos = this.func_233580_cy_().func_177982_a(i, j, k);
                        Block testBlock = this.field_70170_p.func_180495_p(testPos).func_177230_c();
                        if (testBlock != Blocks.field_196617_K || !(treeToTest = WorldUtil.findTreeFromPos(this.field_70170_p, testPos, 40, t -> true, t -> true)).isValid()) continue;
                        if (this.func_110143_aJ() < this.func_110138_aP()) {
                            if (this.field_70170_p.field_72995_K) {
                                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e() + 0.75, this.func_226281_cx_(), 0.0, 0.0, 0.0);
                            } else {
                                this.func_70691_i(2.0f);
                            }
                        }
                        if (this.func_70902_q() != null && this.func_70902_q().func_70068_e((Entity)this) < 64.0 && this.func_70902_q().func_110143_aJ() < this.func_70902_q().func_110138_aP()) {
                            if (this.field_70170_p.field_72995_K) {
                                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_70902_q().func_226277_ct_(), this.func_70902_q().func_226278_cu_() + (double)this.func_70902_q().func_70047_e() + 0.75, this.func_70902_q().func_226281_cx_(), 0.0, 0.0, 0.0);
                            } else {
                                this.func_70902_q().func_70691_i(2.0f);
                            }
                        }
                        for (BlocklingEntity nearbyBlockling : this.field_70170_p.func_217357_a(BlocklingEntity.class, AxisAlignedBB.func_241550_g_((double)16.0, (double)16.0, (double)16.0).func_186670_a(this.func_233580_cy_()))) {
                            if (nearbyBlockling == this || this.func_184753_b() != null && !this.func_184753_b().equals(nearbyBlockling.func_184753_b()) || !(nearbyBlockling.func_110143_aJ() < nearbyBlockling.func_110138_aP())) continue;
                            if (this.field_70170_p.field_72995_K) {
                                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, nearbyBlockling.func_226277_ct_(), nearbyBlockling.func_226278_cu_() + (double)nearbyBlockling.func_70047_e() + 0.75, nearbyBlockling.func_226281_cx_(), 0.0, 0.0, 0.0);
                                continue;
                            }
                            nearbyBlockling.func_70691_i(2.0f);
                        }
                        return;
                    }
                }
            }
        }
    }

    private void updatePassiveAbilities() {
        if (!this.field_70170_p.field_72995_K) {
            boolean level;
            LivingEntity owner;
            BlockPos belowPos;
            Block belowBlock;
            if ((this.naturalBlocklingType == BlocklingType.GRASS || this.blocklingType == BlocklingType.GRASS) && this.field_70146_Z.nextInt(3) == 0 && (belowBlock = this.field_70170_p.func_180495_p(belowPos = this.func_226268_ag_()).func_177230_c()) == Blocks.field_150346_d) {
                this.field_70170_p.func_180501_a(belowPos, Blocks.field_196658_i.func_176223_P(), 3);
            }
            if ((this.naturalBlocklingType == BlocklingType.DIRT || this.blocklingType == BlocklingType.DIRT) && this.field_70146_Z.nextInt(3) == 0 && (belowBlock = this.field_70170_p.func_180495_p(belowPos = this.func_226268_ag_()).func_177230_c()) == Blocks.field_196658_i) {
                this.field_70170_p.func_180501_a(belowPos, Blocks.field_150346_d.func_176223_P(), 3);
            }
            if (this.naturalBlocklingType == BlocklingType.STONE || this.blocklingType == BlocklingType.STONE) {
                owner = this.func_70902_q();
                float range = 8.0f;
                level = true;
                this.func_195064_c(new EffectInstance(Effects.field_76429_m, 100, 0, false, false, true));
                if (owner != null && owner.func_70068_e((Entity)this) < 64.0) {
                    owner.func_195064_c(new EffectInstance(Effects.field_76429_m, 419, 0, false, false, true));
                }
                for (BlocklingEntity nearbyBlockling : this.field_70170_p.func_217357_a(BlocklingEntity.class, AxisAlignedBB.func_241550_g_((double)16.0, (double)16.0, (double)16.0).func_186670_a(this.func_233580_cy_()))) {
                    if (this.func_184753_b() != null && !this.func_184753_b().equals(nearbyBlockling.func_184753_b())) continue;
                    nearbyBlockling.func_195064_c(new EffectInstance(Effects.field_76429_m, 100, 0, false, false, true));
                }
            }
            if (this.naturalBlocklingType == BlocklingType.IRON || this.blocklingType == BlocklingType.IRON) {
                owner = this.func_70902_q();
                float range = 8.0f;
                level = true;
                this.func_195064_c(new EffectInstance(Effects.field_76420_g, 100, 0, false, false, true));
                if (owner != null && owner.func_70068_e((Entity)this) < 64.0) {
                    owner.func_195064_c(new EffectInstance(Effects.field_76420_g, 419, 0, false, false, true));
                }
                for (BlocklingEntity nearbyBlockling : this.field_70170_p.func_217357_a(BlocklingEntity.class, AxisAlignedBB.func_241550_g_((double)16.0, (double)16.0, (double)16.0).func_186670_a(this.func_233580_cy_()))) {
                    if (this.func_184753_b() != null && !this.func_184753_b().equals(nearbyBlockling.func_184753_b())) continue;
                    nearbyBlockling.func_195064_c(new EffectInstance(Effects.field_76420_g, 100, 0, false, false, true));
                }
            }
            if (this.naturalBlocklingType == BlocklingType.GOLD || this.blocklingType == BlocklingType.GOLD) {
                owner = this.func_70902_q();
                float range = 8.0f;
                level = true;
                this.func_195064_c(new EffectInstance(Effects.field_76424_c, 100, 0, false, false, true));
                if (owner != null && owner.func_70068_e((Entity)this) < 64.0) {
                    owner.func_195064_c(new EffectInstance(Effects.field_76424_c, 419, 0, false, false, true));
                }
                for (BlocklingEntity nearbyBlockling : this.field_70170_p.func_217357_a(BlocklingEntity.class, AxisAlignedBB.func_241550_g_((double)16.0, (double)16.0, (double)16.0).func_186670_a(this.func_233580_cy_()))) {
                    if (this.func_184753_b() != null && !this.func_184753_b().equals(nearbyBlockling.func_184753_b())) continue;
                    nearbyBlockling.func_195064_c(new EffectInstance(Effects.field_76424_c, 100, 0, false, false, true));
                }
            }
            if (this.naturalBlocklingType == BlocklingType.EMERALD || this.blocklingType == BlocklingType.EMERALD) {
                owner = this.func_70902_q();
                float range = 8.0f;
                level = true;
                if (owner != null && owner.func_70068_e((Entity)this) < 64.0) {
                    owner.func_195064_c(new EffectInstance(Effects.field_188425_z, 419, 0, false, false, true));
                }
            }
        }
    }

    public void updateLightPos(boolean removeOnly) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.currentLightPos != null) {
                this.field_70170_p.func_217377_a(this.currentLightPos, false);
            }
            if (!(removeOnly || this.naturalBlocklingType != BlocklingType.GLOWSTONE && this.blocklingType != BlocklingType.GLOWSTONE)) {
                BlockPos blockPos = new BlockPos(this.func_213303_ch().func_72441_c(0.0, 0.5 * (double)this.func_213355_cm(), 0.0));
                for (BlockPos testPos : Arrays.asList(blockPos, blockPos.func_177984_a(), blockPos.func_177977_b(), blockPos.func_177978_c(), blockPos.func_177968_d(), blockPos.func_177974_f(), blockPos.func_177976_e())) {
                    blockPos = testPos;
                    BlockState blockState = this.field_70170_p.func_180495_p(blockPos);
                    Block block = blockState.func_177230_c();
                    if (!block.getBlock().isAir(blockState, (IBlockReader)this.field_70170_p, blockPos) && (this.currentLightPos != null || block != BlocklingsBlocks.LIGHT.get())) continue;
                    this.currentLightPos = blockPos;
                    this.field_70170_p.func_180501_a(this.currentLightPos, ((Block)BlocklingsBlocks.LIGHT.get()).func_176223_P(), 3);
                    break;
                }
            }
        }
    }

    private void checkAndUpdateCooldowns() {
        this.actions.ticks20.tryStart();
        this.actions.regenerationCooldown.tryStart();
        if (this.actions.regenerationCooldown.isFinished()) {
            if (this.skills.getSkill(CombatSkills.REGENERATION_3).isBought()) {
                this.func_70691_i(5.0f);
            } else if (this.skills.getSkill(CombatSkills.REGENERATION_2).isBought()) {
                this.func_70691_i(3.0f);
            } else if (this.skills.getSkill(CombatSkills.REGENERATION_1).isBought()) {
                this.func_70691_i(1.0f);
            }
        }
        if (this.actions.attacksCooldown.isFinished()) {
            this.attacksRecently = 0;
            this.stats.attackSpeedSkillMomentumModifier.setValue(Float.valueOf(0.0f));
        }
        if (this.actions.oresMinedCooldown.isFinished()) {
            this.oresMinedRecently = 0;
            this.stats.miningSpeedSkillMomentumModifier.setValue(Float.valueOf(0.0f));
        }
        if (this.actions.logsChoppedCooldown.isFinished()) {
            this.logsChoppedRecently = 0;
            this.stats.woodcuttingSpeedSkillMomentumModifier.setValue(Float.valueOf(0.0f));
        }
        if (this.actions.cropsHarvestedCooldown.isFinished()) {
            this.cropsHarvestedRecently = 0;
            this.stats.farmingSpeedSkillMomentumModifier.setValue(Float.valueOf(0.0f));
        }
        this.actions.logRegenerationCooldown.tryStart();
    }

    public boolean func_70652_k(@Nonnull Entity target) {
        ModifiableAttributeInstance damageAttribute;
        Optional<AttributeModifier> strengthModifier;
        BlocklingHand attackingHand = this.actions.attack.getRecentHand();
        ItemStack mainStack = this.func_184614_ca();
        ItemStack offStack = this.func_184592_cb();
        Item mainItem = mainStack.func_77973_b();
        Item offItem = offStack.func_77973_b();
        boolean attackingWithMainHand = attackingHand == BlocklingHand.MAIN || attackingHand == BlocklingHand.BOTH;
        boolean attackingWithOffHand = attackingHand == BlocklingHand.OFF || attackingHand == BlocklingHand.BOTH;
        boolean mainHandTinkersTool = ToolUtil.isTinkersTool(mainStack);
        boolean offHandTinkersTool = ToolUtil.isTinkersTool(offStack);
        boolean hasHurt = false;
        float tinkersDamage = 0.0f;
        float damage = 0.0f;
        float knockback = (float)this.func_233637_b_(Attributes.field_233824_g_);
        int fireAspect = 0;
        if (target instanceof LivingEntity) {
            if (attackingWithMainHand) {
                if (mainHandTinkersTool && ToolUtil.isUseableTool(mainStack)) {
                    if (TinkersConstructProxy.instance.attackEntity(mainStack, (LivingEntity)this, Hand.MAIN_HAND, target, () -> 1.0, false)) {
                        tinkersDamage += ((Float)this.stats.mainHandAttackDamage.getValue()).floatValue();
                        hasHurt = true;
                    }
                } else {
                    damage += ((Float)this.stats.mainHandAttackDamage.getValue()).floatValue();
                    damage += ToolUtil.getToolEnchantmentDamage(mainStack, ((LivingEntity)target).func_70668_bt());
                    knockback += ToolUtil.getToolKnockbackLevel(mainStack);
                    fireAspect = (int)((float)fireAspect + ToolUtil.getToolFireAspectLevel(mainStack));
                }
            }
            if (attackingWithOffHand) {
                if (offHandTinkersTool && ToolUtil.isUseableTool(offStack)) {
                    if (TinkersConstructProxy.instance.attackEntity(offStack, (LivingEntity)this, Hand.MAIN_HAND, target, () -> 1.0, false)) {
                        tinkersDamage += ((Float)this.stats.offHandAttackDamage.getValue()).floatValue();
                        hasHurt = true;
                    }
                } else {
                    damage += ((Float)this.stats.offHandAttackDamage.getValue()).floatValue();
                    damage += ToolUtil.getToolEnchantmentDamage(offStack, ((LivingEntity)target).func_70668_bt());
                    knockback += ToolUtil.getToolKnockbackLevel(offStack);
                    fireAspect = (int)((float)fireAspect + ToolUtil.getToolFireAspectLevel(offStack));
                }
            }
        }
        if (fireAspect > 0) {
            target.func_70015_d(fireAspect * 4);
        }
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (this.skills.getSkill(CombatSkills.POISON_ATTACKS).isBought()) {
                livingTarget.func_195064_c(new EffectInstance(Effects.field_76436_u, 100));
            } else if (this.skills.getSkill(CombatSkills.WITHER_ATTACKS).isBought()) {
                livingTarget.func_195064_c(new EffectInstance(Effects.field_82731_v, 60));
            }
        }
        if ((strengthModifier = (damageAttribute = this.func_110148_a(Attributes.field_233823_f_)).func_225505_c_().stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(UUID.fromString("648D7064-6A60-4F59-8ABE-C2C23A6DD7A9"))).findFirst()).isPresent()) {
            damage = (float)((double)damage + strengthModifier.get().func_111164_d());
        }
        if (damage > 0.0f) {
            int invulnerableTime = target.field_70172_ad;
            target.field_70172_ad = 0;
            hasHurt = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage);
            target.field_70172_ad = invulnerableTime;
        }
        if (hasHurt) {
            this.stats.combatXp.incrementValue((int)(damage + tinkersDamage) + 1);
            if (knockback > 0.0f) {
                ((LivingEntity)target).func_233627_a_(knockback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            if (target instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)target;
                this.maybeDisableShield(player, this.func_184614_ca(), player.func_184587_cr() ? player.func_184607_cu() : ItemStack.field_190927_a);
            }
            this.func_174815_a((LivingEntity)this, target);
            this.func_130011_c(target);
            if (attackingWithMainHand) {
                this.tryDamageToolOnAttack(mainStack);
            }
            if (attackingWithOffHand) {
                this.tryDamageToolOnAttack(offStack);
            }
            this.incAttacksRecently();
        }
        return hasHurt;
    }

    public void tryDamageToolOnAttack(@Nonnull ItemStack stack) {
        int damage;
        Item item = stack.func_77973_b();
        int n = damage = this.getSkills().getSkill(CombatSkills.WRECKLESS).isBought() ? 2 : 1;
        if (ToolUtil.isTinkersTool(item)) {
            --damage;
            if (!ToolUtil.isWeapon(item)) {
                damage *= 2;
            }
            TinkersConstructProxy.instance.damageTool(stack, damage, (LivingEntity)this);
        } else {
            if (item instanceof ToolItem) {
                damage *= 2;
            }
            if (ToolUtil.damageTool(stack, this, damage)) {
                stack.func_190918_g(1);
            }
        }
    }

    private void maybeDisableShield(PlayerEntity p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.func_190926_b() && !p_233655_3_.func_190926_b() && p_233655_2_.func_77973_b() instanceof AxeItem && p_233655_3_.func_77973_b() == Items.field_185159_cQ) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                p_233655_1_.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                this.field_70170_p.func_72960_a((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource damageSource, float damage) {
        LivingEntity attacker;
        boolean hurt = false;
        if (this.naturalBlocklingType != BlocklingType.NETHERITE && this.blocklingType != BlocklingType.NETHERITE || this.func_70681_au().nextInt(10) != 0) {
            hurt = super.func_70097_a(damageSource, damage);
        }
        if (hurt && damageSource.func_76346_g() instanceof LivingEntity && (attacker = (LivingEntity)damageSource.func_76346_g()) != null) {
            if (this.naturalBlocklingType == BlocklingType.QUARTZ || this.blocklingType == BlocklingType.QUARTZ) {
                attacker.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage / 15.0f);
            }
            if (this.naturalBlocklingType == BlocklingType.OBSIDIAN || this.blocklingType == BlocklingType.OBSIDIAN) {
                attacker.func_233627_a_(0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
        }
        if (this.func_233643_dh_()) {
            BlocklingWhistleItem.onBlocklingDestroyed(this);
        }
        if (!this.field_70170_p.field_72995_K && this.skills.getSkill(GeneralSkills.ARMADILLO).isBought() && this.func_233643_dh_()) {
            this.func_70606_j(1.0f);
            this.dropItemStack(BlocklingItem.create(this));
            this.func_70606_j(0.0f);
            this.func_70106_y();
        }
        return hurt;
    }

    @Nonnull
    public ActionResultType func_230254_b_(@Nonnull PlayerEntity player, @Nonnull Hand hand) {
        ActionResultType result = hand == Hand.MAIN_HAND ? this.mobInteractMainHand(player) : this.mobInteractOffHand(player);
        if (result != ActionResultType.PASS) {
            return result;
        }
        return super.func_230254_b_(player, hand);
    }

    @Nonnull
    private ActionResultType mobInteractMainHand(@Nonnull PlayerEntity player) {
        ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
        Item item = stack.func_77973_b();
        if (item == BlocklingsItems.BLOCKLING_WHISTLE.get() && player == this.func_70902_q()) {
            BlocklingWhistleItem.setBlockling(stack, this);
            return ActionResultType.SUCCESS;
        }
        if (this.blocklingType.isFoodForType(item)) {
            if (!this.field_70170_p.func_201670_d()) {
                if (!this.func_70909_n()) {
                    this.tryTame((ServerPlayerEntity)player, stack);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (this.hasPlayerResetCrouchBetweenInteractions && this.skills.getSkill(GeneralSkills.PACKLING).isBought() && player == this.func_70902_q() && player.func_213453_ef()) {
                    ItemStack blocklingStack = BlocklingItem.create(this);
                    if (!player.field_71071_by.func_70441_a(blocklingStack)) {
                        this.dropItemStack(blocklingStack);
                    }
                    BlocklingWhistleItem.onBlocklingDestroyed(this);
                    this.func_70106_y();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (this.hasPlayerResetCrouchBetweenInteractions && this.skills.getSkill(GeneralSkills.HEAL).isBought() && this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(this.field_70146_Z.nextInt(3) + 3);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
        } else if (BlocklingType.isFood(item) && player == this.func_70902_q() && player.func_213453_ef()) {
            if (!this.field_70170_p.func_201670_d()) {
                this.hasPlayerResetCrouchBetweenInteractions = false;
                if (this.field_70146_Z.nextInt(4) == 0) {
                    this.setBlocklingType(BlocklingType.findTypeForFood(item));
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && player == this.func_70902_q()) {
            if (!this.field_70170_p.func_201670_d() && this.hasPlayerResetCrouchBetweenInteractions) {
                this.guiHandler.openGui(player);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    private ActionResultType mobInteractOffHand(@Nonnull PlayerEntity player) {
        ItemStack stack = player.func_184586_b(Hand.OFF_HAND);
        Item item = stack.func_77973_b();
        return ActionResultType.PASS;
    }

    private void tryTame(@Nonnull ServerPlayerEntity player, @Nonnull ItemStack stack) {
        if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
            this.func_193101_c((PlayerEntity)player);
            for (Task task : this.getTasks().getPrioritisedTasks()) {
                if (!task.isConfigured() || task.getType() != BlocklingTasks.WANDER) continue;
                task.setType(BlocklingTasks.FOLLOW);
            }
            this.field_70699_by.func_75499_g();
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
        }
    }

    public void func_193101_c(@Nonnull PlayerEntity player) {
        super.func_193101_c(player);
        if (!this.func_145818_k_()) {
            this.setCustomName(new StringTextComponent("Blockling"), true);
        }
    }

    protected void func_213333_a(@Nonnull DamageSource damageSource, int something, boolean something2) {
        super.func_213333_a(damageSource, something, something2);
        for (int i = 0; i < this.equipmentInv.func_70302_i_(); ++i) {
            ItemStack stack = this.equipmentInv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.func_199701_a_(stack);
        }
    }

    protected void func_213345_d(@Nonnull DamageSource damageSource) {
        if (!this.skills.getSkill(GeneralSkills.ARMADILLO).isBought()) {
            super.func_213345_d(damageSource);
        }
    }

    @Nonnull
    public ItemStack func_184614_ca() {
        return this.func_184586_b(Hand.MAIN_HAND);
    }

    @Nonnull
    public ItemStack func_184592_cb() {
        return this.func_184586_b(Hand.OFF_HAND);
    }

    @Nonnull
    public ItemStack func_184586_b(@Nonnull Hand hand) {
        return this.equipmentInv.getHandStack(hand);
    }

    public void func_184611_a(@Nonnull Hand hand, @Nonnull ItemStack stack) {
        this.equipmentInv.setHandStack(hand, stack);
    }

    @Nonnull
    public Iterable<ItemStack> func_184214_aD() {
        BlocklingHand attackingHand = this.actions.attack.getRecentHand();
        if (attackingHand == BlocklingHand.MAIN) {
            return Collections.singletonList(this.func_184614_ca());
        }
        if (attackingHand == BlocklingHand.OFF) {
            return Collections.singletonList(this.func_184592_cb());
        }
        return Arrays.asList(this.func_184614_ca(), this.func_184592_cb());
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ItemStack> func_184209_aF() {
        return Iterables.concat(this.func_184214_aD(), this.func_184193_aE());
    }

    public boolean func_190630_a(@Nonnull EquipmentSlotType slotType) {
        if (slotType == EquipmentSlotType.MAINHAND) {
            return !this.func_184614_ca().func_190926_b();
        }
        if (slotType == EquipmentSlotType.OFFHAND) {
            return !this.func_184592_cb().func_190926_b();
        }
        return false;
    }

    @Nonnull
    public ItemStack func_184582_a(@Nonnull EquipmentSlotType slotType) {
        if (slotType == EquipmentSlotType.MAINHAND) {
            return this.func_184614_ca();
        }
        if (slotType == EquipmentSlotType.OFFHAND) {
            return this.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(@Nonnull EquipmentSlotType slotType, @Nonnull ItemStack stack) {
        if (slotType == EquipmentSlotType.MAINHAND) {
            this.func_184611_a(Hand.MAIN_HAND, stack);
        } else if (slotType == EquipmentSlotType.OFFHAND) {
            this.func_184611_a(Hand.OFF_HAND, stack);
        }
    }

    public static boolean checkBlocklingSpawnRules(EntityType<? extends AnimalEntity> p_223316_0_, IWorld p_223316_1_, SpawnReason p_223316_2_, BlockPos p_223316_3_, Random p_223316_4_) {
        return true;
    }

    public boolean func_213380_a(@Nonnull IWorld world, @Nonnull SpawnReason reason) {
        if (reason == SpawnReason.NATURAL || reason == SpawnReason.CHUNK_GENERATION) {
            if (this.field_70146_Z.nextInt(this.blocklingType.spawnRateReduction) != 0) {
                return false;
            }
            if (!world.func_180495_p(this.func_226268_ag_()).func_185904_a().func_76220_a()) {
                return false;
            }
            for (BiPredicate<BlocklingEntity, IWorld> predicate : this.getBlocklingType().spawnPredicates) {
                if (predicate.test(this, world)) continue;
                return false;
            }
        }
        return true;
    }

    public float getEyeHeightAccess(@Nonnull Pose pose, @Nonnull EntitySize size) {
        return size.field_220316_b * 0.45f;
    }

    @Nullable
    public AgeableEntity func_241840_a(@Nonnull ServerWorld world, @Nonnull AgeableEntity entity) {
        return null;
    }

    public void dropItemStack(@Nonnull ItemStack stack) {
        this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + (double)0.2f, this.func_226281_cx_(), stack));
    }

    public boolean func_230279_az_() {
        return this.naturalBlocklingType == BlocklingType.NETHERITE || this.blocklingType == BlocklingType.NETHERITE || this.naturalBlocklingType == BlocklingType.OBSIDIAN || this.blocklingType == BlocklingType.OBSIDIAN;
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        if (name != null) {
            name = new StringTextComponent(name.getString());
        }
        this.setCustomName((StringTextComponent)name, false);
    }

    public void setCustomName(@Nullable StringTextComponent name, boolean sync) {
        super.func_200203_b((ITextComponent)name);
        if (this.field_70170_p.field_72995_K && sync) {
            new BlocklingNameMessage(this, name).sync();
        }
    }

    public void func_70624_b(@Nullable LivingEntity target) {
        this.setTarget(target, true);
    }

    public void setTarget(@Nullable LivingEntity target, boolean sync) {
        super.func_70624_b(target);
        if (sync) {
            new BlocklingAttackTargetMessage(this, target).sync();
        }
    }

    @Nonnull
    public BlocklingType getNaturalBlocklingType() {
        return this.naturalBlocklingType;
    }

    public void setNaturalBlocklingType(@Nonnull BlocklingType blocklingType) {
        this.setNaturalBlocklingType(blocklingType, true);
    }

    public void setNaturalBlocklingType(@Nonnull BlocklingType blocklingType, boolean sync) {
        this.naturalBlocklingType = blocklingType;
        this.stats.updateTypeBonuses(sync);
        if (sync) {
            new BlocklingTypeMessage(this, blocklingType, true).sync();
        }
    }

    @Nonnull
    public BlocklingType getBlocklingType() {
        return this.blocklingType;
    }

    public void setBlocklingType(@Nonnull BlocklingType blocklingType) {
        this.setBlocklingType(blocklingType, true);
    }

    public void setBlocklingType(@Nonnull BlocklingType blocklingType, boolean sync) {
        this.blocklingType = blocklingType;
        this.stats.updateTypeBonuses(sync);
        if (sync) {
            new BlocklingTypeMessage(this, blocklingType, false).sync();
        }
    }

    public int getBlocklingTypeVariant() {
        return this.blocklingTypeVariant;
    }

    @Nonnull
    public BlocklingAttributes getStats() {
        return this.stats;
    }

    @Nonnull
    public BlocklingSkills getSkills() {
        return this.skills;
    }

    @Nonnull
    public BlocklingTasks getTasks() {
        return this.tasks;
    }

    @Nonnull
    public BlocklingActions getActions() {
        return this.actions;
    }

    public EquipmentInventory getEquipment() {
        return this.equipmentInv;
    }

    public float func_213355_cm() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.setScale(scale, true);
    }

    public void setScale(float scale, boolean sync) {
        this.scale = scale;
        this.func_213323_x_();
        if (sync) {
            new BlocklingScaleMessage(this, scale).sync();
        }
    }

    public void incAttacksRecently() {
        ++this.attacksRecently;
        this.actions.attacksCooldown.start();
        if (this.skills.getSkill(CombatSkills.MOMENTUM).isBought()) {
            int cappedCount = Math.min(this.attacksRecently, 20);
            this.stats.attackSpeedSkillMomentumModifier.setValue(Float.valueOf((float)cappedCount / 2.0f));
        }
    }

    public void incOresMinedRecently() {
        ++this.oresMinedRecently;
        this.actions.oresMinedCooldown.start();
        if (this.skills.getSkill(MiningSkills.MOMENTUM).isBought()) {
            int cappedCount = Math.min(this.oresMinedRecently, 20);
            this.stats.miningSpeedSkillMomentumModifier.setValue(Float.valueOf(cappedCount));
        }
    }

    public void incLogsChoppedRecently() {
        ++this.logsChoppedRecently;
        this.actions.logsChoppedCooldown.start();
        if (this.skills.getSkill(WoodcuttingSkills.MOMENTUM).isBought()) {
            int cappedCount = Math.min(this.logsChoppedRecently, 20);
            this.stats.woodcuttingSpeedSkillMomentumModifier.setValue(Float.valueOf(cappedCount));
        }
    }

    public void incCropsHarvestedRecently() {
        ++this.cropsHarvestedRecently;
        this.actions.cropsHarvestedCooldown.start();
        if (this.skills.getSkill(FarmingSkills.MOMENTUM).isBought()) {
            int cappedCount = Math.min(this.cropsHarvestedRecently, 20);
            this.stats.farmingSpeedSkillMomentumModifier.setValue(Float.valueOf(cappedCount));
        }
    }
}

