/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling;

import com.willr27.blocklings.config.BlocklingsConfig;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.util.BlocklingsResourceLocation;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import com.willr27.blocklings.util.ItemUtil;
import com.willr27.blocklings.util.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlocklingType {
    public static final List<BlocklingType> TYPES = new ArrayList<BlocklingType>();
    public static final BlocklingType GRASS = BlocklingType.create("grass", 5).addCombatStats(2.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 3.0f).addGatheringStats(0.0f, 1.0f, 2.0f);
    public static final BlocklingType DIRT = BlocklingType.create("dirt", 0).addCombatStats(2.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 3.0f).addGatheringStats(0.0f, 1.0f, 2.0f);
    public static final BlocklingType OAK_LOG = BlocklingType.create("oak_log", 0).addCombatStats(3.0f, 1.0f, 1.5f, 0.0f, 0.0f, 0.0f, 3.0f).addGatheringStats(0.5f, 2.0f, 1.0f);
    public static final BlocklingType STONE = BlocklingType.create("stone", 0).addCombatStats(5.0f, 1.0f, 1.0f, 2.0f, 1.0f, 0.3f, 2.5f).addGatheringStats(1.5f, 0.5f, 0.5f);
    public static final BlocklingType IRON = BlocklingType.create("iron", 0).addCombatStats(6.0f, 2.0f, 1.0f, 2.0f, 1.0f, 0.1f, 3.0f).addGatheringStats(2.0f, 0.5f, 0.5f);
    public static final BlocklingType QUARTZ = BlocklingType.create("quartz", 0).addCombatStats(3.0f, 4.0f, 2.0f, 1.0f, 0.5f, 0.1f, 3.5f).addGatheringStats(2.0f, 0.5f, 0.5f);
    public static final BlocklingType LAPIS = BlocklingType.create("lapis", 0).addCombatStats(5.0f, 3.0f, 1.5f, 1.0f, 0.5f, 0.1f, 3.0f).addGatheringStats(2.0f, 0.5f, 0.5f);
    public static final BlocklingType GOLD = BlocklingType.create("gold", 0).addCombatStats(1.0f, 4.0f, 2.5f, 1.0f, 0.5f, 0.1f, 4.0f).addGatheringStats(2.5f, 0.5f, 0.5f);
    public static final BlocklingType EMERALD = BlocklingType.create("emerald", 0).addCombatStats(5.0f, 3.0f, 1.5f, 2.0f, 1.0f, 0.2f, 3.0f).addGatheringStats(2.5f, 0.5f, 0.5f);
    public static final BlocklingType DIAMOND = BlocklingType.create("diamond", 0).addCombatStats(8.0f, 6.0f, 2.0f, 3.0f, 1.5f, 0.2f, 3.0f).addGatheringStats(3.0f, 0.5f, 0.5f);
    public static final BlocklingType NETHERITE = BlocklingType.create("netherite", 0).addCombatStats(15.0f, 7.0f, 2.0f, 4.0f, 2.0f, 0.3f, 2.5f).addGatheringStats(2.5f, 1.0f, 1.0f);
    public static final BlocklingType OBSIDIAN = BlocklingType.create("obsidian", 0).addCombatStats(25.0f, 5.0f, 1.0f, 4.0f, 2.0f, 0.8f, 2.0f).addGatheringStats(1.0f, 0.5f, 0.5f);
    public static final BlocklingType GLOWSTONE = BlocklingType.create("glowstone", 0).addCombatStats(2.0f, 2.0f, 2.0f, 0.0f, 0.0f, 0.0f, 3.0f).addGatheringStats(1.0f, 1.0f, 1.0f);
    @Nonnull
    private static final Set<Item> FOODS = new HashSet<Item>();
    @Nonnull
    public final String key;
    @Nonnull
    public final ResourceLocation entityTexture;
    @Nonnull
    public final TranslationTextComponent name;
    public final int spawnRateReduction;
    private float maxHealth = 0.0f;
    private float attackDamage = 0.0f;
    private float attackSpeed = 3.0f;
    private float armour = 0.0f;
    private float armourToughness = 0.0f;
    private float knockbackResistance = 0.0f;
    private float moveSpeed = 0.0f;
    private float miningSpeed = 0.0f;
    private float woodcuttingSpeed = 0.0f;
    private float farmingSpeed = 0.0f;
    @Nonnull
    public final Set<Item> foods = new HashSet<Item>();
    @Nonnull
    public final List<BiPredicate<BlocklingEntity, IWorld>> spawnPredicates = new ArrayList<BiPredicate<BlocklingEntity, IWorld>>();

    public static void init() {
        FOODS.clear();
        TYPES.forEach(blocklingType -> {
            blocklingType.spawnPredicates.clear();
            blocklingType.foods.clear();
        });
        GRASS.addFoods(Blocks.field_196658_i);
        BlocklingType.GRASS.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234918_g_));
        BlocklingType.GRASS.spawnPredicates.add((blockling, world) -> BlocklingType.blockBelowIs(blockling, world, Blocks.field_196658_i));
        BlocklingType.GRASS.spawnPredicates.add((blockling, world) -> BlocklingType.canSeeSky(blockling, world));
        DIRT.addFoods(Blocks.field_150346_d);
        BlocklingType.DIRT.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234918_g_));
        BlocklingType.DIRT.spawnPredicates.add((blockling, world) -> BlocklingType.blockBelowIs(blockling, world, Blocks.field_196658_i));
        BlocklingType.DIRT.spawnPredicates.add((blockling, world) -> BlocklingType.canSeeSky(blockling, world));
        OAK_LOG.addFoods(Blocks.field_196617_K);
        BlocklingType.OAK_LOG.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234918_g_));
        BlocklingType.OAK_LOG.spawnPredicates.add((blockling, world) -> BlocklingType.blockBelowIs(blockling, world, Blocks.field_196658_i));
        BlocklingType.OAK_LOG.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 8, Blocks.field_196617_K));
        STONE.addFoods(Blocks.field_150348_b);
        BlocklingType.STONE.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234918_g_));
        BlocklingType.STONE.spawnPredicates.add((blockling, world) -> !BlocklingType.blockBelowIs(blockling, world, Blocks.field_196658_i));
        BlocklingType.STONE.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 4, Blocks.field_150348_b));
        IRON.addFoods(Items.field_151042_j);
        IRON.addFoods(Blocks.field_150366_p, Blocks.field_150339_S);
        BlocklingType.IRON.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234918_g_));
        BlocklingType.IRON.spawnPredicates.add((blockling, world) -> !BlocklingType.blockBelowIs(blockling, world, Blocks.field_196658_i));
        BlocklingType.IRON.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 8, Blocks.field_150366_p));
        QUARTZ.addFoods(Items.field_151128_bU);
        QUARTZ.addFoods(Blocks.field_196766_fg, Blocks.field_150371_ca);
        BlocklingType.QUARTZ.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234919_h_));
        BlocklingType.QUARTZ.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 8, Blocks.field_196766_fg));
        LAPIS.addFoods(Items.field_196128_bn);
        LAPIS.addFoods(Blocks.field_150369_x, Blocks.field_150368_y);
        BlocklingType.LAPIS.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234918_g_));
        BlocklingType.LAPIS.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 8, Blocks.field_150369_x));
        GOLD.addFoods(Items.field_151043_k);
        GOLD.addFoods(Blocks.field_150352_o, Blocks.field_150340_R);
        BlocklingType.GOLD.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234918_g_));
        BlocklingType.GOLD.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 8, Blocks.field_150352_o));
        EMERALD.addFoods(Items.field_151166_bC);
        EMERALD.addFoods(Blocks.field_150412_bA, Blocks.field_150475_bE);
        BlocklingType.EMERALD.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234918_g_));
        BlocklingType.EMERALD.spawnPredicates.add((blockling, world) -> BlocklingType.isInBiome(blockling, world, Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_185443_S, Biomes.field_185434_af, Biomes.field_76775_o, Biomes.field_185431_ac, Biomes.field_150590_f, Biomes.field_150580_W));
        BlocklingType.EMERALD.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 8, Blocks.field_150412_bA));
        DIAMOND.addFoods(Items.field_151045_i);
        DIAMOND.addFoods(Blocks.field_150482_ag, Blocks.field_150484_ah);
        BlocklingType.DIAMOND.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234918_g_));
        BlocklingType.DIAMOND.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 8, Blocks.field_150482_ag));
        NETHERITE.addFoods(Items.field_234760_kn_, Items.field_234759_km_);
        NETHERITE.addFoods(Blocks.field_235398_nh_, Blocks.field_235397_ng_);
        BlocklingType.NETHERITE.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234919_h_));
        BlocklingType.NETHERITE.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 12, Blocks.field_235398_nh_));
        OBSIDIAN.addFoods(Blocks.field_150343_Z);
        BlocklingType.OBSIDIAN.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234918_g_));
        BlocklingType.OBSIDIAN.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 8, Blocks.field_150343_Z));
        GLOWSTONE.addFoods(Items.field_151114_aO);
        GLOWSTONE.addFoods(Blocks.field_150426_aN);
        BlocklingType.GLOWSTONE.spawnPredicates.add((blockling, world) -> BlocklingType.isInWorld(blockling, world, World.field_234919_h_));
        BlocklingType.GLOWSTONE.spawnPredicates.add((blockling, world) -> BlocklingType.blockNearbyIs(blockling, world, 16, Blocks.field_150426_aN));
    }

    public BlocklingType(@Nonnull String key, int spawnRateReduction) {
        this.key = key;
        this.entityTexture = new BlocklingsResourceLocation("textures/entity/blockling/blockling_" + key + ".png");
        this.name = new BlocklingsTranslationTextComponent("type." + key);
        this.spawnRateReduction = spawnRateReduction + 1;
    }

    @Nonnull
    private static BlocklingType create(@Nonnull String key, int spawnRateReduction) {
        BlocklingType type = new BlocklingType(key, spawnRateReduction);
        TYPES.add(type);
        return type;
    }

    @Nonnull
    public static BlocklingType find(@Nonnull String key) {
        return TYPES.stream().filter(type -> type.key.equals(key)).findFirst().orElse(GRASS);
    }

    @Nonnull
    public static BlocklingType find(@Nonnull String key, @Nonnull Version version) {
        return BlocklingType.find(key);
    }

    @Nonnull
    private BlocklingType addCombatStats(float maxHealth, float attackDamage, float attackSpeed, float armour, float armourToughness, float knockbackResistance, float moveSpeed) {
        this.maxHealth = maxHealth;
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        this.armour = armour;
        this.armourToughness = armourToughness;
        this.knockbackResistance = knockbackResistance;
        this.moveSpeed = moveSpeed;
        return this;
    }

    @Nonnull
    private BlocklingType addGatheringStats(float miningSpeed, float woodcuttingSpeed, float farmingSpeed) {
        this.miningSpeed = miningSpeed;
        this.woodcuttingSpeed = woodcuttingSpeed;
        this.farmingSpeed = farmingSpeed;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public ResourceLocation getCombinedTexture(@Nonnull BlocklingType blocklingType, int variant) {
        if (((Boolean)BlocklingsConfig.CLIENT.disableDirtyBlocklings.get()).booleanValue()) {
            return blocklingType.entityTexture;
        }
        return new BlocklingsResourceLocation("textures/entity/blockling/blockling_" + this.key + "_merged_with_" + blocklingType.key + "_" + variant);
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public float getArmour() {
        return this.armour;
    }

    public float getMoveSpeed() {
        return this.moveSpeed;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public float getArmourToughness() {
        return this.armourToughness;
    }

    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getWoodcuttingSpeed() {
        return this.woodcuttingSpeed;
    }

    public float getFarmingSpeed() {
        return this.farmingSpeed;
    }

    @Nonnull
    public static BlocklingType findTypeForFood(@Nonnull ItemStack stack) {
        return BlocklingType.findTypeForFood(stack.func_77973_b());
    }

    @Nonnull
    public static BlocklingType findTypeForFood(@Nonnull Item item) {
        return Objects.requireNonNull(TYPES.stream().filter(blocklingType -> blocklingType.isFoodForType(item)).findFirst().orElse(null));
    }

    public static boolean isFood(@Nonnull ItemStack stack) {
        return BlocklingType.isFood(stack.func_77973_b());
    }

    public static boolean isFood(@Nonnull Item item) {
        return ItemUtil.isFlower(item) || FOODS.contains(item);
    }

    public boolean isFoodForType(@Nonnull ItemStack stack) {
        return this.isFoodForType(stack.func_77973_b());
    }

    public boolean isFoodForType(Item item) {
        return ItemUtil.isFlower(item) || this.foods.contains(item);
    }

    private void addFoods(Item ... items) {
        FOODS.addAll(Arrays.asList(items));
        this.foods.addAll(Arrays.asList(items));
    }

    private void addFoods(Block ... blocks) {
        FOODS.addAll(Arrays.stream(blocks).map(Item.field_179220_a::get).collect(Collectors.toList()));
        this.foods.addAll(Arrays.stream(blocks).map(Item.field_179220_a::get).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static boolean isInWorld(@Nonnull BlocklingEntity blockling, @Nonnull IWorld world, RegistryKey<World> ... worldTypes) {
        for (RegistryKey<World> worldType : worldTypes) {
            if (blockling.field_70170_p.func_234923_W_() != worldType) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    private static boolean isInBiome(@Nonnull BlocklingEntity blockling, @Nonnull IWorld world, RegistryKey<Biome> ... biomes) {
        for (RegistryKey<Biome> biome : biomes) {
            if (world.func_226691_t_(blockling.func_233580_cy_()).getRegistryName() != biome.getRegistryName()) continue;
            return true;
        }
        return false;
    }

    private static boolean canSeeSky(@Nonnull BlocklingEntity blockling, @Nonnull IWorld world) {
        return world.func_226660_f_(blockling.func_233580_cy_());
    }

    private static boolean blockBelowIs(@Nonnull BlocklingEntity blockling, @Nonnull IWorld world, Block ... blocks) {
        Block testBlock = world.func_180495_p(blockling.func_233580_cy_().func_177977_b()).func_177230_c();
        for (Block block : blocks) {
            if (testBlock != block) continue;
            return true;
        }
        return false;
    }

    private static boolean blockNearbyIs(@Nonnull BlocklingEntity blockling, @Nonnull IWorld world, int radius, Block ... blocks) {
        int startX = (int)blockling.func_226277_ct_() - radius;
        int startY = (int)blockling.func_226278_cu_() - radius;
        int startZ = (int)blockling.func_226281_cx_() - radius;
        int endX = (int)blockling.func_226277_ct_() + radius;
        int endY = (int)blockling.func_226278_cu_() + radius;
        int endZ = (int)blockling.func_226281_cx_() + radius;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    if (!world.isAreaLoaded(blockPos, 1)) continue;
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    for (Block block2 : blocks) {
                        if (block != block2) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

