/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.action;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.network.BlocklingMessage;
import com.willr27.blocklings.network.NetworkHandler;
import com.willr27.blocklings.util.PacketBufferUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public abstract class Action {
    public final BlocklingEntity blockling;
    public final String key;
    public final Authority authority;
    protected float count;
    protected final List<Runnable> callbacks = new ArrayList<Runnable>();

    public Action(@Nonnull BlocklingEntity blockling, @Nonnull String key, @Nonnull Authority authority) {
        this.blockling = blockling;
        this.key = key;
        this.authority = authority;
    }

    public void addCallback(@Nonnull Runnable callback) {
        this.callbacks.add(callback);
    }

    public void callCallbacks() {
        for (Runnable callback : this.callbacks) {
            callback.run();
        }
    }

    public boolean tryStart() {
        if (this.isRunning()) {
            return false;
        }
        this.start();
        return true;
    }

    public void start() {
        this.setCount(0.0f);
    }

    public void tick() {
        this.tick(1.0f);
    }

    public void tick(float increment) {
        if (this.isRunning()) {
            this.setCount(this.count + increment);
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.setCount(-1.0f);
        }
    }

    public boolean isRunning() {
        return this.count != -1.0f;
    }

    public float getCount() {
        return this.count;
    }

    public void setCount(float count) {
        this.setCount(count, this.isCorrectSide() && this.authority != Authority.NONE);
    }

    public void setCount(float count, boolean sync) {
        this.count = count;
        if (sync) {
            NetworkHandler.sync(this.blockling.field_70170_p, new CountMessage(this.blockling, this.key, count));
        }
    }

    public float percentThroughAction(float targetCount) {
        return this.getCount() / targetCount;
    }

    public boolean isCorrectSide() {
        return this.authority == Authority.BOTH || this.authority == Authority.NONE || this.authority == Authority.SERVER && !this.blockling.field_70170_p.field_72995_K || this.authority == Authority.CLIENT && this.blockling.field_70170_p.field_72995_K;
    }

    public static class CountMessage
    extends BlocklingMessage<CountMessage> {
        private String key;
        private float count;

        public CountMessage() {
            super(null);
        }

        public CountMessage(@Nullable BlocklingEntity blockling, @Nonnull String key, float count) {
            super(blockling);
            this.key = key;
            this.count = count;
        }

        @Override
        public void encode(@Nonnull PacketBuffer buf) {
            super.encode(buf);
            PacketBufferUtils.writeString(buf, this.key);
            buf.writeFloat(this.count);
        }

        @Override
        public void decode(@Nonnull PacketBuffer buf) {
            super.decode(buf);
            this.key = PacketBufferUtils.readString(buf);
            this.count = buf.readFloat();
        }

        @Override
        protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
            Action action = blockling.getActions().find(this.key);
            if (action != null) {
                action.setCount(this.count, false);
            }
        }
    }

    public static enum Authority {
        BOTH,
        CLIENT,
        SERVER,
        NONE;

    }
}

