/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.action;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.action.Action;
import com.willr27.blocklings.entity.blockling.action.actions.AttackAction;
import com.willr27.blocklings.entity.blockling.action.actions.KnownTargetAction;
import com.willr27.blocklings.entity.blockling.action.actions.UnknownTargetAction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BlocklingActions {
    @Nonnull
    public final KnownTargetAction ticks20;
    @Nonnull
    public final AttackAction attack;
    @Nonnull
    public final KnownTargetAction gather;
    @Nonnull
    public final KnownTargetAction regenerationCooldown;
    @Nonnull
    public final KnownTargetAction attacksCooldown;
    @Nonnull
    public final KnownTargetAction oresMinedCooldown;
    @Nonnull
    public final KnownTargetAction logsChoppedCooldown;
    @Nonnull
    public final KnownTargetAction cropsHarvestedCooldown;
    @Nonnull
    public final KnownTargetAction logRegenerationCooldown;
    @Nonnull
    private final List<Action> actions = new ArrayList<Action>();
    @Nonnull
    private final List<Action> actionsToAutoTick = new ArrayList<Action>();
    @Nonnull
    public final BlocklingEntity blockling;

    public BlocklingActions(@Nonnull BlocklingEntity blockling) {
        this.blockling = blockling;
        Supplier<Float> attackTargetSupplier = () -> Float.valueOf(5.0f + 50.0f / ((Float)blockling.getStats().attackSpeed.getValue()).floatValue());
        this.ticks20 = this.createAction("ticks_20", Action.Authority.SERVER, () -> Float.valueOf(20.0f), true);
        this.attack = this.createAction("attack", Action.Authority.BOTH, attackTargetSupplier, attackTargetSupplier, true);
        this.gather = this.createAction("gather", Action.Authority.BOTH, () -> Float.valueOf(1.0f), false);
        this.gather.setCount(-1.0f, false);
        this.regenerationCooldown = this.createAction("regeneration_cooldown", Action.Authority.BOTH, () -> Float.valueOf(400.0f), true);
        this.attacksCooldown = this.createAction("attacks_cooldown", Action.Authority.BOTH, () -> Float.valueOf(100.0f), true);
        this.oresMinedCooldown = this.createAction("ores_mined_cooldown", Action.Authority.BOTH, () -> Float.valueOf(100.0f), true);
        this.logsChoppedCooldown = this.createAction("logs_chopped_cooldown", Action.Authority.BOTH, () -> Float.valueOf(100.0f), true);
        this.cropsHarvestedCooldown = this.createAction("crops_harvested_cooldown", Action.Authority.BOTH, () -> Float.valueOf(100.0f), true);
        this.logRegenerationCooldown = this.createAction("log_regeneration_cooldown", Action.Authority.SERVER, () -> Float.valueOf(200.0f), true);
    }

    @Nonnull
    public UnknownTargetAction createAction(@Nonnull String key, @Nonnull Action.Authority authority, boolean autoTick) {
        UnknownTargetAction action = new UnknownTargetAction(this.blockling, key, authority);
        this.actions.add(action);
        if (autoTick) {
            this.actionsToAutoTick.add(action);
        }
        return action;
    }

    @Nonnull
    public KnownTargetAction createAction(@Nonnull String key, @Nonnull Action.Authority authority, @Nonnull Supplier<Float> targetCountSupplier, boolean autoTick) {
        KnownTargetAction action = new KnownTargetAction(this.blockling, key, authority, targetCountSupplier);
        this.actions.add(action);
        if (autoTick) {
            this.actionsToAutoTick.add(action);
        }
        return action;
    }

    @Nonnull
    public AttackAction createAction(@Nonnull String key, @Nonnull Action.Authority authority, @Nonnull Supplier<Float> targetCountSupplier, @Nonnull Supplier<Float> handTargetCountSupplier, boolean autoTick) {
        AttackAction action = new AttackAction(this, this.blockling, key, targetCountSupplier, handTargetCountSupplier);
        this.actions.add(action);
        if (autoTick) {
            this.actionsToAutoTick.add(action);
        }
        return action;
    }

    @Nullable
    public Action find(@Nonnull String key) {
        return this.actions.stream().filter(action -> action.key.equals(key)).findFirst().orElse(null);
    }

    public void tick() {
        this.actionsToAutoTick.stream().filter(action -> action.isCorrectSide() && (action.authority != Action.Authority.BOTH || !this.blockling.field_70170_p.field_72995_K)).forEach(Action::tick);
    }
}

