/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.action.actions;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import com.willr27.blocklings.entity.blockling.action.Action;
import com.willr27.blocklings.entity.blockling.action.BlocklingActions;
import com.willr27.blocklings.entity.blockling.action.actions.KnownTargetAction;
import com.willr27.blocklings.entity.blockling.attribute.attributes.EnumAttribute;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class AttackAction
extends KnownTargetAction {
    @Nonnull
    private final KnownTargetAction handAction;
    @Nonnull
    private final EnumAttribute<BlocklingHand> recentHand;

    public AttackAction(@Nonnull BlocklingActions actions, @Nonnull BlocklingEntity blockling, @Nonnull String key, @Nonnull Supplier<Float> targetCountSupplier, @Nonnull Supplier<Float> handTargetCountSupplier) {
        super(blockling, key, Action.Authority.BOTH, targetCountSupplier);
        Supplier<Float> supplier = () -> ((Float)handTargetCountSupplier.get()).floatValue() < 5.0f ? Float.valueOf(5.0f) : (Float)handTargetCountSupplier.get();
        this.handAction = actions.createAction(key + "_hand", Action.Authority.BOTH, supplier, true);
        this.handAction.setCount(-1.0f, false);
        this.recentHand = new EnumAttribute<BlocklingHand>(UUID.randomUUID().toString(), key + "_recent_hand", blockling, BlocklingHand.class, BlocklingHand.BOTH, null, null, true);
        blockling.getStats().addAttribute(this.recentHand);
    }

    public boolean tryStart(BlocklingHand hand) {
        if (super.tryStart()) {
            this.start(hand);
            return true;
        }
        return false;
    }

    public void start(BlocklingHand hand) {
        super.start();
        if (hand != BlocklingHand.NONE) {
            this.handAction.start();
        }
        this.recentHand.setValue(hand);
    }

    @Override
    public void start() {
        super.start();
        this.start(BlocklingHand.BOTH);
    }

    @Override
    public void stop() {
        super.stop();
        this.handAction.stop();
    }

    public boolean isRunning(BlocklingHand hand) {
        if (hand == BlocklingHand.MAIN && (this.getRecentHand() == BlocklingHand.MAIN || this.getRecentHand() == BlocklingHand.BOTH) || hand == BlocklingHand.OFF && (this.getRecentHand() == BlocklingHand.OFF || this.getRecentHand() == BlocklingHand.BOTH)) {
            return this.handAction.isRunning();
        }
        return false;
    }

    public boolean isFinished(BlocklingHand hand) {
        if (hand == BlocklingHand.MAIN && (this.getRecentHand() == BlocklingHand.MAIN || this.getRecentHand() == BlocklingHand.BOTH) || hand == BlocklingHand.OFF && (this.getRecentHand() == BlocklingHand.OFF || this.getRecentHand() == BlocklingHand.BOTH)) {
            return this.handAction.isFinished();
        }
        return false;
    }

    public float percentThroughHandAction() {
        return this.handAction.percentThroughAction();
    }

    public float percentThroughHandAction(float targetCount) {
        return this.handAction.percentThroughAction(targetCount);
    }

    @Nonnull
    public BlocklingHand getRecentHand() {
        return (BlocklingHand)((Object)this.recentHand.getValue());
    }
}

