/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.action.actions;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.action.Action;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class KnownTargetAction
extends Action {
    @Nonnull
    protected final Supplier<Float> targetCountSupplier;
    protected boolean isFinished = false;

    public KnownTargetAction(@Nonnull BlocklingEntity blockling, @Nonnull String key, @Nonnull Action.Authority authority, @Nonnull Supplier<Float> targetCountSupplier) {
        super(blockling, key, authority);
        this.targetCountSupplier = targetCountSupplier;
    }

    @Override
    public boolean tryStart() {
        if (this.isRunning() || this.isFinished) {
            return false;
        }
        this.start();
        return true;
    }

    @Override
    public void tick() {
        this.tick(1.0f);
    }

    @Override
    public void tick(float increment) {
        super.tick(increment);
        if (this.isFinished) {
            this.isFinished = false;
        }
        if (this.isRunning() && this.getCount() > this.targetCountSupplier.get().floatValue()) {
            this.stop();
            this.isFinished = true;
            this.callCallbacks();
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public float percentThroughAction() {
        return this.percentThroughAction(0.0f);
    }

    @Override
    public float percentThroughAction(float targetCount) {
        if (this.getCount() + targetCount < 0.0f) {
            return 1.0f;
        }
        return (this.getCount() + targetCount) / this.targetCountSupplier.get().floatValue();
    }
}

