/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.network.BlocklingMessage;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import com.willr27.blocklings.util.IReadWriteNBT;
import com.willr27.blocklings.util.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class Attribute<T>
implements IReadWriteNBT {
    @Nonnull
    public final UUID id;
    @Nonnull
    public final String key;
    @Nonnull
    public final BlocklingEntity blockling;
    @Nonnull
    public final World world;
    @Nonnull
    public final Function<T, String> displayStringValueFunction;
    @Nonnull
    public final Supplier<String> displayStringNameSupplier;
    @Nonnull
    protected final List<Consumer<T>> updateCallbacks = new ArrayList<Consumer<T>>();
    private boolean isEnabled = true;
    protected T value;

    public Attribute(@Nonnull String id, @Nonnull String key, @Nonnull BlocklingEntity blockling, boolean isEnabled) {
        this(id, key, blockling, null, null, isEnabled);
    }

    public Attribute(@Nonnull String id, @Nonnull String key, @Nonnull BlocklingEntity blockling, @Nullable Function<T, String> displayStringValueFunction, @Nullable Supplier<String> displayStringNameSupplier, boolean isEnabled) {
        this.id = UUID.fromString(id);
        this.key = key;
        this.blockling = blockling;
        this.world = blockling.field_70170_p;
        this.displayStringValueFunction = displayStringValueFunction == null ? v -> this.formatValue("%.1f") : displayStringValueFunction;
        this.displayStringNameSupplier = displayStringNameSupplier == null ? () -> this.createTranslation("name", new Object[0]).getString() : displayStringNameSupplier;
        this.isEnabled = isEnabled;
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT attributeTag) {
        attributeTag.func_74757_a("is_enabled", this.isEnabled);
        return attributeTag;
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT attributeTag, @Nonnull Version tagVersion) {
        this.isEnabled = attributeTag.func_74767_n("is_enabled");
    }

    public void encode(@Nonnull PacketBuffer buf) {
        buf.writeBoolean(this.isEnabled);
    }

    public void decode(@Nonnull PacketBuffer buf) {
        this.isEnabled = buf.readBoolean();
    }

    public T getValue() {
        return this.value;
    }

    protected void setValue(T value) {
        this.setValue(value, true);
    }

    protected abstract void setValue(T var1, boolean var2);

    public void onValueChanged() {
        this.updateCallbacks.forEach(floatConsumer -> floatConsumer.accept(this.getValue()));
    }

    public void addUpdateCallback(@Nonnull Consumer<T> callback) {
        this.updateCallbacks.add(callback);
    }

    @Nonnull
    public String formatValue(@Nonnull String format) {
        return String.format(format, this.getValue());
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.setIsEnabled(isEnabled, true);
    }

    public void setIsEnabled(boolean isEnabled, boolean sync) {
        this.isEnabled = isEnabled;
        this.onValueChanged();
        if (sync) {
            new IsEnabledMessage(this.blockling, this.blockling.getStats().attributes.indexOf(this), isEnabled).sync();
        }
    }

    @Nonnull
    public Function<T, String> getDisplayStringValueFunction() {
        return this.displayStringValueFunction;
    }

    @Nonnull
    public Supplier<String> getDisplayStringNameSupplier() {
        return this.displayStringNameSupplier;
    }

    @Nonnull
    public TranslationTextComponent createTranslation(@Nonnull String key, Object ... objects) {
        return new AttributeTranslationTextComponent(this.key + "." + key, objects);
    }

    public static abstract class ValueMessage<T, M extends BlocklingMessage<M>>
    extends BlocklingMessage<M> {
        protected int index;
        protected T value;

        public ValueMessage() {
            super(null);
        }

        public ValueMessage(@Nonnull BlocklingEntity blockling, int index, T value) {
            super(blockling);
            this.index = index;
            this.value = value;
        }

        @Override
        public void encode(@Nonnull PacketBuffer buf) {
            super.encode(buf);
            buf.writeInt(this.index);
            this.encodeValue(buf);
        }

        protected abstract void encodeValue(@Nonnull PacketBuffer var1);

        @Override
        public void decode(@Nonnull PacketBuffer buf) {
            super.decode(buf);
            this.index = buf.readInt();
            this.decodeValue(buf);
        }

        protected abstract void decodeValue(@Nonnull PacketBuffer var1);

        @Override
        protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
            blockling.getStats().attributes.get(this.index).setValue(this.value, false);
        }
    }

    public static class IsEnabledMessage
    extends BlocklingMessage<IsEnabledMessage> {
        private int index;
        private boolean isEnabled;

        public IsEnabledMessage() {
            super(null);
        }

        public IsEnabledMessage(@Nonnull BlocklingEntity blockling, int index, boolean isEnabled) {
            super(blockling);
            this.index = index;
            this.isEnabled = isEnabled;
        }

        @Override
        public void encode(@Nonnull PacketBuffer buf) {
            super.encode(buf);
            buf.writeInt(this.index);
            buf.writeBoolean(this.isEnabled);
        }

        @Override
        public void decode(@Nonnull PacketBuffer buf) {
            super.decode(buf);
            this.index = buf.readInt();
            this.isEnabled = buf.readBoolean();
        }

        @Override
        protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
            blockling.getStats().attributes.get(this.index).setIsEnabled(this.isEnabled, false);
        }
    }

    public static class AttributeTranslationTextComponent
    extends BlocklingsTranslationTextComponent {
        public AttributeTranslationTextComponent(String key, Object ... objects) {
            super("attribute." + key, objects);
        }
    }
}

