/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import com.willr27.blocklings.entity.blockling.BlocklingType;
import com.willr27.blocklings.entity.blockling.attribute.Attribute;
import com.willr27.blocklings.entity.blockling.attribute.IModifiable;
import com.willr27.blocklings.entity.blockling.attribute.IModifier;
import com.willr27.blocklings.entity.blockling.attribute.ModifiableAttribute;
import com.willr27.blocklings.entity.blockling.attribute.Operation;
import com.willr27.blocklings.entity.blockling.attribute.attributes.EnumAttribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.AveragedAttribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.FloatAttributeModifier;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.IntAttribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.ModifiableFloatAttribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.ModifiableFloatAttributeModifier;
import com.willr27.blocklings.entity.blockling.skill.info.SkillInfo;
import com.willr27.blocklings.entity.blockling.skill.skills.CombatSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.FarmingSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.GeneralSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.MiningSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.WoodcuttingSkills;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import com.willr27.blocklings.util.IReadWriteNBT;
import com.willr27.blocklings.util.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;

public class BlocklingAttributes
implements IReadWriteNBT {
    @Nonnull
    public final List<Attribute<?>> attributes = new ArrayList();
    @Nonnull
    public final List<IModifier<?>> modifiers = new ArrayList();
    public final IntAttribute combatLevel;
    public final IntAttribute miningLevel;
    public final IntAttribute woodcuttingLevel;
    public final IntAttribute farmingLevel;
    public final Attribute<Integer> totalLevel;
    public final IntAttribute combatXp;
    public final IntAttribute miningXp;
    public final IntAttribute woodcuttingXp;
    public final IntAttribute farmingXp;
    public final EnumAttribute<BlocklingHand> hand;
    public final ModifiableFloatAttribute maxHealth;
    public final ModifiableFloatAttributeModifier maxHealthBlocklingModifier;
    public final FloatAttributeModifier maxHealthTypeModifier;
    public final FloatAttributeModifier maxHealthCombatLevelModifier;
    public final ModifiableFloatAttributeModifier attackDamageBlocklingModifier;
    public final FloatAttributeModifier attackDamageTypeModifier;
    public final FloatAttributeModifier attackDamageCombatLevelModifier;
    public final FloatAttributeModifier attackDamageSkillSharpnessModifier;
    public final FloatAttributeModifier attackDamageSkillBerserkerModifier;
    public final FloatAttributeModifier attackDamageSkillWrecklessModifier;
    public final ModifiableFloatAttribute mainHandAttackDamage;
    public final FloatAttributeModifier mainHandAttackDamageToolModifier;
    public final ModifiableFloatAttribute offHandAttackDamage;
    public final FloatAttributeModifier offHandAttackDamageToolModifier;
    public final AveragedAttribute attackSpeed;
    public final ModifiableFloatAttributeModifier attackSpeedBlocklingModifier;
    public final FloatAttributeModifier attackSpeedTypeModifier;
    public final FloatAttributeModifier attackSpeedLevelModifier;
    public final ModifiableFloatAttributeModifier attackSpeedToolsModifier;
    public final FloatAttributeModifier attackSpeedMainHandModifier;
    public final FloatAttributeModifier attackSpeedOffHandModifier;
    public final FloatAttributeModifier attackSpeedSkillMomentumModifier;
    public final FloatAttributeModifier attackSpeedSkillPhotophileModifier;
    public final ModifiableFloatAttribute armour;
    public final ModifiableFloatAttributeModifier armourBlocklingModifier;
    public final FloatAttributeModifier armourCombatLevelModifier;
    public final FloatAttributeModifier armourTypeModifier;
    public final ModifiableFloatAttribute armourToughness;
    public final ModifiableFloatAttributeModifier armourToughnessBlocklingModifier;
    public final FloatAttributeModifier armourToughnessCombatLevelModifier;
    public final FloatAttributeModifier armourToughnessTypeModifier;
    public final ModifiableFloatAttribute knockbackResistance;
    public final ModifiableFloatAttributeModifier knockbackResistanceBlocklingModifier;
    public final FloatAttributeModifier knockbackResistanceCombatLevelModifier;
    public final FloatAttributeModifier knockbackResistanceTypeModifier;
    public final ModifiableFloatAttribute moveSpeed;
    public final ModifiableFloatAttributeModifier moveSpeedBlocklingModifier;
    public final FloatAttributeModifier moveSpeedTypeModifier;
    public final FloatAttributeModifier moveSpeedSkillSpeedModifier;
    public final ModifiableFloatAttribute miningRange;
    public final ModifiableFloatAttribute miningRangeSq;
    public final ModifiableFloatAttribute woodcuttingRange;
    public final ModifiableFloatAttribute woodcuttingRangeSq;
    public final ModifiableFloatAttribute farmingRange;
    public final ModifiableFloatAttribute farmingRangeSq;
    public final ModifiableFloatAttribute miningSpeed;
    public final ModifiableFloatAttributeModifier miningSpeedBlocklingModifier;
    public final FloatAttributeModifier miningSpeedTypeModifier;
    public final FloatAttributeModifier miningSpeedLevelModifier;
    public final FloatAttributeModifier miningSpeedMainHandModifier;
    public final FloatAttributeModifier miningSpeedOffHandModifier;
    public final FloatAttributeModifier miningSpeedSkillEfficiencyModifier;
    public final FloatAttributeModifier miningSpeedSkillAdrenalineModifier;
    public final FloatAttributeModifier miningSpeedSkillMomentumModifier;
    public final FloatAttributeModifier miningSpeedSkillHastyModifier;
    public final FloatAttributeModifier miningSpeedSkillNightOwlModifier;
    public final ModifiableFloatAttribute woodcuttingSpeed;
    public final ModifiableFloatAttributeModifier woodcuttingSpeedBlocklingModifier;
    public final FloatAttributeModifier woodcuttingSpeedTypeModifier;
    public final FloatAttributeModifier woodcuttingSpeedLevelModifier;
    public final FloatAttributeModifier woodcuttingSpeedMainHandModifier;
    public final FloatAttributeModifier woodcuttingSpeedOffHandModifier;
    public final FloatAttributeModifier woodcuttingSpeedSkillEfficiencyModifier;
    public final FloatAttributeModifier woodcuttingSpeedSkillAdrenalineModifier;
    public final FloatAttributeModifier woodcuttingSpeedSkillMomentumModifier;
    public final FloatAttributeModifier woodcuttingSpeedSkillHastyModifier;
    public final FloatAttributeModifier woodcuttingSpeedSkillNightOwlModifier;
    public final ModifiableFloatAttribute farmingSpeed;
    public final ModifiableFloatAttributeModifier farmingSpeedBlocklingModifier;
    public final FloatAttributeModifier farmingSpeedTypeModifier;
    public final FloatAttributeModifier farmingSpeedLevelModifier;
    public final FloatAttributeModifier farmingSpeedMainHandModifier;
    public final FloatAttributeModifier farmingSpeedOffHandModifier;
    public final FloatAttributeModifier farmingSpeedSkillEfficiencyModifier;
    public final FloatAttributeModifier farmingSpeedSkillAdrenalineModifier;
    public final FloatAttributeModifier farmingSpeedSkillMomentumModifier;
    public final FloatAttributeModifier farmingSpeedSkillHastyModifier;
    public final FloatAttributeModifier farmingSpeedSkillNightOwlModifier;
    @Nonnull
    public final BlocklingEntity blockling;
    @Nonnull
    public final World world;

    public BlocklingAttributes(@Nonnull BlocklingEntity blockling) {
        this.blockling = blockling;
        this.world = blockling.field_70170_p;
        this.combatLevel = new IntAttribute("17beee8e-3fca-4601-a766-46f811ad6b69", "combat_level", blockling, blockling.func_70681_au().nextInt(5) + 1, null, null, true);
        this.addAttribute(this.combatLevel);
        this.miningLevel = new IntAttribute("a2a62308-0a6e-41bb-9844-4645eeb72fb7", "mining_level", blockling, blockling.func_70681_au().nextInt(5) + 1, null, null, true);
        this.addAttribute(this.miningLevel);
        this.woodcuttingLevel = new IntAttribute("c6d3ce7c-52af-44df-833b-fede277eec7f", "woodcutting_level", blockling, blockling.func_70681_au().nextInt(5) + 1, null, null, true);
        this.addAttribute(this.woodcuttingLevel);
        this.farmingLevel = new IntAttribute("ac1c6d1b-18bb-435a-ad93-c24d6fa90816", "farming_level", blockling, blockling.func_70681_au().nextInt(5) + 1, null, null, true);
        this.addAttribute(this.farmingLevel);
        this.totalLevel = new Attribute<Integer>("ecd6a307-2f55-4d9b-96ab-f5efc82f8e5a", "total_level", blockling, true){

            @Override
            public Integer getValue() {
                return BlocklingAttributes.this.combatLevel.getValue() + BlocklingAttributes.this.miningLevel.getValue() + BlocklingAttributes.this.woodcuttingLevel.getValue() + BlocklingAttributes.this.farmingLevel.getValue();
            }

            @Override
            protected void setValue(Integer value, boolean sync) {
            }
        };
        this.combatXp = new IntAttribute("ec56a177-2a08-4f43-b77a-b1d4544a8656", "combat_xp", blockling, blockling.func_70681_au().nextInt(BlocklingAttributes.getXpForLevel(this.combatLevel.getValue())), null, null, true);
        this.addAttribute(this.combatXp);
        this.miningXp = new IntAttribute("ce581807-3fad-45b1-9aec-43ed0cb53c8f", "mining_xp", blockling, blockling.func_70681_au().nextInt(BlocklingAttributes.getXpForLevel(this.miningLevel.getValue())), null, null, true);
        this.addAttribute(this.miningXp);
        this.woodcuttingXp = new IntAttribute("82165063-6d47-4534-acc9-db3543c3db74", "woodcutting_xp", blockling, blockling.func_70681_au().nextInt(BlocklingAttributes.getXpForLevel(this.woodcuttingLevel.getValue())), null, null, true);
        this.addAttribute(this.woodcuttingXp);
        this.farmingXp = new IntAttribute("1f1e4cbc-358e-4477-92d8-03e818d5272c", "farming_xp", blockling, blockling.func_70681_au().nextInt(BlocklingAttributes.getXpForLevel(this.farmingLevel.getValue())), null, null, true);
        this.addAttribute(this.farmingXp);
        this.hand = new EnumAttribute<BlocklingHand>("f21fcbaa-f800-468e-8c22-ec4b4fd0fdc2", "hand", blockling, BlocklingHand.class, BlocklingHand.NONE, null, null, true);
        this.addAttribute(this.hand);
        this.maxHealthCombatLevelModifier = new FloatAttributeModifier("a78160fa-7bc3-493e-b74b-27af4206d111", "max_health_combat_level", blockling, 0.0f, Operation.ADD, null, this.combatLevel.displayStringNameSupplier, true);
        this.addModifier(this.maxHealthCombatLevelModifier);
        this.maxHealthTypeModifier = new FloatAttributeModifier("79043f39-6f44-4077-a358-0f75a0a1e995", "max_health_type", blockling, 0.0f, Operation.ADD, null, () -> blockling.getBlocklingType().name.getString(), true);
        this.addModifier(this.maxHealthTypeModifier);
        this.maxHealthBlocklingModifier = new ModifiableFloatAttributeModifier("42418962-175b-4c06-84a2-f770ebd00a88", "max_health_blockling", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_200201_e().getString(), true, this.maxHealthTypeModifier, this.maxHealthCombatLevelModifier);
        this.addModifier(this.maxHealthBlocklingModifier);
        this.maxHealth = new ModifiableFloatAttribute("9c6eb101-f025-4f8f-895b-10868b7d06b2", "max_health", blockling, 10.0f, null, null, true, new IModifier[]{this.maxHealthBlocklingModifier});
        this.addAttribute(this.maxHealth);
        this.attackDamageSkillWrecklessModifier = new FloatAttributeModifier("39b9820d-1805-484e-8bf0-9de9e12a878c", "attack_damage_skill_wreckless", blockling, 10.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(CombatSkills.WRECKLESS), false);
        this.addModifier(this.attackDamageSkillWrecklessModifier);
        this.attackDamageSkillBerserkerModifier = new FloatAttributeModifier("2d1bc0b1-53cc-46e7-8a15-93c3bb538cdc", "attack_damage_skill_berserker", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(CombatSkills.BERSERKER), false);
        this.addModifier(this.attackDamageSkillBerserkerModifier);
        this.attackDamageSkillSharpnessModifier = new FloatAttributeModifier("b27747e9-7e73-416f-bb1f-8853b4132e90", "attack_damage_skill_sharpness", blockling, 5.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(CombatSkills.SHARPNESS), false);
        this.addModifier(this.attackDamageSkillSharpnessModifier);
        this.attackDamageCombatLevelModifier = new FloatAttributeModifier("406a98f7-df1f-4c7f-93e4-990d71c7747f", "attack_damage_combat_level", blockling, 0.0f, Operation.ADD, null, this.combatLevel.displayStringNameSupplier, true);
        this.addModifier(this.attackDamageCombatLevelModifier);
        this.attackDamageTypeModifier = new FloatAttributeModifier("ddb441fc-2d8c-4950-b0a9-b96b60680ac1", "attack_damage_type", blockling, 0.0f, Operation.ADD, null, () -> blockling.getBlocklingType().name.getString(), true);
        this.addModifier(this.attackDamageTypeModifier);
        this.attackDamageBlocklingModifier = new ModifiableFloatAttributeModifier("9bfdfe35-c6c4-4364-8535-7aa50927f484", "attack_damage_blockling", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_200201_e().getString(), true, this.attackDamageTypeModifier, this.attackDamageCombatLevelModifier);
        this.addModifier(this.attackDamageBlocklingModifier);
        this.attackDamageSkillWrecklessModifier.setVanillaAttribute(Attributes.field_233823_f_);
        this.attackDamageSkillBerserkerModifier.setVanillaAttribute(Attributes.field_233823_f_);
        this.attackDamageSkillSharpnessModifier.setVanillaAttribute(Attributes.field_233823_f_);
        this.attackDamageBlocklingModifier.setVanillaAttribute(Attributes.field_233823_f_);
        this.mainHandAttackDamageToolModifier = new FloatAttributeModifier("2ae58b89-fed6-4b2f-90bc-e7dbc9d7b249", "main_hand_attack_damage_tool", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_184614_ca().func_200301_q().getString(), true);
        this.addModifier(this.mainHandAttackDamageToolModifier);
        this.mainHandAttackDamage = new ModifiableFloatAttribute("e8549f17-e473-4849-8f48-ae624ee0c242", "main_hand_attack_damage", blockling, 0.0f, null, null, true, new IModifier[]{this.attackDamageBlocklingModifier, this.mainHandAttackDamageToolModifier, this.attackDamageSkillSharpnessModifier, this.attackDamageSkillBerserkerModifier, this.attackDamageSkillWrecklessModifier});
        this.addAttribute(this.mainHandAttackDamage);
        this.offHandAttackDamageToolModifier = new FloatAttributeModifier("c1aa1629-fe40-47eb-8c5c-a02d0b82e636", "off_hand_attack_damage_tool", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_184592_cb().func_200301_q().getString(), true);
        this.addModifier(this.offHandAttackDamageToolModifier);
        this.offHandAttackDamage = new ModifiableFloatAttribute("519e98de-c213-4c1c-8a07-cd659bc9982c", "off_hand_attack_damage", blockling, 0.0f, null, null, true, new IModifier[]{this.attackDamageBlocklingModifier, this.offHandAttackDamageToolModifier, this.attackDamageSkillSharpnessModifier, this.attackDamageSkillBerserkerModifier, this.attackDamageSkillWrecklessModifier});
        this.addAttribute(this.offHandAttackDamage);
        this.attackSpeedSkillPhotophileModifier = new FloatAttributeModifier("8f7b5867-918a-46b0-bcfb-6ae470220171", "attack_speed_skill_photophile", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(CombatSkills.PHOTOPHILE), false);
        this.addModifier(this.attackSpeedSkillPhotophileModifier);
        this.attackSpeedSkillMomentumModifier = new FloatAttributeModifier("b97dcf6f-d1e4-4988-aa42-819e79af4a02", "attack_speed_skill_momentum", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(CombatSkills.MOMENTUM), false);
        this.addModifier(this.attackSpeedSkillMomentumModifier);
        this.attackSpeedOffHandModifier = new FloatAttributeModifier("3566961d-db2b-4833-8c0c-cf6813ade8cc", "attack_speed_off_hand", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_184592_cb().func_200301_q().getString(), true);
        this.addModifier(this.attackSpeedOffHandModifier);
        this.attackSpeedMainHandModifier = new FloatAttributeModifier("87343a1e-7a0b-4963-8d7e-e95f809e90ee", "attack_speed_main_hand", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_184614_ca().func_200301_q().getString(), true);
        this.addModifier(this.attackSpeedMainHandModifier);
        this.attackSpeedToolsModifier = new ModifiableFloatAttributeModifier("8642d8f0-7554-4764-a58d-ee926c808fc8", "attack_speed_tools", blockling, 0.0f, Operation.ADD, null, null, true, this.attackSpeedMainHandModifier, this.attackSpeedOffHandModifier);
        this.addModifier(this.attackSpeedToolsModifier);
        this.attackSpeedLevelModifier = new FloatAttributeModifier("bfeb22fe-aaaf-4294-9850-27449e27e44f", "attack_speed_level", blockling, 0.0f, Operation.ADD, null, this.combatLevel.displayStringNameSupplier, true);
        this.addModifier(this.attackSpeedLevelModifier);
        this.attackSpeedTypeModifier = new FloatAttributeModifier("f40d211d-c6fd-449a-a2f8-8bffd24ac810", "attack_speed_type", blockling, 0.0f, Operation.ADD, null, () -> blockling.getBlocklingType().name.getString(), true);
        this.addModifier(this.attackSpeedTypeModifier);
        this.attackSpeedBlocklingModifier = new ModifiableFloatAttributeModifier("8c4e3d41-2a17-4cd1-8dbb-8866008960a5", "attack_speed_blockling", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_200201_e().getString(), true, this.attackSpeedTypeModifier, this.attackSpeedLevelModifier);
        this.addModifier(this.attackSpeedBlocklingModifier);
        this.attackSpeed = new AveragedAttribute("4cbc129d-281d-410e-bba0-45d4e064932a", "attack_speed", blockling, 0.0f, null, null, true, new IModifier[]{this.attackSpeedBlocklingModifier, this.attackSpeedToolsModifier, this.attackSpeedSkillMomentumModifier, this.attackSpeedSkillPhotophileModifier});
        this.addAttribute(this.attackSpeed);
        this.armourCombatLevelModifier = new FloatAttributeModifier("15f2f2ce-cdf1-4188-882e-67ceab22df41", "armour_combat_level", blockling, 0.0f, Operation.ADD, null, this.combatLevel.displayStringNameSupplier, true);
        this.addModifier(this.armourCombatLevelModifier);
        this.armourTypeModifier = new FloatAttributeModifier("a72fb401-abb7-4d95-ad7e-e83fc6a399d1", "armour_type", blockling, 0.0f, Operation.ADD, null, () -> blockling.getBlocklingType().name.getString(), true);
        this.addModifier(this.armourTypeModifier);
        this.armourBlocklingModifier = new ModifiableFloatAttributeModifier("1e5b8f41-bab6-41f9-9a3d-5303f2f1ed6e", "armour_blockling", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_200201_e().getString(), true, this.armourTypeModifier, this.armourCombatLevelModifier);
        this.addModifier(this.armourBlocklingModifier);
        this.armour = new ModifiableFloatAttribute("6b34a986-f1ad-4476-a1c6-700d841fb1ec", "armour", blockling, 0.0f, null, null, true, new IModifier[]{this.armourBlocklingModifier});
        this.addAttribute(this.armour);
        this.armourToughnessCombatLevelModifier = new FloatAttributeModifier("0f438ab0-2e72-4555-840f-3b3dc2335014", "armour_toughness_combat_level", blockling, 0.0f, Operation.ADD, null, this.combatLevel.displayStringNameSupplier, true);
        this.addModifier(this.armourToughnessCombatLevelModifier);
        this.armourToughnessTypeModifier = new FloatAttributeModifier("4f806fa7-1ebe-4426-99c6-5c0d0f41be25", "armour_toughness_type", blockling, 0.0f, Operation.ADD, null, () -> blockling.getBlocklingType().name.getString(), true);
        this.addModifier(this.armourToughnessTypeModifier);
        this.armourToughnessBlocklingModifier = new ModifiableFloatAttributeModifier("9f08c15b-fa91-4c1e-97ef-4b465936c5ab", "armour_toughness_blockling", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_200201_e().getString(), true, this.armourToughnessTypeModifier, this.armourToughnessCombatLevelModifier);
        this.addModifier(this.armourToughnessBlocklingModifier);
        this.armourToughness = new ModifiableFloatAttribute("1cfdad6a-0bd3-461f-8007-c0a591a30783", "armour_toughness", blockling, 0.0f, null, null, true, new IModifier[]{this.armourToughnessBlocklingModifier});
        this.addAttribute(this.armourToughness);
        this.knockbackResistanceCombatLevelModifier = new FloatAttributeModifier("711cf234-2f57-413c-be3d-ce4c5f809b86", "knockback_resistance_combat_level", blockling, 0.0f, Operation.ADD, v -> String.format("%.0f%%", Float.valueOf(v.floatValue() * 100.0f)), this.combatLevel.displayStringNameSupplier, true);
        this.addModifier(this.knockbackResistanceCombatLevelModifier);
        this.knockbackResistanceTypeModifier = new FloatAttributeModifier("eb217d5e-6e7d-4ef0-9ca1-153a7bc18593", "knockback_resistance_type", blockling, 0.0f, Operation.ADD, v -> String.format("%.0f%%", Float.valueOf(v.floatValue() * 100.0f)), () -> blockling.getBlocklingType().name.getString(), true);
        this.addModifier(this.knockbackResistanceTypeModifier);
        this.knockbackResistanceBlocklingModifier = new ModifiableFloatAttributeModifier("3b6bf894-3beb-42f5-b516-759bacf9acab", "knockback_resistance_blockling", blockling, 0.0f, Operation.ADD, v -> String.format("%.0f%%", Float.valueOf(v.floatValue() * 100.0f)), () -> blockling.func_200201_e().getString(), true, this.knockbackResistanceTypeModifier, this.knockbackResistanceCombatLevelModifier);
        this.addModifier(this.knockbackResistanceBlocklingModifier);
        this.knockbackResistance = new ModifiableFloatAttribute("ddc90fc2-4a68-4c30-8701-d2d9dbe8b94a", "knockback_resistance", blockling, 0.0f, v -> String.format("%.0f%%", Float.valueOf(v.floatValue() * 100.0f)), null, true, new IModifier[]{this.knockbackResistanceBlocklingModifier});
        this.addAttribute(this.knockbackResistance);
        this.moveSpeedSkillSpeedModifier = new FloatAttributeModifier("38ae3f89-349e-4b99-a8a1-d2b7a7b585c2", "move_speed_skill_speed", blockling, 1.0f, Operation.MULTIPLY_TOTAL, v -> String.format("%.0f%%", Float.valueOf((v.floatValue() - 1.0f) * 100.0f)), this::speedSkillDisplayNameProvider, true);
        this.addModifier(this.moveSpeedSkillSpeedModifier);
        this.moveSpeedTypeModifier = new FloatAttributeModifier("6f685317-7be6-4ea8-ae63-b1c907209040", "move_speed_type", blockling, 0.0f, Operation.ADD, null, () -> blockling.getBlocklingType().name.getString(), true);
        this.addModifier(this.moveSpeedTypeModifier);
        this.moveSpeedBlocklingModifier = new ModifiableFloatAttributeModifier("f4300b1a-ee93-4d36-a457-4d71c349a4ab", "move_speed_blockling", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_200201_e().getString(), true, this.moveSpeedTypeModifier);
        this.addModifier(this.moveSpeedBlocklingModifier);
        this.moveSpeed = new ModifiableFloatAttribute("9a0bb639-8543-4725-9be1-8a8ce688da70", "move_speed", blockling, 0.0f, null, null, true, new IModifier[]{this.moveSpeedBlocklingModifier, this.moveSpeedSkillSpeedModifier});
        this.addAttribute(this.moveSpeed);
        this.miningRange = new ModifiableFloatAttribute("76e044ca-e73e-4004-b576-920a8446612d", "mining_range", blockling, 2.5f, null, null, true, new IModifier[0]);
        this.addAttribute(this.miningRange);
        this.miningRangeSq = new ModifiableFloatAttribute("55af3992-cf8d-4d5d-8634-fbc1e05d30fe", "mining_range_sq", blockling, ((Float)this.miningRange.getValue()).floatValue() * ((Float)this.miningRange.getValue()).floatValue(), null, null, true, new IModifier[0]);
        this.addAttribute(this.miningRangeSq);
        this.woodcuttingRange = new ModifiableFloatAttribute("bc50cc2d-2323-4743-a175-5af87e61e04e", "woodcutting_range", blockling, 2.5f, null, null, true, new IModifier[0]);
        this.addAttribute(this.woodcuttingRange);
        this.woodcuttingRangeSq = new ModifiableFloatAttribute("8ba7fea6-6790-4010-b210-fa69b1effad8", "woodcutting_range_sq", blockling, ((Float)this.woodcuttingRange.getValue()).floatValue() * ((Float)this.woodcuttingRange.getValue()).floatValue(), null, null, true, new IModifier[0]);
        this.addAttribute(this.woodcuttingRangeSq);
        this.farmingRange = new ModifiableFloatAttribute("c549a710-62d9-4d79-8d9d-ba3690752d08", "farming_range", blockling, 2.5f, null, null, true, new IModifier[0]);
        this.addAttribute(this.farmingRange);
        this.farmingRangeSq = new ModifiableFloatAttribute("bc3a8f41-d033-437f-bce2-840df7a55fad", "farming_range_sq", blockling, ((Float)this.farmingRange.getValue()).floatValue() * ((Float)this.farmingRange.getValue()).floatValue(), null, null, true, new IModifier[0]);
        this.addAttribute(this.farmingRangeSq);
        this.miningSpeedSkillNightOwlModifier = new FloatAttributeModifier("f858c34f-d215-450a-847d-a54525d2f82f", "mining_speed_skill_night_owl", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(MiningSkills.NIGHT_OWL), false);
        this.addModifier(this.miningSpeedSkillNightOwlModifier);
        this.miningSpeedSkillHastyModifier = new FloatAttributeModifier("035c4e96-a628-4b20-9699-28ade0fa5a80", "mining_speed_skill_hasty", blockling, 10.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(MiningSkills.HASTY), false);
        this.addModifier(this.miningSpeedSkillHastyModifier);
        this.miningSpeedSkillMomentumModifier = new FloatAttributeModifier("1ca4d69f-05b8-4598-97c5-95f6bc750b7a", "mining_speed_skill_momentum", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(MiningSkills.MOMENTUM), false);
        this.addModifier(this.miningSpeedSkillMomentumModifier);
        this.miningSpeedSkillAdrenalineModifier = new FloatAttributeModifier("1543fadc-3a9e-412b-819b-a6379a0911ca", "mining_speed_skill_adrenaline", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(MiningSkills.ADRENALINE), false);
        this.addModifier(this.miningSpeedSkillAdrenalineModifier);
        this.miningSpeedSkillEfficiencyModifier = new FloatAttributeModifier("9464fc16-0f3c-438f-ac0b-8715a3542aaa", "mining_speed_skill_efficiency", blockling, 1.1f, Operation.MULTIPLY_TOTAL, v -> String.format("%.0f%%", Float.valueOf((v.floatValue() - 1.0f) * 100.0f)), () -> this.skillDisplayNameProvider(MiningSkills.EFFICIENCY), false);
        this.addModifier(this.miningSpeedSkillEfficiencyModifier);
        this.miningSpeedOffHandModifier = new FloatAttributeModifier("aada86a0-4233-47cf-b5ab-aa208a216bb5", "mining_speed_off_hand", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_184592_cb().func_200301_q().getString(), true);
        this.addModifier(this.miningSpeedOffHandModifier);
        this.miningSpeedMainHandModifier = new FloatAttributeModifier("fc0dd885-273b-4465-a9ff-e801dcaf07e2", "mining_speed_main_hand", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_184614_ca().func_200301_q().getString(), true);
        this.addModifier(this.miningSpeedMainHandModifier);
        this.miningSpeedLevelModifier = new FloatAttributeModifier("f0914966-d53a-4292-b48c-5595f944f5d2", "mining_speed_level", blockling, 0.0f, Operation.ADD, null, this.miningLevel.displayStringNameSupplier, true);
        this.addModifier(this.miningSpeedLevelModifier);
        this.miningSpeedTypeModifier = new FloatAttributeModifier("565dea40-53ac-4861-bc6c-1eafce77f80f", "mining_speed_type", blockling, 0.0f, Operation.ADD, null, () -> blockling.getBlocklingType().name.getString(), true);
        this.addModifier(this.miningSpeedTypeModifier);
        this.miningSpeedBlocklingModifier = new ModifiableFloatAttributeModifier("1e9d4f59-e3a5-410b-a3dd-c9dce952f22d", "mining_speed_blockling", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_200201_e().getString(), true, this.miningSpeedTypeModifier, this.miningSpeedLevelModifier);
        this.addModifier(this.miningSpeedBlocklingModifier);
        this.miningSpeed = new ModifiableFloatAttribute("0d918c08-2e94-481b-98e1-c2ff3ae395de", "mining_speed", blockling, 0.0f, null, null, true, new IModifier[]{this.miningSpeedBlocklingModifier, this.miningSpeedMainHandModifier, this.miningSpeedOffHandModifier, this.miningSpeedSkillEfficiencyModifier, this.miningSpeedSkillAdrenalineModifier, this.miningSpeedSkillMomentumModifier, this.miningSpeedSkillHastyModifier, this.miningSpeedSkillNightOwlModifier});
        this.addAttribute(this.miningSpeed);
        this.woodcuttingSpeedSkillNightOwlModifier = new FloatAttributeModifier("adbe5ab0-4a08-4335-a68a-964b9126c40f", "woodcutting_speed_skill_night_owl", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(WoodcuttingSkills.NIGHT_OWL), false);
        this.addModifier(this.woodcuttingSpeedSkillNightOwlModifier);
        this.woodcuttingSpeedSkillHastyModifier = new FloatAttributeModifier("38709558-3da6-4f86-896f-195e84c18525", "woodcutting_speed_skill_hasty", blockling, 10.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(WoodcuttingSkills.HASTY), false);
        this.addModifier(this.woodcuttingSpeedSkillHastyModifier);
        this.woodcuttingSpeedSkillMomentumModifier = new FloatAttributeModifier("868bba90-a29c-4b70-b599-c3f56b00928e", "woodcutting_speed_skill_momentum", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(WoodcuttingSkills.MOMENTUM), false);
        this.addModifier(this.woodcuttingSpeedSkillMomentumModifier);
        this.woodcuttingSpeedSkillAdrenalineModifier = new FloatAttributeModifier("e832c5da-0465-4a63-96b7-398eb32ba206", "woodcutting_speed_skill_adrenaline", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(WoodcuttingSkills.ADRENALINE), false);
        this.addModifier(this.woodcuttingSpeedSkillAdrenalineModifier);
        this.woodcuttingSpeedSkillEfficiencyModifier = new FloatAttributeModifier("38a9d80c-4f96-4929-bd34-8c03156dec6d", "woodcutting_speed_skill_efficiency", blockling, 1.1f, Operation.MULTIPLY_TOTAL, v -> String.format("%.0f%%", Float.valueOf((v.floatValue() - 1.0f) * 100.0f)), () -> this.skillDisplayNameProvider(WoodcuttingSkills.EFFICIENCY), false);
        this.addModifier(this.woodcuttingSpeedSkillEfficiencyModifier);
        this.woodcuttingSpeedOffHandModifier = new FloatAttributeModifier("80fd0028-a793-491c-bc9c-fe94071f91c7", "woodcutting_speed_off_hand", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_184592_cb().func_200301_q().getString(), true);
        this.addModifier(this.woodcuttingSpeedOffHandModifier);
        this.woodcuttingSpeedMainHandModifier = new FloatAttributeModifier("978f9dd4-3fbb-41ee-9bba-eddcfb42b6ff", "woodcutting_speed_main_hand", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_184614_ca().func_200301_q().getString(), true);
        this.addModifier(this.woodcuttingSpeedMainHandModifier);
        this.woodcuttingSpeedLevelModifier = new FloatAttributeModifier("6b71ee16-7d04-442e-9d49-9373833f5539", "woodcutting_speed_level", blockling, 0.0f, Operation.ADD, null, this.woodcuttingLevel.displayStringNameSupplier, true);
        this.addModifier(this.woodcuttingSpeedLevelModifier);
        this.woodcuttingSpeedTypeModifier = new FloatAttributeModifier("a66110e2-3a7f-4907-b85c-05c65341cd2e", "woodcutting_speed_type", blockling, 0.0f, Operation.ADD, null, () -> blockling.getBlocklingType().name.getString(), true);
        this.addModifier(this.woodcuttingSpeedTypeModifier);
        this.woodcuttingSpeedBlocklingModifier = new ModifiableFloatAttributeModifier("51a21884-8c41-49d8-bae4-f21866b58718", "woodcutting_speed_blockling", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_200201_e().getString(), true, this.woodcuttingSpeedTypeModifier, this.woodcuttingSpeedLevelModifier);
        this.addModifier(this.woodcuttingSpeedBlocklingModifier);
        this.woodcuttingSpeed = new ModifiableFloatAttribute("e1e3ecb3-ae1d-46c5-8ea8-a7180641910b", "woodcutting_speed", blockling, 0.0f, null, null, true, new IModifier[]{this.woodcuttingSpeedBlocklingModifier, this.woodcuttingSpeedMainHandModifier, this.woodcuttingSpeedOffHandModifier, this.woodcuttingSpeedSkillEfficiencyModifier, this.woodcuttingSpeedSkillAdrenalineModifier, this.woodcuttingSpeedSkillMomentumModifier, this.woodcuttingSpeedSkillHastyModifier, this.woodcuttingSpeedSkillNightOwlModifier});
        this.addAttribute(this.woodcuttingSpeed);
        this.farmingSpeedSkillNightOwlModifier = new FloatAttributeModifier("451f37a9-649e-44a3-a21f-d76e49f1afd0", "farming_speed_skill_night_owl", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(FarmingSkills.NIGHT_OWL), false);
        this.addModifier(this.farmingSpeedSkillNightOwlModifier);
        this.farmingSpeedSkillHastyModifier = new FloatAttributeModifier("3f045e39-8185-4d2c-8980-54e06f8d548b", "farming_speed_skill_hasty", blockling, 10.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(FarmingSkills.HASTY), false);
        this.addModifier(this.farmingSpeedSkillHastyModifier);
        this.farmingSpeedSkillMomentumModifier = new FloatAttributeModifier("d58d5336-d2fe-447d-a237-bb0bbff313d7", "farming_speed_skill_momentum", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(FarmingSkills.MOMENTUM), false);
        this.addModifier(this.farmingSpeedSkillMomentumModifier);
        this.farmingSpeedSkillAdrenalineModifier = new FloatAttributeModifier("79f7d5ff-2fd7-4385-a795-c281f984445b", "farming_speed_skill_adrenaline", blockling, 0.0f, Operation.ADD, null, () -> this.skillDisplayNameProvider(FarmingSkills.ADRENALINE), false);
        this.addModifier(this.farmingSpeedSkillAdrenalineModifier);
        this.farmingSpeedSkillEfficiencyModifier = new FloatAttributeModifier("792be316-19cb-49ec-a24a-ee224312c60f", "farming_speed_skill_efficiency", blockling, 1.1f, Operation.MULTIPLY_TOTAL, v -> String.format("%.0f%%", Float.valueOf((v.floatValue() - 1.0f) * 100.0f)), () -> this.skillDisplayNameProvider(FarmingSkills.EFFICIENCY), false);
        this.addModifier(this.farmingSpeedSkillEfficiencyModifier);
        this.farmingSpeedOffHandModifier = new FloatAttributeModifier("b4bb7131-f2ce-41cd-88ed-ee27e3837679", "farming_speed_off_hand", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_184592_cb().func_200301_q().getString(), true);
        this.addModifier(this.farmingSpeedOffHandModifier);
        this.farmingSpeedMainHandModifier = new FloatAttributeModifier("5ece4240-17b3-4983-bd0d-67f962a0a838", "farming_speed_main_hand", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_184614_ca().func_200301_q().getString(), true);
        this.addModifier(this.farmingSpeedMainHandModifier);
        this.farmingSpeedLevelModifier = new FloatAttributeModifier("3b3079cf-8640-436b-bf0a-3aae4deb29be", "farming_speed_level", blockling, 0.0f, Operation.ADD, null, this.farmingLevel.displayStringNameSupplier, true);
        this.addModifier(this.farmingSpeedLevelModifier);
        this.farmingSpeedTypeModifier = new FloatAttributeModifier("f99bbc83-30fc-451f-a53b-fa343cc9244a", "farming_speed_type", blockling, 0.0f, Operation.ADD, null, () -> blockling.getBlocklingType().name.getString(), true);
        this.addModifier(this.farmingSpeedTypeModifier);
        this.farmingSpeedBlocklingModifier = new ModifiableFloatAttributeModifier("39548773-84ee-42ca-8ad6-681d64eaee54", "farming_speed_blockling", blockling, 0.0f, Operation.ADD, null, () -> blockling.func_200201_e().getString(), true, this.farmingSpeedTypeModifier, this.farmingSpeedLevelModifier);
        this.addModifier(this.farmingSpeedBlocklingModifier);
        this.farmingSpeed = new ModifiableFloatAttribute("f6c026b6-1fa9-432f-aca3-d97af784f6d0", "farming_speed", blockling, 0.0f, null, null, true, new IModifier[]{this.farmingSpeedBlocklingModifier, this.farmingSpeedMainHandModifier, this.farmingSpeedOffHandModifier, this.farmingSpeedSkillEfficiencyModifier, this.farmingSpeedSkillAdrenalineModifier, this.farmingSpeedSkillMomentumModifier, this.farmingSpeedSkillHastyModifier, this.farmingSpeedSkillNightOwlModifier});
        this.addAttribute(this.farmingSpeed);
    }

    public void applyVanillaModifier(@Nonnull net.minecraft.entity.ai.attributes.Attribute vanillaAttribute, @Nonnull FloatAttributeModifier modifier) {
        ModifiableAttributeInstance attributeInstance = this.blockling.func_110148_a(vanillaAttribute);
        attributeInstance.func_188479_b(modifier.id);
        if (modifier.isEnabled()) {
            attributeInstance.func_233767_b_(new AttributeModifier(modifier.id, modifier.getDisplayStringNameSupplier().get(), (double)modifier.getValue().floatValue(), Operation.vanillaOperation(modifier.getOperation())));
        }
    }

    @Nonnull
    private String skillDisplayNameProvider(@Nonnull SkillInfo skillInfo) {
        return skillInfo.general.name.getString() + " (" + new BlocklingsTranslationTextComponent("skill.name").getString() + ")";
    }

    @Nonnull
    private String speedSkillDisplayNameProvider() {
        if (this.blockling.getSkills().getSkill(GeneralSkills.SPEED_3).isBought()) {
            return this.skillDisplayNameProvider(GeneralSkills.SPEED_3);
        }
        if (this.blockling.getSkills().getSkill(GeneralSkills.SPEED_2).isBought()) {
            return this.skillDisplayNameProvider(GeneralSkills.SPEED_2);
        }
        return this.skillDisplayNameProvider(GeneralSkills.SPEED_1);
    }

    public void addAttribute(@Nonnull Attribute<?> attribute) {
        this.attributes.add(attribute);
    }

    public <V, T extends Attribute<V>> void addModifier(@Nonnull T modifier) {
        this.attributes.add(modifier);
        this.modifiers.add((IModifier<?>)((Object)modifier));
    }

    public void init() {
        for (Attribute<?> attribute : this.attributes) {
            if (!(attribute instanceof IModifiable)) continue;
            ((ModifiableAttribute)attribute).calculate();
        }
        for (Attribute<?> attribute : this.attributes) {
            attribute.onValueChanged();
        }
        this.updateCombatLevelBonuses(false);
        this.updateTypeBonuses(false);
    }

    public void initUpdateCallbacks() {
        this.combatLevel.addUpdateCallback(i -> {
            this.updateCombatLevelBonuses(false);
            this.updateOnLevelChange(Level.COMBAT);
        });
        this.miningLevel.addUpdateCallback(i -> {
            this.miningSpeedLevelModifier.setValue(Float.valueOf(this.calcBonusHarvestSpeedFromLevel((int)i)), false);
            this.updateOnLevelChange(Level.MINING);
        });
        this.woodcuttingLevel.addUpdateCallback(i -> {
            this.woodcuttingSpeedLevelModifier.setValue(Float.valueOf(this.calcBonusHarvestSpeedFromLevel((int)i)), false);
            this.updateOnLevelChange(Level.WOODCUTTING);
        });
        this.farmingLevel.addUpdateCallback(i -> {
            this.farmingSpeedLevelModifier.setValue(Float.valueOf(this.calcBonusHarvestSpeedFromLevel((int)i)), false);
            this.updateOnLevelChange(Level.FARMING);
        });
        this.combatXp.addUpdateCallback(i -> this.checkForLevelUpAndUpdate(false));
        this.miningXp.addUpdateCallback(i -> this.checkForLevelUpAndUpdate(false));
        this.woodcuttingXp.addUpdateCallback(i -> this.checkForLevelUpAndUpdate(false));
        this.farmingXp.addUpdateCallback(i -> this.checkForLevelUpAndUpdate(false));
        this.maxHealth.addUpdateCallback(f -> {
            Objects.requireNonNull(this.blockling.func_110148_a(Attributes.field_233818_a_)).func_111128_a((double)f.floatValue());
            this.checkAndCapHealth();
        });
        this.attackSpeed.addUpdateCallback(f -> Objects.requireNonNull(this.blockling.func_110148_a(Attributes.field_233825_h_)).func_111128_a((double)f.floatValue()));
        this.armour.addUpdateCallback(f -> Objects.requireNonNull(this.blockling.func_110148_a(Attributes.field_233826_i_)).func_111128_a((double)f.floatValue()));
        this.armourToughness.addUpdateCallback(f -> Objects.requireNonNull(this.blockling.func_110148_a(Attributes.field_233827_j_)).func_111128_a((double)f.floatValue()));
        this.knockbackResistance.addUpdateCallback(f -> Objects.requireNonNull(this.blockling.func_110148_a(Attributes.field_233820_c_)).func_111128_a((double)f.floatValue()));
        this.moveSpeed.addUpdateCallback(f -> Objects.requireNonNull(this.blockling.func_110148_a(Attributes.field_233821_d_)).func_111128_a((double)(f.floatValue() / 10.0f)));
        this.miningRange.addUpdateCallback(f -> this.miningRangeSq.setBaseValue(Float.valueOf(((Float)this.miningRange.getValue()).floatValue() * ((Float)this.miningRange.getValue()).floatValue()), false));
        this.woodcuttingRange.addUpdateCallback(f -> this.woodcuttingRangeSq.setBaseValue(Float.valueOf(((Float)this.woodcuttingRange.getValue()).floatValue() * ((Float)this.woodcuttingRange.getValue()).floatValue()), false));
        this.farmingRange.addUpdateCallback(f -> this.farmingRangeSq.setBaseValue(Float.valueOf(((Float)this.farmingRange.getValue()).floatValue() * ((Float)this.farmingRange.getValue()).floatValue()), false));
    }

    private void updateOnLevelChange(@Nonnull Level level) {
        int targetXp;
        IntAttribute xpAttribute = (IntAttribute)this.getLevelXpAttribute(level);
        int currentXp = xpAttribute.getValue();
        if (currentXp >= (targetXp = BlocklingAttributes.getXpForLevel(this.getLevelAttribute(level).getValue()))) {
            xpAttribute.setValue(targetXp - 1, false);
        }
        if (!this.blockling.field_70170_p.field_72995_K && this.blockling.func_110143_aJ() > this.blockling.func_110138_aP()) {
            this.blockling.func_70606_j(this.blockling.func_110138_aP());
        }
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT attributesTag) {
        for (Attribute<?> attribute : this.attributes) {
            CompoundNBT attributeTag = new CompoundNBT();
            attribute.writeToNBT(attributeTag);
            attributesTag.func_218657_a(attribute.id.toString(), (INBT)attributeTag);
        }
        return attributesTag;
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT attributesTag, @Nonnull Version tagVersion) {
        for (Attribute<?> attribute : this.attributes) {
            CompoundNBT attributeTag = (CompoundNBT)attributesTag.func_74781_a(attribute.id.toString());
            if (attributeTag == null) continue;
            attribute.readFromNBT(attributeTag, tagVersion);
        }
        this.init();
    }

    public void encode(@Nonnull PacketBuffer buf) {
        for (Attribute<?> attribute : this.attributes) {
            attribute.encode(buf);
        }
    }

    public void decode(@Nonnull PacketBuffer buf) {
        for (Attribute<?> attribute : this.attributes) {
            attribute.decode(buf);
        }
        this.init();
    }

    public static int getXpForLevel(int level) {
        return (int)(Math.exp((double)level / 25.0) * 40.0) - 30;
    }

    public void checkForLevelUpAndUpdate(boolean sync) {
        if (this.combatLevel.getValue() < 100) {
            int combatXpReq;
            int combatLevel = this.combatLevel.getValue();
            int combatXp = this.combatXp.getValue();
            if (combatXp >= (combatXpReq = BlocklingAttributes.getXpForLevel(combatLevel))) {
                this.combatLevel.setValue(combatLevel + 1, sync);
                this.combatXp.setValue(combatXp - combatXpReq, sync);
            }
        }
        if (this.miningLevel.getValue() < 100) {
            int miningXpReq;
            int miningLevel = this.miningLevel.getValue();
            int miningXp = this.miningXp.getValue();
            if (miningXp >= (miningXpReq = BlocklingAttributes.getXpForLevel(miningLevel))) {
                this.miningLevel.setValue(miningLevel + 1, sync);
                this.miningXp.setValue(miningXp - miningXpReq, sync);
            }
        }
        if (this.woodcuttingLevel.getValue() < 100) {
            int woodcuttingXpReq;
            int woodcuttingLevel = this.woodcuttingLevel.getValue();
            int woodcuttingXp = this.woodcuttingXp.getValue();
            if (woodcuttingXp >= (woodcuttingXpReq = BlocklingAttributes.getXpForLevel(woodcuttingLevel))) {
                this.woodcuttingLevel.setValue(woodcuttingLevel + 1, sync);
                this.woodcuttingXp.setValue(woodcuttingXp - woodcuttingXpReq, sync);
            }
        }
        if (this.farmingLevel.getValue() < 100) {
            int farmingXpReq;
            int farmingLevel = this.farmingLevel.getValue();
            int farmingXp = this.farmingXp.getValue();
            if (farmingXp >= (farmingXpReq = BlocklingAttributes.getXpForLevel(farmingLevel))) {
                this.farmingLevel.setValue(farmingLevel + 1, sync);
                this.farmingXp.setValue(farmingXp - farmingXpReq, sync);
            }
        }
    }

    public void updateCombatLevelBonuses(boolean sync) {
        this.maxHealthCombatLevelModifier.setValue(Float.valueOf(this.calcBonusHealthFromCombatLevel()), sync);
        this.attackDamageCombatLevelModifier.setValue(Float.valueOf(this.calcBonusDamageFromCombatLevel()), sync);
        this.attackSpeedLevelModifier.setValue(Float.valueOf(this.calcBonusAttackSpeedFromLevel(this.combatLevel.getValue())), sync);
        this.armourCombatLevelModifier.setValue(Float.valueOf(this.calcBonusArmourFromCombatLevel()), sync);
        this.armourToughnessCombatLevelModifier.setValue(Float.valueOf(this.calcBonusArmourToughnessFromCombatLevel()), sync);
        this.knockbackResistanceCombatLevelModifier.setValue(Float.valueOf(this.calcBonusKnockbackResistanceFromCombatLevel()), sync);
    }

    public void updateTypeBonuses(boolean sync) {
        BlocklingType type = this.blockling.getBlocklingType();
        this.maxHealthTypeModifier.setValue(Float.valueOf(type.getMaxHealth()), sync);
        this.attackDamageTypeModifier.setValue(Float.valueOf(type.getAttackDamage()), sync);
        this.attackSpeedTypeModifier.setValue(Float.valueOf(type.getAttackSpeed()), sync);
        this.armourTypeModifier.setValue(Float.valueOf(type.getArmour()), sync);
        this.armourToughnessTypeModifier.setValue(Float.valueOf(type.getArmourToughness()), sync);
        this.knockbackResistanceTypeModifier.setValue(Float.valueOf(type.getKnockbackResistance()), sync);
        this.moveSpeedTypeModifier.setValue(Float.valueOf(type.getMoveSpeed()), sync);
        this.miningSpeedTypeModifier.setValue(Float.valueOf(type.getMiningSpeed()), sync);
        this.woodcuttingSpeedTypeModifier.setValue(Float.valueOf(type.getWoodcuttingSpeed()), sync);
        this.farmingSpeedTypeModifier.setValue(Float.valueOf(type.getFarmingSpeed()), sync);
    }

    private float calcBonusHarvestSpeedFromLevel(int level) {
        return (float)(10.0 * Math.tan((double)((float)level / 100.0f) * 0.7853981633974483));
    }

    private float calcBonusHealthFromCombatLevel() {
        return (float)(50.0 * Math.tan((double)((float)this.combatLevel.getValue().intValue() / 100.0f) * 0.7853981633974483));
    }

    private float calcBonusDamageFromCombatLevel() {
        return (float)(20.0 * Math.tan((double)((float)this.combatLevel.getValue().intValue() / 100.0f) * 0.7853981633974483));
    }

    private float calcBonusAttackSpeedFromLevel(int level) {
        return (float)(5.0 * Math.tan((double)((float)level / 100.0f) * 0.7853981633974483));
    }

    private float calcBonusArmourFromCombatLevel() {
        return (float)(10.0 * Math.tan((double)((float)this.combatLevel.getValue().intValue() / 100.0f) * 0.7853981633974483));
    }

    private float calcBonusArmourToughnessFromCombatLevel() {
        return (float)(5.0 * Math.tan((double)((float)this.combatLevel.getValue().intValue() / 100.0f) * 0.7853981633974483));
    }

    private float calcBonusKnockbackResistanceFromCombatLevel() {
        return (float)(0.5 * Math.tan((double)((float)this.combatLevel.getValue().intValue() / 100.0f) * 0.7853981633974483));
    }

    public void checkAndCapHealth() {
        if (this.blockling.func_110143_aJ() > this.blockling.func_110138_aP()) {
            this.blockling.func_70606_j(this.blockling.func_110138_aP());
        }
    }

    public int getHealth() {
        return (int)Math.ceil(this.blockling.func_110143_aJ());
    }

    public int getMaxHealth() {
        return (int)Math.ceil(this.blockling.func_110138_aP());
    }

    public float getHealthPercentage() {
        return this.blockling.func_110143_aJ() / this.blockling.func_110138_aP();
    }

    @Nonnull
    public Attribute<Integer> getLevelAttribute(@Nonnull Level level) {
        switch (level) {
            case COMBAT: {
                return this.combatLevel;
            }
            case MINING: {
                return this.miningLevel;
            }
            case WOODCUTTING: {
                return this.woodcuttingLevel;
            }
            case FARMING: {
                return this.farmingLevel;
            }
        }
        return this.totalLevel;
    }

    @Nonnull
    public Attribute<Integer> getLevelXpAttribute(@Nonnull Level level) {
        switch (level) {
            case COMBAT: {
                return this.combatXp;
            }
            case MINING: {
                return this.miningXp;
            }
            case WOODCUTTING: {
                return this.woodcuttingXp;
            }
            case FARMING: {
                return this.farmingXp;
            }
        }
        return this.totalLevel;
    }

    public static enum Level {
        COMBAT,
        MINING,
        WOODCUTTING,
        FARMING,
        TOTAL;

        public static final int MIN = 1;
        public static final int MAX = 100;
    }
}

