/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute;

import com.willr27.blocklings.entity.blockling.attribute.IModifier;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TranslationTextComponent;

public interface IModifiable<T> {
    public void calculate();

    public T getValue();

    @Nonnull
    public String formatValue(@Nonnull String var1);

    public T getBaseValue();

    default public void incrementBaseValue(T amount) {
        this.incrementBaseValue(amount, true);
    }

    public void incrementBaseValue(T var1, boolean var2);

    default public void setBaseValue(T baseValue) {
        this.setBaseValue(baseValue, true);
    }

    public void setBaseValue(T var1, boolean var2);

    @Nonnull
    default public String formatBaseValue(@Nonnull String format) {
        return String.format(format, this.getBaseValue());
    }

    @Nonnull
    public List<IModifier<T>> getModifiers();

    @Nonnull
    public List<IModifier<T>> getEnabledModifiers();

    @Nonnull
    public IModifier<T> getModifier(int var1);

    public int indexOf(@Nonnull IModifier<T> var1);

    public void addModifier(@Nonnull IModifier<T> var1);

    public void addModifiers(IModifier<T> ... var1);

    public void removeModifier(@Nonnull IModifier<T> var1);

    @Nonnull
    public Function<T, String> getDisplayStringValueFunction();

    @Nonnull
    public Supplier<String> getDisplayStringNameSupplier();

    @Nonnull
    public TranslationTextComponent createTranslation(@Nonnull String var1, Object ... var2);
}

