/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute;

import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.Attribute;
import com.willr27.blocklings.entity.blockling.attribute.IModifiable;
import com.willr27.blocklings.entity.blockling.attribute.IModifier;
import com.willr27.blocklings.entity.blockling.attribute.Operation;
import com.willr27.blocklings.network.BlocklingMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;

public abstract class ModifiableAttribute<T>
extends Attribute<T>
implements IModifiable<T> {
    @Nonnull
    protected final List<IModifier<T>> modifiers = new ArrayList<IModifier<T>>();
    protected T baseValue;

    public ModifiableAttribute(@Nonnull String id, @Nonnull String key, @Nonnull BlocklingEntity blockling, T initialBaseValue, @Nullable Function<T, String> displayStringValueFunction, @Nullable Supplier<String> displayStringNameSupplier, boolean isEnabled, IModifier<T> ... modifiers) {
        super(id, key, blockling, displayStringValueFunction, displayStringNameSupplier, isEnabled);
        this.baseValue = initialBaseValue;
        this.value = initialBaseValue;
        this.modifiers.addAll(Arrays.asList(modifiers));
        this.modifiers.forEach(modifier -> modifier.getAttributes().add(this));
    }

    @Override
    public T getBaseValue() {
        return this.baseValue;
    }

    @Override
    @Nonnull
    public List<IModifier<T>> getModifiers() {
        return new ArrayList<IModifier<T>>(this.modifiers);
    }

    @Override
    @Nonnull
    public List<IModifier<T>> getEnabledModifiers() {
        return this.modifiers.stream().filter(IModifier::isEnabled).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public IModifier<T> getModifier(int index) {
        return this.modifiers.get(index);
    }

    @Override
    public int indexOf(@Nonnull IModifier<T> modifier) {
        return this.modifiers.indexOf(modifier);
    }

    @Override
    public void addModifier(@Nonnull IModifier<T> modifier) {
        if (this.modifiers.contains(modifier)) {
            Blocklings.LOGGER.warn("Tried to add modifier \"" + modifier.getDisplayStringNameSupplier().get() + "\" that is already applied to attribute \"" + this.getDisplayStringNameSupplier().get() + "\".");
            return;
        }
        modifier.getAttributes().add(this);
        if (modifier.getOperation() != Operation.MULTIPLY_TOTAL) {
            boolean inserted = false;
            for (IModifier<T> existingModifier : this.modifiers) {
                if (existingModifier.getOperation() != Operation.MULTIPLY_TOTAL) continue;
                this.modifiers.add(this.modifiers.indexOf(existingModifier), modifier);
                inserted = true;
                break;
            }
            if (!inserted) {
                this.modifiers.add(modifier);
            }
        } else {
            this.modifiers.add(modifier);
        }
        this.calculate();
    }

    @Override
    public void addModifiers(IModifier<T> ... modifiers) {
        Arrays.stream(modifiers).forEach(this::addModifier);
    }

    @Override
    public void removeModifier(@Nonnull IModifier<T> modifier) {
        this.modifiers.remove(modifier);
        modifier.getAttributes().remove(this);
        this.calculate();
    }

    @Override
    @Nonnull
    public Function<T, String> getDisplayStringValueFunction() {
        return this.displayStringValueFunction;
    }

    @Override
    @Nonnull
    public Supplier<String> getDisplayStringNameSupplier() {
        return this.displayStringNameSupplier;
    }

    public static abstract class BaseValueMessage<T, M extends BlocklingMessage<M>>
    extends Attribute.ValueMessage<T, M> {
        public BaseValueMessage() {
        }

        public BaseValueMessage(@Nonnull BlocklingEntity blockling, int index, T baseValue) {
            super(blockling, index, baseValue);
        }

        @Override
        protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
            ((ModifiableAttribute)blockling.getStats().attributes.get(this.index)).setBaseValue(this.value, false);
        }
    }
}

