/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute.attributes;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.Attribute;
import com.willr27.blocklings.network.BlocklingMessage;
import com.willr27.blocklings.util.Version;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class EnumAttribute<T extends Enum<?>>
extends Attribute<T> {
    @Nonnull
    private final Function<Integer, T> ordinalConverter;

    public EnumAttribute(@Nonnull String id, @Nonnull String key, @Nonnull BlocklingEntity blockling, @Nonnull Class<T> enumClass, @Nonnull T initialValue, @Nullable Function<T, String> displayStringValueFunction, @Nullable Supplier<String> displayStringNameSupplier, boolean isEnabled) {
        super(id, key, blockling, displayStringValueFunction, displayStringNameSupplier, isEnabled);
        this.value = initialValue;
        this.ordinalConverter = ordinal -> ((Enum[])enumClass.getEnumConstants())[ordinal];
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT attributeTag) {
        attributeTag.func_74768_a("value", ((Enum)this.value).ordinal());
        return super.writeToNBT(attributeTag);
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT attributeTag, @Nonnull Version tagVersion) {
        super.readFromNBT(attributeTag, tagVersion);
        this.setValue((T)((Enum)this.ordinalConverter.apply(attributeTag.func_74762_e("value"))), false);
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.writeInt(((Enum)this.value).ordinal());
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.setValue((T)((Enum)this.ordinalConverter.apply(buf.readInt())), false);
    }

    @Override
    public void setValue(T value) {
        super.setValue(value);
    }

    @Override
    public void setValue(T value, boolean sync) {
        this.value = value;
        this.onValueChanged();
        if (sync) {
            new Message<T>(this.blockling, this.blockling.getStats().attributes.indexOf(this), value).sync();
        }
    }

    public static class Message<T extends Enum<?>>
    extends BlocklingMessage<Message<T>> {
        private int index;
        private int ordinal;

        public Message() {
            super(null);
        }

        public Message(@Nonnull BlocklingEntity blockling, int index, @Nonnull T value) {
            super(blockling);
            this.index = index;
            this.ordinal = ((Enum)value).ordinal();
        }

        @Override
        public void encode(@Nonnull PacketBuffer buf) {
            super.encode(buf);
            buf.writeInt(this.index);
            buf.writeInt(this.ordinal);
        }

        @Override
        public void decode(@Nonnull PacketBuffer buf) {
            super.decode(buf);
            this.index = buf.readInt();
            this.ordinal = buf.readInt();
        }

        @Override
        protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
            EnumAttribute attribute = (EnumAttribute)blockling.getStats().attributes.get(this.index);
            attribute.setValue((Enum)attribute.ordinalConverter.apply(this.ordinal), false);
        }
    }
}

