/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute.attributes.numbers;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.Attribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.NumberAttribute;
import com.willr27.blocklings.util.Version;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class FloatAttribute
extends NumberAttribute<Float> {
    public FloatAttribute(@Nonnull String id, @Nonnull String key, @Nonnull BlocklingEntity blockling, float initialValue, @Nullable Function<Float, String> displayStringValueFunction, @Nullable Supplier<String> displayStringNameSupplier, boolean isEnabled) {
        super(id, key, blockling, Float.valueOf(initialValue), displayStringValueFunction, displayStringNameSupplier, isEnabled);
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT attributeTag) {
        attributeTag.func_74776_a("value", ((Float)this.value).floatValue());
        return super.writeToNBT(attributeTag);
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT attributeTag, @Nonnull Version tagVersion) {
        super.readFromNBT(attributeTag, tagVersion);
        this.value = Float.valueOf(attributeTag.func_74760_g("value"));
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.writeFloat(((Float)this.value).floatValue());
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.value = Float.valueOf(buf.readFloat());
    }

    @Override
    public Float getValue() {
        return (Float)this.value;
    }

    public void incrementValue(float amount) {
        this.incrementValue(amount, true);
    }

    public void incrementValue(float amount, boolean sync) {
        this.setValue(Float.valueOf(((Float)this.value).floatValue() + amount), sync);
    }

    @Override
    public void setValue(Float value) {
        this.setValue(value, true);
    }

    @Override
    public void setValue(Float value, boolean sync) {
        this.value = value;
        this.onValueChanged();
        if (sync) {
            new ValueMessage(this.blockling, this.blockling.getStats().attributes.indexOf(this), value.floatValue()).sync();
        }
    }

    public static class ValueMessage
    extends Attribute.ValueMessage<Float, ValueMessage> {
        public ValueMessage() {
        }

        public ValueMessage(@Nonnull BlocklingEntity blockling, int index, float value) {
            super(blockling, index, Float.valueOf(value));
        }

        @Override
        protected void encodeValue(@Nonnull PacketBuffer buf) {
            buf.writeFloat(((Float)this.value).floatValue());
        }

        @Override
        protected void decodeValue(@Nonnull PacketBuffer buf) {
            this.value = Float.valueOf(buf.readFloat());
        }
    }
}

