/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute.attributes.numbers;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.Attribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.NumberAttribute;
import com.willr27.blocklings.util.Version;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class IntAttribute
extends NumberAttribute<Integer> {
    public IntAttribute(@Nonnull String id, @Nonnull String key, @Nonnull BlocklingEntity blockling, int initialValue, @Nullable Function<Integer, String> displayStringValueFunction, @Nullable Supplier<String> displayStringNameSupplier, boolean isEnabled) {
        super(id, key, blockling, initialValue, displayStringValueFunction, displayStringNameSupplier, isEnabled);
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT attributeTag) {
        attributeTag.func_74768_a("value", ((Integer)this.value).intValue());
        return super.writeToNBT(attributeTag);
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT attributeTag, @Nonnull Version tagVersion) {
        super.readFromNBT(attributeTag, tagVersion);
        this.value = attributeTag.func_74762_e("value");
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.writeInt(((Integer)this.value).intValue());
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.value = buf.readInt();
    }

    @Override
    public Integer getValue() {
        return (Integer)this.value;
    }

    public void incrementValue(int amount) {
        this.incrementValue(amount, true);
    }

    public void incrementValue(int amount, boolean sync) {
        this.setValue((Integer)this.value + amount, sync);
    }

    @Override
    public void setValue(Integer value) {
        this.setValue(value, true);
    }

    @Override
    public void setValue(Integer value, boolean sync) {
        this.value = value;
        this.onValueChanged();
        if (sync) {
            new ValueMessage(this.blockling, this.blockling.getStats().attributes.indexOf(this), value).sync();
        }
    }

    public static class ValueMessage
    extends Attribute.ValueMessage<Integer, ValueMessage> {
        public ValueMessage() {
        }

        public ValueMessage(@Nonnull BlocklingEntity blockling, int index, int value) {
            super(blockling, index, value);
        }

        @Override
        protected void encodeValue(@Nonnull PacketBuffer buf) {
            buf.writeInt(((Integer)this.value).intValue());
        }

        @Override
        protected void decodeValue(@Nonnull PacketBuffer buf) {
            this.value = buf.readInt();
        }
    }
}

