/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute.attributes.numbers;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.IModifier;
import com.willr27.blocklings.entity.blockling.attribute.ModifiableAttribute;
import com.willr27.blocklings.entity.blockling.attribute.Operation;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.ModifiableNumberAttribute;
import com.willr27.blocklings.util.Version;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class ModifiableFloatAttribute
extends ModifiableNumberAttribute<Float> {
    public ModifiableFloatAttribute(@Nonnull String id, @Nonnull String key, @Nonnull BlocklingEntity blockling, float initialBaseValue, @Nullable Function<Float, String> displayStringValueFunction, @Nullable Supplier<String> displayStringNameSupplier, boolean isEnabled, IModifier<Float> ... modifiers) {
        super(id, key, blockling, Float.valueOf(initialBaseValue), displayStringValueFunction, displayStringNameSupplier, isEnabled, modifiers);
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT attributeTag) {
        attributeTag.func_74776_a("base_value", ((Float)this.baseValue).floatValue());
        return super.writeToNBT(attributeTag);
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT attributeTag, @Nonnull Version tagVersion) {
        super.readFromNBT(attributeTag, tagVersion);
        this.baseValue = Float.valueOf(attributeTag.func_74760_g("base_value"));
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.writeFloat(((Float)this.value).floatValue());
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.value = Float.valueOf(buf.readFloat());
    }

    @Override
    public void calculate() {
        this.value = Float.valueOf(0.0f);
        float tempBase = ((Float)this.baseValue).floatValue();
        boolean end = false;
        for (IModifier modifier : this.getEnabledModifiers()) {
            if (modifier.getOperation() == Operation.ADD) {
                this.value = Float.valueOf(((Float)this.value).floatValue() + ((Float)modifier.getValue()).floatValue());
                continue;
            }
            if (modifier.getOperation() == Operation.MULTIPLY_BASE) {
                tempBase *= ((Float)modifier.getValue()).floatValue();
                continue;
            }
            if (modifier.getOperation() != Operation.MULTIPLY_TOTAL) continue;
            if (!end) {
                this.value = Float.valueOf(((Float)this.value).floatValue() + tempBase);
                end = true;
            }
            this.value = Float.valueOf(((Float)this.value).floatValue() * ((Float)modifier.getValue()).floatValue());
        }
        if (!end) {
            this.value = Float.valueOf(((Float)this.value).floatValue() + tempBase);
        }
        this.onValueChanged();
    }

    @Override
    protected void setValue(Float value, boolean sync) {
    }

    @Override
    public void incrementBaseValue(Float amount, boolean sync) {
        this.setBaseValue(Float.valueOf(((Float)this.baseValue).floatValue() + amount.floatValue()), sync);
    }

    @Override
    public void setBaseValue(Float baseValue, boolean sync) {
        this.baseValue = baseValue;
        this.calculate();
        if (sync) {
            new BaseValueMessage(this.blockling, this.blockling.getStats().attributes.indexOf(this), baseValue.floatValue()).sync();
        }
    }

    public static class BaseValueMessage
    extends ModifiableAttribute.BaseValueMessage<Float, BaseValueMessage> {
        public BaseValueMessage() {
        }

        public BaseValueMessage(@Nonnull BlocklingEntity blockling, int index, float value) {
            super(blockling, index, Float.valueOf(value));
        }

        @Override
        protected void encodeValue(@Nonnull PacketBuffer buf) {
            buf.writeFloat(((Float)this.value).floatValue());
        }

        @Override
        protected void decodeValue(@Nonnull PacketBuffer buf) {
            this.value = Float.valueOf(buf.readFloat());
        }
    }
}

