/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute.attributes.numbers;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.IModifiable;
import com.willr27.blocklings.entity.blockling.attribute.IModifier;
import com.willr27.blocklings.entity.blockling.attribute.Operation;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.ModifiableFloatAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ModifiableFloatAttributeModifier
extends ModifiableFloatAttribute
implements IModifier<Float> {
    @Nonnull
    public final List<IModifiable<Float>> attributes = new ArrayList<IModifiable<Float>>();
    @Nonnull
    public final Operation operation;

    public ModifiableFloatAttributeModifier(@Nonnull String id, @Nonnull String key, @Nonnull BlocklingEntity blockling, float initialValue, @Nonnull Operation operation, @Nullable Function<Float, String> displayStringValueFunction, @Nullable Supplier<String> displayStringNameSupplier, boolean isEnabled, IModifier<Float> ... modifiers) {
        super(id, key, blockling, initialValue, displayStringValueFunction, displayStringNameSupplier, isEnabled, modifiers);
        this.operation = operation;
    }

    @Override
    public void calculate() {
        super.calculate();
        this.attributes.forEach(IModifiable::calculate);
    }

    @Override
    public void setBaseValue(Float baseValue, boolean sync) {
        super.setBaseValue((Float)this.value, sync);
        this.attributes.forEach(IModifiable::calculate);
    }

    @Override
    @Nonnull
    public List<IModifiable<Float>> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nonnull
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public boolean isEffective() {
        return (this.getOperation() != Operation.ADD || ((Float)this.getValue()).floatValue() != 0.0f) && (this.getOperation() != Operation.MULTIPLY_BASE && this.getOperation() != Operation.MULTIPLY_TOTAL || ((Float)this.getValue()).floatValue() != 1.0f);
    }

    @Override
    public void setIsEnabled(boolean isEnabled, boolean sync) {
        super.setIsEnabled(isEnabled, sync);
        this.attributes.forEach(IModifiable::calculate);
    }
}

