/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute.attributes.numbers;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.IModifier;
import com.willr27.blocklings.entity.blockling.attribute.ModifiableAttribute;
import com.willr27.blocklings.entity.blockling.attribute.Operation;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.ModifiableNumberAttribute;
import com.willr27.blocklings.util.Version;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class ModifiableIntAttribute
extends ModifiableNumberAttribute<Integer> {
    public ModifiableIntAttribute(String id, String key, BlocklingEntity blockling, int initialBaseValue, Function<Integer, String> displayStringValueFunction, Supplier<String> displayStringNameSupplier, boolean isEnabled, IModifier<Integer> ... modifiers) {
        super(id, key, blockling, initialBaseValue, displayStringValueFunction, displayStringNameSupplier, isEnabled, modifiers);
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT attributeTag) {
        attributeTag.func_74768_a("base_value", ((Integer)this.baseValue).intValue());
        return super.writeToNBT(attributeTag);
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT attributeTag, @Nonnull Version tagVersion) {
        super.readFromNBT(attributeTag, tagVersion);
        this.baseValue = attributeTag.func_74762_e("base_value");
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        super.encode(buf);
        buf.writeInt(((Integer)this.value).intValue());
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        super.decode(buf);
        this.value = buf.readInt();
    }

    @Override
    public void calculate() {
        this.value = 0;
        int tempBase = (Integer)this.baseValue;
        boolean end = false;
        for (IModifier modifier : this.getEnabledModifiers()) {
            if (modifier.getOperation() == Operation.ADD) {
                this.value = (Integer)this.value + (Integer)modifier.getValue();
                continue;
            }
            if (modifier.getOperation() == Operation.MULTIPLY_BASE) {
                tempBase *= ((Integer)modifier.getValue()).intValue();
                continue;
            }
            if (modifier.getOperation() != Operation.MULTIPLY_TOTAL) continue;
            if (!end) {
                this.value = (Integer)this.value + tempBase;
                end = true;
            }
            this.value = (Integer)this.value * (Integer)modifier.getValue();
        }
        if (!end) {
            this.value = (Integer)this.value + tempBase;
        }
        this.onValueChanged();
    }

    @Override
    protected void setValue(Integer value, boolean sync) {
    }

    @Override
    public void incrementBaseValue(Integer amount, boolean sync) {
        this.setBaseValue((Integer)this.baseValue + amount, sync);
    }

    @Override
    public void setBaseValue(Integer baseValue) {
        this.setBaseValue(baseValue, true);
    }

    @Override
    public void setBaseValue(Integer baseValue, boolean sync) {
        this.baseValue = baseValue;
        this.calculate();
        if (sync) {
            new BaseValueMessage(this.blockling, this.blockling.getStats().attributes.indexOf(this), baseValue).sync();
        }
    }

    public static class BaseValueMessage
    extends ModifiableAttribute.BaseValueMessage<Integer, BaseValueMessage> {
        public BaseValueMessage() {
        }

        public BaseValueMessage(@Nonnull BlocklingEntity blockling, int index, int value) {
            super(blockling, index, value);
        }

        @Override
        protected void encodeValue(@Nonnull PacketBuffer buf) {
            buf.writeInt(((Integer)this.value).intValue());
        }

        @Override
        protected void decodeValue(@Nonnull PacketBuffer buf) {
            this.value = buf.readInt();
        }
    }
}

