/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute.attributes.numbers;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.IModifiable;
import com.willr27.blocklings.entity.blockling.attribute.IModifier;
import com.willr27.blocklings.entity.blockling.attribute.Operation;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.ModifiableIntAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ModifiableIntAttributeModifier
extends ModifiableIntAttribute
implements IModifier<Integer> {
    @Nonnull
    public final List<IModifiable<Integer>> attributes = new ArrayList<IModifiable<Integer>>();
    @Nonnull
    public final Operation operation;

    public ModifiableIntAttributeModifier(@Nonnull String id, @Nonnull String key, @Nonnull BlocklingEntity blockling, int initialValue, @Nonnull Operation operation, @Nullable Function<Integer, String> displayStringValueFunction, @Nullable Supplier<String> displayStringNameSupplier, boolean isEnabled, IModifier<Integer> ... modifiers) {
        super(id, key, blockling, initialValue, displayStringValueFunction, displayStringNameSupplier, isEnabled, modifiers);
        this.operation = operation;
    }

    @Override
    public void calculate() {
        super.calculate();
        this.attributes.forEach(IModifiable::calculate);
    }

    @Override
    public void setBaseValue(Integer baseValue, boolean sync) {
        super.setBaseValue((Integer)this.value, sync);
        this.attributes.forEach(IModifiable::calculate);
    }

    @Override
    @Nonnull
    public List<IModifiable<Integer>> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nonnull
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public boolean isEffective() {
        return (this.getOperation() != Operation.ADD || (Integer)this.getValue() != 0) && (this.getOperation() != Operation.MULTIPLY_BASE && this.getOperation() != Operation.MULTIPLY_TOTAL || (Integer)this.getValue() != 1);
    }

    @Override
    public void setIsEnabled(boolean isEnabled, boolean sync) {
        super.setIsEnabled(isEnabled, sync);
        this.attributes.forEach(IModifiable::calculate);
    }
}

