/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.attribute.attributes.numbers;

import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.IModifier;
import com.willr27.blocklings.entity.blockling.attribute.ModifiableAttribute;
import com.willr27.blocklings.entity.blockling.attribute.Operation;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;

public abstract class ModifiableNumberAttribute<T extends Number>
extends ModifiableAttribute<T> {
    @Nullable
    protected Attribute vanillaAttribute;

    public ModifiableNumberAttribute(@Nonnull String id, @Nonnull String key, @Nonnull BlocklingEntity blockling, T initialBaseValue, @Nullable Function<T, String> displayStringValueFunction, @Nullable Supplier<String> displayStringNameSupplier, boolean isEnabled, IModifier<T> ... modifiers) {
        super(id, key, blockling, initialBaseValue, displayStringValueFunction, displayStringNameSupplier, isEnabled, modifiers);
    }

    @Nullable
    public Attribute getVanillaAttribute() {
        return this.vanillaAttribute;
    }

    public void setVanillaAttribute(@Nullable Attribute vanillaAttribute) {
        this.removeFromVanillaAttribute();
        this.vanillaAttribute = vanillaAttribute;
        this.updateVanillaAttribute();
    }

    protected void removeFromVanillaAttribute() {
        if (this.vanillaAttribute != null) {
            ModifiableAttributeInstance vanillaAttributeInstance = this.blockling.func_110148_a(this.vanillaAttribute);
            if (this instanceof IModifier) {
                vanillaAttributeInstance.func_188479_b(this.id);
            }
        }
    }

    protected void updateVanillaAttribute() {
        if (this.vanillaAttribute == null) {
            return;
        }
        ModifiableAttributeInstance vanillaAttributeInstance = this.blockling.func_110148_a(this.vanillaAttribute);
        if (this instanceof IModifier) {
            IModifier modifier = (IModifier)((Object)this);
            if (modifier.getAttributes().stream().anyMatch(modifiable -> modifiable instanceof IModifier)) {
                Blocklings.LOGGER.warn("Tried to add a modifier to a vanilla attribute that is applied to other modifiers.");
                return;
            }
            vanillaAttributeInstance.func_188479_b(this.id);
            if (this.isEnabled()) {
                vanillaAttributeInstance.func_233767_b_(new AttributeModifier(this.id, this.key, ((Number)this.getValue()).doubleValue(), Operation.vanillaOperation(modifier.getOperation())));
            }
        } else {
            vanillaAttributeInstance.func_111128_a(((Number)this.value).doubleValue());
        }
    }

    @Override
    public void onValueChanged() {
        super.onValueChanged();
        this.updateVanillaAttribute();
    }
}

