/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.goal;

import com.willr27.blocklings.util.BlockUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockChunk {
    @Nonnull
    private BlockPos centerPos;
    @Nonnull
    private World world;
    @Nonnull
    private Map<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();

    public BlockChunk(@Nonnull BlockPos centerPos, @Nonnull World world) {
        this.centerPos = centerPos;
        this.world = world;
        this.blocks.put(centerPos, world.func_180495_p(centerPos));
        for (BlockPos surroundingPos : BlockUtil.getSurroundingBlockPositions(centerPos)) {
            this.blocks.put(surroundingPos, world.func_180495_p(surroundingPos));
        }
    }

    public boolean hasChanged() {
        for (Map.Entry<BlockPos, BlockState> entry : this.blocks.entrySet()) {
            if (this.world.func_180495_p(entry.getKey()).func_177230_c() == entry.getValue().func_177230_c()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.centerPos.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass() == obj.getClass() && this.hashCode() == obj.hashCode();
    }
}

