/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.goal;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.entity.blockling.task.config.Property;
import com.willr27.blocklings.entity.blockling.whitelist.GoalWhitelist;
import com.willr27.blocklings.network.messages.GoalStateMessage;
import com.willr27.blocklings.util.BlockUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BlocklingGoal
extends Goal {
    @Nonnull
    public final UUID id;
    @Nonnull
    public final BlocklingEntity blockling;
    @Nonnull
    public final World world;
    @Nonnull
    public final BlocklingTasks tasks;
    @Nonnull
    public final List<GoalWhitelist> whitelists = new ArrayList<GoalWhitelist>();
    @Nonnull
    public final List<Property> properties = new ArrayList<Property>();
    @Nonnull
    private State state = State.IDLE;

    public BlocklingGoal(@Nonnull UUID id, @Nonnull BlocklingEntity blockling, @Nonnull BlocklingTasks tasks) {
        this.id = id;
        this.blockling = blockling;
        this.world = blockling.field_70170_p;
        this.tasks = tasks;
    }

    public boolean func_75250_a() {
        return this.state != State.DISABLED;
    }

    public boolean func_75253_b() {
        return this.state != State.DISABLED;
    }

    public void func_75249_e() {
        if (this.state != State.DISABLED) {
            this.setState(State.ACTIVE);
        }
    }

    public void func_75251_c() {
        if (this.state != State.DISABLED) {
            this.setState(State.IDLE);
        }
    }

    @Nonnull
    public State getState() {
        return this.state;
    }

    public void setState(@Nonnull State state) {
        this.setState(state, true);
    }

    public void setState(@Nonnull State state, boolean sync) {
        this.state = state;
        if (sync) {
            new GoalStateMessage(this.blockling, this.id, state).sync();
        }
    }

    public boolean isInRange(@Nonnull BlockPos blockPos, float rangeSq) {
        return BlockUtil.distanceSq(this.blockling.func_233580_cy_(), blockPos) <= (double)rangeSq;
    }

    @Nonnull
    public Task getTask() {
        return this.tasks.getTask(this.id);
    }

    public static enum State {
        DISABLED,
        IDLE,
        ACTIVE;

    }
}

