/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.goal;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.goal.BlockChunk;
import com.willr27.blocklings.entity.blockling.goal.BlocklingGoal;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.util.BlockUtil;
import com.willr27.blocklings.util.EntityUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;

public abstract class BlocklingPathGoal
extends BlocklingGoal {
    private static final int RECALC_INTERVAL = 10;
    private static final int BAD_PATH_TARGET_COOLDOWN_INTERVAL = 200;
    @Nonnull
    protected final Map<BlockChunk, Integer> badPathTargetChunks = new HashMap<BlockChunk, Integer>();
    @Nullable
    private BlockPos pathTargetPos = null;
    @Nullable
    protected Path path = null;
    private float prevMoveDist = 0.0f;
    private int recalcCounter = 0;

    public BlocklingPathGoal(@Nonnull UUID id, @Nonnull BlocklingEntity blockling, @Nonnull BlocklingTasks tasks) {
        super(id, blockling, tasks);
        this.func_220686_i().add(Goal.Flag.MOVE);
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        this.updateBadPathTargetPositions();
        return true;
    }

    @Override
    public boolean func_75253_b() {
        if (!super.func_75253_b()) {
            return false;
        }
        this.updateBadPathTargetPositions();
        return true;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.moveBlocklingToPath();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.setPathTargetPos(null, null);
        this.prevMoveDist = 0.0f;
    }

    public final void func_75246_d() {
        super.func_75246_d();
        boolean shouldRecalc = this.tickRecalc();
        if (shouldRecalc) {
            this.recalcPath(false);
        }
        if (this.isStuck() || this.isInRangeOfPathTargetPos() && !this.isValidPathTargetPos(this.getPathTargetPos())) {
            this.recalcPath(true);
        }
        if (this.isStuck()) {
            this.markPathTargetPosBad();
        }
        this.moveBlocklingToPath();
        this.tickGoal();
        if (shouldRecalc) {
            this.prevMoveDist = this.blockling.field_82151_R;
        }
    }

    protected abstract void tickGoal();

    private boolean tickRecalc() {
        ++this.recalcCounter;
        if (this.recalcCounter < 10) {
            return false;
        }
        this.recalcCounter = 0;
        return true;
    }

    private void updateBadPathTargetPositions() {
        HashSet blockChunksToRemove = new HashSet();
        this.badPathTargetChunks.forEach((blockChunk, cooldown) -> {
            Integer n = cooldown;
            Integer n2 = cooldown = Integer.valueOf(cooldown - 1);
            if (cooldown <= 0 || blockChunk.hasChanged()) {
                blockChunksToRemove.add(blockChunk);
            }
            this.badPathTargetChunks.put((BlockChunk)blockChunk, (Integer)cooldown);
        });
        blockChunksToRemove.forEach(this.badPathTargetChunks::remove);
    }

    protected abstract boolean recalcPath(boolean var1);

    protected boolean hasMovedSinceLastRecalc() {
        return !this.blockling.func_233570_aj_() || this.blockling.field_82151_R - this.prevMoveDist > 0.01f;
    }

    public boolean isStuck() {
        return !(this.hasPathTargetPos() && this.isInRangeOfPathTargetPos() || this.hasPath() && !this.path.func_75879_b() && this.hasMovedSinceLastRecalc() && !this.blockling.func_70661_as().func_244428_t());
    }

    public boolean isBadPathTargetPos(@Nonnull BlockPos blockPos) {
        return this.badPathTargetChunks.get(new BlockChunk(blockPos, this.world)) != null;
    }

    public void markPathTargetPosBad() {
        if (this.hasPathTargetPos()) {
            this.markPathTargetPosBad(this.pathTargetPos);
        }
    }

    public void markPathTargetPosBad(@Nonnull BlockPos blockPos) {
        this.badPathTargetChunks.put(new BlockChunk(blockPos, this.world), 200);
    }

    protected abstract boolean isValidPathTargetPos(@Nonnull BlockPos var1);

    public boolean isInRangeOfPathTargetPos() {
        return BlockUtil.distanceSq(this.blockling.func_233580_cy_(), this.pathTargetPos) <= (double)this.getRangeSq();
    }

    public boolean hasPathTargetPos() {
        return this.pathTargetPos != null;
    }

    @Nullable
    public BlockPos getPathTargetPos() {
        return this.pathTargetPos;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    @Nullable
    public Path getPath() {
        return this.path;
    }

    public void setPathTargetPos(@Nullable BlockPos blockPos, @Nullable Path pathToPos) {
        Path newPath;
        this.pathTargetPos = blockPos;
        this.path = pathToPos;
        if (this.hasPathTargetPos() && (newPath = EntityUtil.createPathTo((MobEntity)this.blockling, this.pathTargetPos, this.getRangeSq())) != null) {
            this.path = newPath;
        }
    }

    public void moveBlocklingToPath() {
        if (this.blockling.func_70661_as().func_75505_d() != this.getPath()) {
            this.blockling.func_70661_as().func_75484_a(this.path, 1.0);
        }
    }

    public abstract float getRangeSq();
}

