/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.goal;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.goal.BlocklingPathGoal;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.goal.Goal;

public abstract class BlocklingTargetGoal<T>
extends BlocklingPathGoal {
    @Nullable
    private T target;
    @Nullable
    private T prevTarget;
    @Nonnull
    public final Set<T> badTargets = new HashSet<T>();

    public BlocklingTargetGoal(@Nonnull UUID id, @Nonnull BlocklingEntity blockling, @Nonnull BlocklingTasks tasks) {
        super(id, blockling, tasks);
        this.func_220686_i().add(Goal.Flag.TARGET);
        this.func_220686_i().add(Goal.Flag.LOOK);
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        boolean recalulatedTarget = this.tryRecalcTarget();
        if (!recalulatedTarget || !this.recalcPath(false) || this.isStuck()) {
            if (!recalulatedTarget) {
                this.badTargets.clear();
            }
            this.markEntireTargetBad();
            this.markPathTargetPosBad();
            this.setTarget(null);
            return false;
        }
        return true;
    }

    @Override
    public boolean func_75253_b() {
        if (!super.func_75253_b()) {
            return false;
        }
        this.checkForAndRemoveInvalidTargets();
        if (!this.tryRecalcTarget()) {
            return false;
        }
        if (this.isStuck()) {
            this.markEntireTargetBad();
            this.markPathTargetPosBad();
            return false;
        }
        return true;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.setTarget(null);
    }

    public abstract boolean tryRecalcTarget();

    protected abstract void checkForAndRemoveInvalidTargets();

    public abstract void markEntireTargetBad();

    public void markTargetBad() {
        if (this.hasTarget()) {
            this.markBad(this.getTarget());
            this.setTarget(null);
        }
    }

    public void markBad(@Nonnull T target) {
        this.badTargets.add(target);
    }

    public boolean isTargetValid() {
        return this.isValidTarget(this.getTarget());
    }

    public abstract boolean isValidTarget(@Nullable T var1);

    public final boolean hasTarget() {
        return this.target != null;
    }

    @Nullable
    protected final T getTarget() {
        return this.target;
    }

    protected void setTarget(@Nullable T target) {
        this.setPreviousTarget(this.target);
        this.target = target;
    }

    public final boolean hasPrevTarget() {
        return this.prevTarget != null;
    }

    @Nullable
    public final T getPrevTarget() {
        return this.prevTarget;
    }

    protected void setPreviousTarget(@Nullable T target) {
        this.prevTarget = target;
    }
}

