/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.goal.goals;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingGatherGoal;
import com.willr27.blocklings.entity.blockling.skill.skills.FarmingSkills;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.whitelist.GoalWhitelist;
import com.willr27.blocklings.entity.blockling.whitelist.Whitelist;
import com.willr27.blocklings.util.BlockUtil;
import com.willr27.blocklings.util.DropUtil;
import com.willr27.blocklings.util.EntityUtil;
import com.willr27.blocklings.util.ToolType;
import com.willr27.blocklings.util.ToolUtil;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BlocklingFarmGoal
extends BlocklingGatherGoal {
    private static final int SEARCH_RADIUS_X = 8;
    private static final int SEARCH_RADIUS_Y = 8;
    public final GoalWhitelist cropWhitelist = new GoalWhitelist("25140edf-f60e-459e-b1f0-9ff82108ec0b", "crops", Whitelist.Type.BLOCK, this);
    public final GoalWhitelist seedWhitelist;

    public BlocklingFarmGoal(@Nonnull UUID id, @Nonnull BlocklingEntity blockling, @Nonnull BlocklingTasks tasks) {
        super(id, blockling, tasks);
        this.cropWhitelist.setIsUnlocked(blockling.getSkills().getSkill(FarmingSkills.CROP_WHITELIST).isBought(), false);
        ((Set)BlockUtil.CROPS.get()).forEach(crop -> this.cropWhitelist.put(crop.getRegistryName(), true));
        this.whitelists.add(this.cropWhitelist);
        this.seedWhitelist = new GoalWhitelist("d77bf1c1-7718-4733-b763-298b03340eea", "seeds", Whitelist.Type.ITEM, this);
        this.seedWhitelist.setIsUnlocked(blockling.getSkills().getSkill(FarmingSkills.SEED_WHITELIST).isBought(), false);
        ((Set)BlockUtil.CROPS.get()).forEach(crop -> {
            if (crop instanceof CropsBlock) {
                this.seedWhitelist.put(crop.func_185473_a((IBlockReader)this.world, null, crop.func_176223_P()).func_77973_b().getRegistryName(), true);
            }
        });
        this.whitelists.add(this.seedWhitelist);
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b();
    }

    @Override
    protected void tickGather() {
        super.tickGather();
        ItemStack mainStack = this.blockling.func_184614_ca();
        ItemStack offStack = this.blockling.func_184592_cb();
        BlockPos targetPos = (BlockPos)this.getTarget();
        BlockState targetBlockState = this.world.func_180495_p(targetPos);
        Block targetBlock = targetBlockState.func_177230_c();
        boolean mainCanHarvest = ToolUtil.canToolHarvest(mainStack, targetBlockState);
        boolean offCanHarvest = ToolUtil.canToolHarvest(offStack, targetBlockState);
        if (mainCanHarvest || offCanHarvest) {
            this.blockling.getActions().gather.tryStart();
            if (this.blockling.getActions().gather.isRunning()) {
                float blocklingDestroySpeed = ((Float)this.blockling.getStats().farmingSpeed.getValue()).floatValue();
                float mainDestroySpeed = mainCanHarvest ? ToolUtil.getToolHarvestSpeedWithEnchantments(mainStack, targetBlockState) : 0.0f;
                float offDestroySpeed = offCanHarvest ? ToolUtil.getToolHarvestSpeedWithEnchantments(offStack, targetBlockState) : 0.0f;
                float destroySpeed = blocklingDestroySpeed + mainDestroySpeed + offDestroySpeed;
                float blockStrength = targetBlockState.func_185887_b((IBlockReader)this.world, targetPos);
                this.blockling.getStats().hand.setValue(BlocklingHand.fromBooleans(mainCanHarvest, offCanHarvest));
                float progress = destroySpeed / (blockStrength + 2.5f) / 100.0f;
                this.blockling.getActions().gather.tick(progress);
                if (this.blockling.getActions().gather.isFinished()) {
                    this.blockling.getActions().gather.stop();
                    this.blockling.getStats().farmingXp.incrementValue((int)((blockStrength + 1.0f) * 3.0f));
                    for (ItemStack stack : DropUtil.getDrops(DropUtil.Context.FARMING, this.blockling, targetPos, mainCanHarvest ? mainStack : ItemStack.field_190927_a, offCanHarvest ? offStack : ItemStack.field_190927_a)) {
                        stack = this.blockling.getEquipment().addItem(stack);
                        this.blockling.dropItemStack(stack);
                    }
                    int n = mainCanHarvest ? (this.blockling.getSkills().getSkill(FarmingSkills.HASTY).isBought() ? 2 : 1) : 0;
                    if (ToolUtil.damageTool(mainStack, this.blockling, n)) {
                        mainStack.func_190918_g(1);
                    }
                    int n2 = offCanHarvest ? (this.blockling.getSkills().getSkill(FarmingSkills.HASTY).isBought() ? 2 : 1) : 0;
                    if (ToolUtil.damageTool(offStack, this.blockling, n2)) {
                        offStack.func_190918_g(1);
                    }
                    this.blockling.incCropsHarvestedRecently();
                    ItemStack seedStack = ItemStack.field_190927_a;
                    if (this.blockling.getSkills().getSkill(FarmingSkills.REPLANTER).isBought() && targetBlock instanceof CropsBlock) {
                        CropsBlock cropsBlock = (CropsBlock)targetBlock;
                        seedStack = cropsBlock.func_185473_a((IBlockReader)this.world, targetPos, targetBlockState);
                    }
                    this.world.func_175655_b(targetPos, false);
                    this.world.func_175715_c(this.blockling.func_145782_y(), targetPos, -1);
                    if (this.blockling.getSkills().getSkill(FarmingSkills.SCYTHE).isBought()) {
                        for (BlockPos surroundingPos : BlockUtil.getSurroundingBlockPositions(targetPos)) {
                            BlockState surroundingBlockState = this.world.func_180495_p(surroundingPos);
                            Block surroundingBlock = surroundingBlockState.func_177230_c();
                            if (!this.isValidTarget(surroundingPos)) continue;
                            for (ItemStack stack : DropUtil.getDrops(DropUtil.Context.FARMING, this.blockling, surroundingPos, mainCanHarvest ? mainStack : ItemStack.field_190927_a, offCanHarvest ? offStack : ItemStack.field_190927_a)) {
                                stack = this.blockling.getEquipment().addItem(stack);
                                this.blockling.dropItemStack(stack);
                            }
                            this.world.func_175655_b(surroundingPos, false);
                            ItemStack seedStack2 = ItemStack.field_190927_a;
                            if (this.blockling.getSkills().getSkill(FarmingSkills.REPLANTER).isBought() && surroundingBlock instanceof CropsBlock) {
                                CropsBlock cropsBlock = (CropsBlock)surroundingBlock;
                                seedStack2 = cropsBlock.func_185473_a((IBlockReader)this.world, surroundingPos, surroundingBlockState);
                            }
                            if (seedStack2.func_190926_b() || !this.blockling.getEquipment().take(seedStack2) || !this.seedWhitelist.isEntryWhitelisted(seedStack2.func_77973_b())) continue;
                            this.world.func_180501_a(surroundingPos, Block.func_149634_a((Item)seedStack2.func_77973_b()).func_176223_P(), 3);
                        }
                    }
                    if (!seedStack.func_190926_b() && this.blockling.getEquipment().take(seedStack) && this.seedWhitelist.isEntryWhitelisted(seedStack.func_77973_b())) {
                        this.world.func_180501_a(targetPos, Block.func_149634_a((Item)seedStack.func_77973_b()).func_176223_P(), 3);
                    }
                } else if (targetBlockState.func_185904_a().func_76220_a()) {
                    this.world.func_175715_c(this.blockling.func_145782_y(), targetPos, BlockUtil.calcBlockBreakProgress(this.blockling.getActions().gather.getCount()));
                }
            }
        } else {
            this.world.func_175715_c(this.blockling.func_145782_y(), targetPos, -1);
            this.blockling.getActions().gather.stop();
        }
    }

    @Override
    public boolean tryRecalcTarget() {
        if (super.tryRecalcTarget()) {
            return true;
        }
        if (!this.tryFindCrop()) {
            return false;
        }
        Pair<BlockPos, Path> pathToCrop = this.findPathToCrop();
        if (pathToCrop == null) {
            return false;
        }
        this.setPathTargetPos((BlockPos)pathToCrop.getKey(), (Path)pathToCrop.getValue());
        return true;
    }

    @Override
    protected boolean recalcPath(boolean force) {
        Pair<BlockPos, Path> result = this.findPathToCrop();
        if (result == null) {
            this.setPathTargetPos(null, null);
            return false;
        }
        this.setPathTargetPos((BlockPos)result.getKey(), (Path)result.getValue());
        return true;
    }

    private boolean tryFindCrop() {
        BlockPos blocklingBlockPos = this.blockling.func_233580_cy_();
        BlockPos closestPos = null;
        double closestCropDistSq = 3.4028234663852886E38;
        for (int i = -8; i <= 8; ++i) {
            block1: for (int j = -8; j <= 8; ++j) {
                for (int k = -8; k <= 8; ++k) {
                    float distanceSq;
                    BlockPos testBlockPos = blocklingBlockPos.func_177982_a(i, j, k);
                    if (!this.isValidTarget(testBlockPos) || !((double)(distanceSq = (float)this.blockling.func_70092_e((float)testBlockPos.func_177958_n() + 0.5f, (float)testBlockPos.func_177956_o() + 0.5f, (float)testBlockPos.func_177952_p() + 0.5f)) < closestCropDistSq)) continue;
                    closestPos = testBlockPos;
                    closestCropDistSq = distanceSq;
                    continue block1;
                }
            }
        }
        if (closestPos != null) {
            this.setTarget(closestPos);
            return true;
        }
        return false;
    }

    @Nullable
    public Pair<BlockPos, Path> findPathToCrop() {
        if (BlockUtil.areAllAdjacentBlocksSolid(this.world, (BlockPos)this.getTarget())) {
            return null;
        }
        if (this.isBadPathTargetPos((BlockPos)this.getTarget())) {
            return null;
        }
        Path path = EntityUtil.createPathTo((MobEntity)this.blockling, (BlockPos)this.getTarget(), this.getRangeSq());
        if (path != null) {
            return new MutablePair(this.getTarget(), (Object)path);
        }
        return null;
    }

    @Override
    public void checkForAndRemoveInvalidTargets() {
        if (!this.isTargetValid()) {
            this.markEntireTargetBad();
        }
    }

    @Override
    public void markEntireTargetBad() {
        if (this.hasTarget()) {
            this.markBad((BlockPos)this.getTarget());
        }
    }

    @Override
    protected boolean isValidTargetBlock(@Nonnull Block block) {
        return this.cropWhitelist.isEntryWhitelisted(block);
    }

    @Override
    protected boolean isValidPathTargetPos(@Nonnull BlockPos blockPos) {
        return this.hasTarget() && ((BlockPos)this.getTarget()).equals((Object)blockPos);
    }

    @Override
    public boolean isValidTarget(@Nullable BlockPos target) {
        CropsBlock cropsBlock;
        if (!super.isValidTarget(target)) {
            return false;
        }
        BlockState blockState = this.world.func_180495_p(target);
        Block block = blockState.func_177230_c();
        return !(block instanceof CropsBlock) || (cropsBlock = (CropsBlock)block).func_185525_y(blockState);
    }

    @Override
    @Nonnull
    protected ToolType getToolType() {
        return ToolType.HOE;
    }

    @Override
    public float getRangeSq() {
        return ((Float)this.blockling.getStats().farmingRangeSq.getValue()).floatValue();
    }
}

