/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.goal.goals;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.goal.BlocklingGoal;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.task.config.RangeProperty;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.text.ITextComponent;

public class BlocklingFollowGoal
extends BlocklingGoal {
    private final double speedModifier = 1.0;
    @Nonnull
    private final RangeProperty stopDistance;
    @Nonnull
    private final RangeProperty startDistance;
    @Nonnull
    private final PathNavigator navigation;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public BlocklingFollowGoal(@Nonnull UUID id, @Nonnull BlocklingEntity blockling, @Nonnull BlocklingTasks tasks) {
        super(id, blockling, tasks);
        this.navigation = blockling.func_70661_as();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.startDistance = new RangeProperty("590fb919-6ac7-4af7-98ec-6e01919782c1", this, (ITextComponent)new BlocklingsTranslationTextComponent("task.property.follow_start_range.name"), (ITextComponent)new BlocklingsTranslationTextComponent("task.property.follow_start_range.desc"), 1, 20, 4);
        this.properties.add(this.startDistance);
        this.stopDistance = new RangeProperty("99d39a22-3abe-4109-b493-dcb922f0c08a", this, (ITextComponent)new BlocklingsTranslationTextComponent("task.property.follow_stop_range.name"), (ITextComponent)new BlocklingsTranslationTextComponent("task.property.follow_stop_range.desc"), 1, 20, 2);
        this.properties.add(this.stopDistance);
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        LivingEntity owner = this.blockling.func_70902_q();
        if (owner == null) {
            return false;
        }
        if (owner.func_175149_v()) {
            return false;
        }
        if (this.blockling.func_70068_e((Entity)owner) < (double)(this.startDistance.value * this.startDistance.value)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    @Override
    public boolean func_75253_b() {
        if (!super.func_75253_b()) {
            return false;
        }
        if (this.navigation.func_75500_f()) {
            return false;
        }
        return !(this.blockling.func_70068_e((Entity)this.owner) <= (double)(this.stopDistance.value * this.stopDistance.value));
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.blockling.func_184643_a(PathNodeType.WATER);
        this.blockling.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.owner = null;
        this.navigation.func_75499_g();
        this.blockling.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        super.func_75246_d();
        this.blockling.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.blockling.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.blockling.func_110167_bD() && !this.blockling.func_184218_aH()) {
                this.navigation.func_75499_g();
                this.navigation.func_75497_a((Entity)this.owner, 1.0);
            }
        }
    }
}

