/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.goal.goals;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import com.willr27.blocklings.entity.blockling.goal.BlocklingTargetGoal;
import com.willr27.blocklings.entity.blockling.skill.skills.GeneralSkills;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.util.ToolContext;
import com.willr27.blocklings.util.ToolType;
import com.willr27.blocklings.util.ToolUtil;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BlocklingGatherGoal
extends BlocklingTargetGoal<BlockPos> {
    public BlocklingGatherGoal(@Nonnull UUID id, @Nonnull BlocklingEntity blockling, @Nonnull BlocklingTasks tasks) {
        super(id, blockling, tasks);
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b();
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.setPathTargetPos(null, null);
        this.blockling.getActions().gather.stop();
    }

    @Override
    public void tickGoal() {
        this.blockling.getActions().gather.tick(0.0f);
        if (this.isStuck()) {
            this.blockling.getActions().gather.stop();
            this.markEntireTargetBad();
        } else if (this.isInRangeOfPathTargetPos()) {
            this.tickGather();
        }
    }

    @Override
    public boolean tryRecalcTarget() {
        if (this.isTargetValid()) {
            return true;
        }
        this.markTargetBad();
        return false;
    }

    protected void tickGather() {
        if (!this.hasMovedSinceLastRecalc()) {
            this.blockling.func_200602_a(EntityAnchorArgument.Type.EYES, new Vector3d((double)((BlockPos)this.getTarget()).func_177958_n() + 0.5, (double)((BlockPos)this.getTarget()).func_177956_o() + 0.5, (double)((BlockPos)this.getTarget()).func_177952_p() + 0.5));
        }
        if (this.blockling.getSkills().getSkill(GeneralSkills.AUTOSWITCH).isBought()) {
            this.blockling.getEquipment().trySwitchToBestTool(BlocklingHand.BOTH, new ToolContext(this.getToolType(), this.getTargetBlockState()));
        }
    }

    public boolean canHarvestTargetPos() {
        return this.canHarvestPos((BlockPos)this.getTarget());
    }

    public boolean canHarvestPos(@Nullable BlockPos blockPos) {
        Pair<ItemStack, ItemStack> bestTools;
        if (blockPos == null) {
            return false;
        }
        BlockState blockState = this.world.func_180495_p(blockPos);
        if (this.blockling.getEquipment().canHarvestBlockWithEquippedTools(blockState)) {
            return true;
        }
        return this.blockling.getSkills().getSkill(GeneralSkills.AUTOSWITCH).isBought() && (ToolUtil.canToolHarvest((ItemStack)(bestTools = this.blockling.getEquipment().findBestToolsToSwitchTo(BlocklingHand.BOTH, new ToolContext(this.getToolType(), blockState))).getKey(), blockState) || ToolUtil.canToolHarvest((ItemStack)bestTools.getValue(), blockState));
    }

    @Nonnull
    protected abstract ToolType getToolType();

    @Override
    public boolean isValidTarget(@Nullable BlockPos target) {
        return this.isValidTargetPos(target) && this.isValidTargetBlock(this.world.func_180495_p(target).func_177230_c()) && this.canHarvestPos(target);
    }

    protected boolean isValidTargetPos(@Nullable BlockPos blockPos) {
        return blockPos != null && !this.badTargets.contains(blockPos);
    }

    protected abstract boolean isValidTargetBlock(@Nonnull Block var1);

    @Override
    public void markBad(@Nonnull BlockPos target) {
        super.markBad(target);
        this.world.func_175715_c(this.blockling.func_145782_y(), target, -1);
    }

    @Override
    protected void setPreviousTarget(@Nullable BlockPos target) {
        if (!(target == null || this.getTarget() != null && ((BlockPos)this.getTarget()).equals((Object)target))) {
            this.world.func_175715_c(this.blockling.func_145782_y(), target, -1);
        }
        super.setPreviousTarget(target);
    }

    @Nullable
    public Block getTargetBlock() {
        BlockState blockState = this.getTargetBlockState();
        return blockState != null ? blockState.func_177230_c() : null;
    }

    @Nullable
    public BlockState getTargetBlockState() {
        return this.hasTarget() ? this.world.func_180495_p((BlockPos)this.getTarget()) : null;
    }
}

