/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.goal.goals;

import com.willr27.blocklings.entity.BlocklingsEntityTypes;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import com.willr27.blocklings.entity.blockling.goal.BlocklingTargetGoal;
import com.willr27.blocklings.entity.blockling.skill.skills.CombatSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.GeneralSkills;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.whitelist.GoalWhitelist;
import com.willr27.blocklings.entity.blockling.whitelist.Whitelist;
import com.willr27.blocklings.util.BlockUtil;
import com.willr27.blocklings.util.EntityUtil;
import com.willr27.blocklings.util.ToolContext;
import com.willr27.blocklings.util.ToolType;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;

public abstract class BlocklingMeleeAttackGoal
extends BlocklingTargetGoal<LivingEntity> {
    public BlocklingMeleeAttackGoal(@Nonnull UUID id, @Nonnull BlocklingEntity blockling, @Nonnull BlocklingTasks tasks) {
        super(id, blockling, tasks);
        GoalWhitelist whitelist = new GoalWhitelist("540241cd-085a-4c1f-9e90-8aea973568a8", "targets", Whitelist.Type.ENTITY, this);
        whitelist.setIsUnlocked(blockling.getSkills().getSkill(CombatSkills.WHITELIST).isBought(), false);
        ((Map)EntityUtil.VALID_ATTACK_TARGETS.get()).keySet().forEach(type -> whitelist.put(type, true));
        whitelist.put(BlocklingsEntityTypes.BLOCKLING.getId(), false);
        this.whitelists.add(whitelist);
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b();
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.blockling.func_213395_q(true);
        this.blockling.func_70624_b((LivingEntity)this.getTarget());
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.blockling.func_213395_q(false);
        this.blockling.func_70624_b(null);
    }

    @Override
    public void tickGoal() {
        LivingEntity target;
        if (this.isStuck()) {
            this.markEntireTargetBad();
            return;
        }
        if (this.blockling.getSkills().getSkill(GeneralSkills.AUTOSWITCH).isBought()) {
            this.blockling.getEquipment().trySwitchToBestTool(BlocklingHand.BOTH, new ToolContext(ToolType.WEAPON, (LivingEntity)this.getTarget()));
        }
        if (this.isInRange(target = (LivingEntity)this.getTarget())) {
            BlocklingHand attackingHand = this.blockling.getEquipment().findAttackingHand();
            BlocklingHand blocklingHand = attackingHand == BlocklingHand.BOTH ? (this.blockling.getActions().attack.getRecentHand() == BlocklingHand.OFF ? BlocklingHand.MAIN : BlocklingHand.OFF) : (attackingHand = attackingHand);
            if (this.blockling.getActions().attack.tryStart(attackingHand)) {
                this.attack(target, attackingHand);
            }
        }
    }

    @Override
    protected boolean recalcPath(boolean force) {
        if (this.isBadPathTargetPos(((LivingEntity)this.getTarget()).func_233580_cy_())) {
            this.setPathTargetPos(null, null);
            return false;
        }
        Path path = this.blockling.func_70661_as().func_75494_a((Entity)this.getTarget(), 0);
        if (path != null && BlockUtil.distanceSq(((LivingEntity)this.getTarget()).func_233580_cy_(), path.func_224770_k()) > (double)this.getRangeSq()) {
            path = null;
        }
        this.setPathTargetPos(((LivingEntity)this.getTarget()).func_233580_cy_(), path);
        return true;
    }

    protected void attack(@Nonnull LivingEntity target, @Nonnull BlocklingHand attackingHand) {
        this.blockling.func_70652_k((Entity)target);
        this.recalcPath(true);
        this.blockling.wasLastAttackHunt = false;
    }

    @Override
    protected void checkForAndRemoveInvalidTargets() {
        if (this.hasTarget() && !this.isTargetValid()) {
            this.markTargetBad();
        }
    }

    @Override
    public void markEntireTargetBad() {
        if (this.hasTarget()) {
            this.markTargetBad();
        }
    }

    @Override
    protected boolean isValidPathTargetPos(@Nonnull BlockPos blockPos) {
        return true;
    }

    @Override
    public boolean isValidTarget(@Nullable LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this.blockling) {
            return false;
        }
        if (entity == this.blockling.func_70902_q()) {
            return false;
        }
        if (entity.func_233643_dh_()) {
            return false;
        }
        if (this.badTargets.contains(entity)) {
            return false;
        }
        for (GoalWhitelist whitelist : this.whitelists) {
            if (!whitelist.isEntryBlacklisted(entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void setTarget(@Nullable LivingEntity target) {
        super.setTarget(target);
        this.blockling.setTarget(target, false);
    }

    @Override
    public float getRangeSq() {
        return 6.25f;
    }

    private boolean isInRange(@Nonnull LivingEntity target) {
        return this.blockling.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_()) < (double)this.getRangeSq();
    }
}

