/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.goal.goals;

import com.mojang.datafixers.util.Pair;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingGatherGoal;
import com.willr27.blocklings.entity.blockling.skill.skills.MiningSkills;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.whitelist.GoalWhitelist;
import com.willr27.blocklings.entity.blockling.whitelist.Whitelist;
import com.willr27.blocklings.util.BlockUtil;
import com.willr27.blocklings.util.DropUtil;
import com.willr27.blocklings.util.EntityUtil;
import com.willr27.blocklings.util.ToolType;
import com.willr27.blocklings.util.ToolUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class BlocklingMineGoal
extends BlocklingGatherGoal {
    private static final int SEARCH_RADIUS_X = 8;
    private static final int SEARCH_RADIUS_Y = 8;
    private static final int MAX_VEIN_SIZE = 40;
    @Nonnull
    public final List<BlockPos> veinBlockPositions = new ArrayList<BlockPos>();
    @Nonnull
    public final GoalWhitelist oreWhitelist;
    @Nonnull
    private final Set<BlockPos> pathTargetPositionsTested = new HashSet<BlockPos>();

    public BlocklingMineGoal(@Nonnull UUID id, @Nonnull BlocklingEntity blockling, @Nonnull BlocklingTasks tasks) {
        super(id, blockling, tasks);
        this.oreWhitelist = new GoalWhitelist("24d7135e-607b-413b-a2a7-00d19119b9de", "ores", Whitelist.Type.BLOCK, this);
        this.oreWhitelist.setIsUnlocked(blockling.getSkills().getSkill(MiningSkills.WHITELIST).isBought(), false);
        ((Set)BlockUtil.ORES.get()).forEach(ore -> this.oreWhitelist.put(ore.getRegistryName(), true));
        this.whitelists.add(this.oreWhitelist);
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.veinBlockPositions.clear();
    }

    @Override
    protected void tickGather() {
        super.tickGather();
        ItemStack mainStack = this.blockling.func_184614_ca();
        ItemStack offStack = this.blockling.func_184592_cb();
        BlockPos targetPos = (BlockPos)this.getTarget();
        BlockState targetBlockState = this.getTargetBlockState();
        boolean mainCanHarvest = ToolUtil.canToolHarvest(mainStack, targetBlockState);
        boolean offCanHarvest = ToolUtil.canToolHarvest(offStack, targetBlockState);
        if (mainCanHarvest || offCanHarvest) {
            this.blockling.getActions().gather.tryStart();
            if (this.blockling.getActions().gather.isRunning()) {
                float blocklingDestroySpeed = ((Float)this.blockling.getStats().miningSpeed.getValue()).floatValue();
                float mainDestroySpeed = mainCanHarvest ? ToolUtil.getToolHarvestSpeedWithEnchantments(mainStack, targetBlockState) : 0.0f;
                float offDestroySpeed = offCanHarvest ? ToolUtil.getToolHarvestSpeedWithEnchantments(offStack, targetBlockState) : 0.0f;
                float destroySpeed = blocklingDestroySpeed + mainDestroySpeed + offDestroySpeed;
                float blockStrength = targetBlockState.func_185887_b((IBlockReader)this.world, targetPos);
                this.blockling.getStats().hand.setValue(BlocklingHand.fromBooleans(mainCanHarvest, offCanHarvest));
                float progress = destroySpeed / blockStrength / 100.0f;
                this.blockling.getActions().gather.tick(progress);
                if (this.blockling.getActions().gather.isFinished()) {
                    this.blockling.getActions().gather.stop();
                    this.blockling.getStats().miningXp.incrementValue((int)(blockStrength * 2.0f));
                    for (ItemStack stack : DropUtil.getDrops(DropUtil.Context.MINING, this.blockling, targetPos, mainCanHarvest ? mainStack : ItemStack.field_190927_a, offCanHarvest ? offStack : ItemStack.field_190927_a)) {
                        stack = this.blockling.getEquipment().addItem(stack);
                        this.blockling.dropItemStack(stack);
                    }
                    int n = mainCanHarvest ? (this.blockling.getSkills().getSkill(MiningSkills.HASTY).isBought() ? 2 : 1) : 0;
                    if (ToolUtil.damageTool(mainStack, this.blockling, n)) {
                        mainStack.func_190918_g(1);
                    }
                    int n2 = offCanHarvest ? (this.blockling.getSkills().getSkill(MiningSkills.HASTY).isBought() ? 2 : 1) : 0;
                    if (ToolUtil.damageTool(offStack, this.blockling, n2)) {
                        offStack.func_190918_g(1);
                    }
                    this.blockling.incOresMinedRecently();
                    this.world.func_175655_b(targetPos, false);
                    this.world.func_175715_c(this.blockling.func_145782_y(), targetPos, -1);
                    if (this.blockling.getSkills().getSkill(MiningSkills.HAMMER).isBought()) {
                        for (BlockPos surroundingPos : BlockUtil.getSurroundingBlockPositions(targetPos)) {
                            if (!this.isValidTarget(surroundingPos)) continue;
                            for (ItemStack stack : DropUtil.getDrops(DropUtil.Context.MINING, this.blockling, surroundingPos, mainCanHarvest ? mainStack : ItemStack.field_190927_a, offCanHarvest ? offStack : ItemStack.field_190927_a)) {
                                stack = this.blockling.getEquipment().addItem(stack);
                                this.blockling.dropItemStack(stack);
                            }
                            this.world.func_175655_b(surroundingPos, false);
                        }
                    }
                } else {
                    this.world.func_175715_c(this.blockling.func_145782_y(), targetPos, BlockUtil.calcBlockBreakProgress(this.blockling.getActions().gather.getCount()));
                }
            }
        } else {
            this.world.func_175715_c(this.blockling.func_145782_y(), targetPos, -1);
            this.blockling.getActions().gather.stop();
        }
    }

    @Override
    public void checkForAndRemoveInvalidTargets() {
        for (BlockPos blockPos : new ArrayList<BlockPos>(this.veinBlockPositions)) {
            if (this.isValidTarget(blockPos)) continue;
            this.markBad(blockPos);
        }
    }

    @Override
    public boolean tryRecalcTarget() {
        if (super.tryRecalcTarget()) {
            return true;
        }
        if (this.veinBlockPositions.isEmpty()) {
            if (!this.tryFindVein()) {
                return false;
            }
            Pair<BlockPos, Path> pathToVein = this.findPathToVein();
            if (pathToVein == null) {
                return false;
            }
            this.setPathTargetPos((BlockPos)pathToVein.getFirst(), (Path)pathToVein.getSecond());
        }
        this.setTarget((BlockPos)this.veinBlockPositions.toArray()[this.veinBlockPositions.size() - 1]);
        return true;
    }

    @Override
    public void markEntireTargetBad() {
        while (!this.veinBlockPositions.isEmpty()) {
            this.markBad(this.veinBlockPositions.get(0));
        }
    }

    @Override
    public void markBad(@Nonnull BlockPos blockPos) {
        super.markBad(blockPos);
        this.veinBlockPositions.remove(blockPos);
    }

    @Override
    protected boolean isValidTargetBlock(@Nonnull Block block) {
        return this.oreWhitelist.isEntryWhitelisted(block);
    }

    @Override
    @Nonnull
    protected ToolType getToolType() {
        return ToolType.PICKAXE;
    }

    private boolean tryFindVein() {
        BlockPos blocklingBlockPos = this.blockling.func_233580_cy_();
        List<Object> veinBlockPositions = new ArrayList();
        ArrayList<BlockPos> testedBlockPositions = new ArrayList<BlockPos>();
        double closestVeinDistSq = 3.4028234663852886E38;
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                block2: for (int k = -8; k <= 8; ++k) {
                    BlockPos testBlockPos = blocklingBlockPos.func_177982_a(i, j, k);
                    if (testedBlockPositions.contains(testBlockPos) || !this.isValidTarget(testBlockPos)) continue;
                    List<BlockPos> veinBlockPositionsToTest = this.findVeinFrom(testBlockPos);
                    boolean canSeeVein = false;
                    for (BlockPos veinBlockPos : veinBlockPositionsToTest) {
                        if (!testedBlockPositions.contains(veinBlockPos)) {
                            testedBlockPositions.add(veinBlockPos);
                        }
                        if (canSeeVein || !EntityUtil.canSee((LivingEntity)this.blockling, veinBlockPos)) continue;
                        canSeeVein = true;
                    }
                    if (!canSeeVein) continue;
                    for (BlockPos veinBlockPos : veinBlockPositionsToTest) {
                        float distanceSq = (float)this.blockling.func_70092_e((float)veinBlockPos.func_177958_n() + 0.5f, (float)veinBlockPos.func_177956_o() + 0.5f, (float)veinBlockPos.func_177952_p() + 0.5f);
                        if (!((double)distanceSq < closestVeinDistSq)) continue;
                        closestVeinDistSq = distanceSq;
                        veinBlockPositions = veinBlockPositionsToTest;
                        continue block2;
                    }
                }
            }
        }
        if (!veinBlockPositions.isEmpty()) {
            this.veinBlockPositions.clear();
            this.veinBlockPositions.addAll(veinBlockPositions);
            return true;
        }
        return false;
    }

    @Nonnull
    private List<BlockPos> findVeinFrom(@Nonnull BlockPos startingBlockPos) {
        ArrayList<BlockPos> veinBlockPositionsToTest = new ArrayList<BlockPos>();
        ArrayList<BlockPos> veinBlockPositions = new ArrayList<BlockPos>();
        veinBlockPositionsToTest.add(startingBlockPos);
        veinBlockPositions.add(startingBlockPos);
        while (!veinBlockPositionsToTest.isEmpty() && veinBlockPositions.size() < 40) {
            BlockPos[] surroundingBlockPositions;
            BlockPos testBlockPos = (BlockPos)veinBlockPositionsToTest.stream().findFirst().get();
            for (BlockPos surroundingPos : surroundingBlockPositions = new BlockPos[]{testBlockPos.func_177982_a(-1, 0, 0), testBlockPos.func_177982_a(1, 0, 0), testBlockPos.func_177982_a(0, -1, 0), testBlockPos.func_177982_a(0, 1, 0), testBlockPos.func_177982_a(0, 0, -1), testBlockPos.func_177982_a(0, 0, 1)}) {
                if (!this.isValidTarget(surroundingPos) || veinBlockPositions.contains(surroundingPos)) continue;
                veinBlockPositions.add(surroundingPos);
                veinBlockPositionsToTest.add(surroundingPos);
            }
            veinBlockPositionsToTest.remove(testBlockPos);
        }
        return veinBlockPositions;
    }

    @Nullable
    public Pair<BlockPos, Path> findPathToVein() {
        for (BlockPos veinBlockPos : this.veinBlockPositions) {
            Path path;
            if (BlockUtil.areAllAdjacentBlocksSolid(this.world, veinBlockPos) || this.isBadPathTargetPos(veinBlockPos) || (path = EntityUtil.createPathTo((MobEntity)this.blockling, veinBlockPos, this.getRangeSq())) == null) continue;
            return new Pair((Object)veinBlockPos, (Object)path);
        }
        return null;
    }

    public void changeVeinRootTo(@Nonnull BlockPos blockPos) {
        this.veinBlockPositions.clear();
        this.veinBlockPositions.addAll(this.findVeinFrom(blockPos));
    }

    @Override
    protected boolean recalcPath(boolean force) {
        if (force) {
            Pair<BlockPos, Path> result = this.findPathToVein();
            if (result == null) {
                this.setPathTargetPos(null, null);
                return false;
            }
            this.setPathTargetPos((BlockPos)result.getFirst(), (Path)result.getSecond());
            return true;
        }
        for (BlockPos veinBlockPos : this.veinBlockPositions) {
            if (this.pathTargetPositionsTested.contains(veinBlockPos)) continue;
            this.pathTargetPositionsTested.add(veinBlockPos);
            if (BlockUtil.areAllAdjacentBlocksSolid(this.world, veinBlockPos)) continue;
            Path path = EntityUtil.createPathTo((MobEntity)this.blockling, veinBlockPos, this.getRangeSq());
            if (path != null && path.func_224769_l() < this.path.func_224769_l()) {
                this.setPathTargetPos(veinBlockPos, path);
                return true;
            }
            return this.hasPath();
        }
        this.pathTargetPositionsTested.clear();
        return false;
    }

    @Override
    protected boolean isValidPathTargetPos(@Nonnull BlockPos blockPos) {
        return this.veinBlockPositions.contains(blockPos);
    }

    @Override
    public void setPathTargetPos(@Nullable BlockPos blockPos, @Nullable Path pathToPos) {
        super.setPathTargetPos(blockPos, pathToPos);
        if (this.hasPathTargetPos()) {
            this.changeVeinRootTo(this.getPathTargetPos());
        }
    }

    @Override
    public float getRangeSq() {
        return ((Float)this.blockling.getStats().miningRangeSq.getValue()).floatValue();
    }
}

