/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.goal.goals;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingGatherGoal;
import com.willr27.blocklings.entity.blockling.skill.skills.WoodcuttingSkills;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.whitelist.GoalWhitelist;
import com.willr27.blocklings.entity.blockling.whitelist.Whitelist;
import com.willr27.blocklings.util.BlockUtil;
import com.willr27.blocklings.util.DropUtil;
import com.willr27.blocklings.util.EntityUtil;
import com.willr27.blocklings.util.ToolType;
import com.willr27.blocklings.util.ToolUtil;
import com.willr27.blocklings.util.WorldUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BlocklingWoodcutGoal
extends BlocklingGatherGoal {
    private static final int SEARCH_RADIUS_X = 8;
    private static final int SEARCH_RADIUS_Y = 8;
    private static final int MAX_TREE_LOGS_SIZE = 30;
    @Nonnull
    private final WorldUtil.Tree tree = new WorldUtil.Tree();
    @Nonnull
    public final GoalWhitelist logWhitelist;
    @Nonnull
    private final Set<BlockPos> pathTargetPositionsTested = new HashSet<BlockPos>();

    public BlocklingWoodcutGoal(@Nonnull UUID id, @Nonnull BlocklingEntity blockling, @Nonnull BlocklingTasks tasks) {
        super(id, blockling, tasks);
        this.logWhitelist = new GoalWhitelist("fbfbfd44-c1b0-4420-824a-270b34c866f7", "logs", Whitelist.Type.BLOCK, this);
        this.logWhitelist.setIsUnlocked(blockling.getSkills().getSkill(WoodcuttingSkills.WHITELIST).isBought(), false);
        ((List)BlockUtil.TREES.get()).forEach(tree -> this.logWhitelist.put(tree.log.getRegistryName(), true));
        this.whitelists.add(this.logWhitelist);
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.tree.logs.clear();
        this.tree.leaves.clear();
    }

    @Override
    protected void tickGather() {
        super.tickGather();
        ItemStack mainStack = this.blockling.func_184614_ca();
        ItemStack offStack = this.blockling.func_184592_cb();
        BlockPos targetPos = (BlockPos)this.getTarget();
        BlockState targetBlockState = this.getTargetBlockState();
        Block targetBlock = this.getTargetBlock();
        boolean mainCanHarvest = ToolUtil.canToolHarvest(mainStack, targetBlockState);
        boolean offCanHarvest = ToolUtil.canToolHarvest(offStack, targetBlockState);
        if (mainCanHarvest || offCanHarvest) {
            this.blockling.getActions().gather.tryStart();
            if (this.blockling.getActions().gather.isRunning()) {
                float blocklingDestroySpeed = ((Float)this.blockling.getStats().woodcuttingSpeed.getValue()).floatValue();
                float mainDestroySpeed = mainCanHarvest ? ToolUtil.getToolHarvestSpeedWithEnchantments(mainStack, targetBlockState) : 0.0f;
                float offDestroySpeed = offCanHarvest ? ToolUtil.getToolHarvestSpeedWithEnchantments(offStack, targetBlockState) : 0.0f;
                float destroySpeed = blocklingDestroySpeed + mainDestroySpeed + offDestroySpeed;
                float blockStrength = targetBlockState.func_185887_b((IBlockReader)this.world, targetPos) + 1.5f;
                this.blockling.getStats().hand.setValue(BlocklingHand.fromBooleans(mainCanHarvest, offCanHarvest));
                float progress = destroySpeed / blockStrength / 100.0f;
                this.blockling.getActions().gather.tick(progress);
                if (this.blockling.getActions().gather.isFinished()) {
                    Block saplingBlock;
                    this.blockling.getActions().gather.stop();
                    this.blockling.getStats().woodcuttingXp.incrementValue((int)blockStrength);
                    for (ItemStack stack : DropUtil.getDrops(DropUtil.Context.WOODCUTTING, this.blockling, targetPos, mainCanHarvest ? mainStack : ItemStack.field_190927_a, offCanHarvest ? offStack : ItemStack.field_190927_a)) {
                        stack = this.blockling.getEquipment().addItem(stack);
                        this.blockling.dropItemStack(stack);
                    }
                    int n = mainCanHarvest ? (this.blockling.getSkills().getSkill(WoodcuttingSkills.HASTY).isBought() ? 2 : 1) : 0;
                    if (ToolUtil.damageTool(mainStack, this.blockling, n)) {
                        mainStack.func_190918_g(1);
                    }
                    int n2 = offCanHarvest ? (this.blockling.getSkills().getSkill(WoodcuttingSkills.HASTY).isBought() ? 2 : 1) : 0;
                    if (ToolUtil.damageTool(offStack, this.blockling, n2)) {
                        offStack.func_190918_g(1);
                    }
                    this.blockling.incLogsChoppedRecently();
                    this.world.func_175655_b(targetPos, false);
                    this.world.func_175715_c(this.blockling.func_145782_y(), targetPos, -1);
                    if (this.blockling.getSkills().getSkill(WoodcuttingSkills.LEAF_BLOWER).isBought()) {
                        for (BlockPos surroundingPos : BlockUtil.getSurroundingBlockPositions(targetPos)) {
                            if (!this.isValidLeavesPos(surroundingPos)) continue;
                            if (this.blockling.getSkills().getSkill(WoodcuttingSkills.TREE_SURGEON).isBought()) {
                                for (ItemStack stack : DropUtil.getDrops(DropUtil.Context.WOODCUTTING, this.blockling, surroundingPos, mainCanHarvest ? mainStack : ItemStack.field_190927_a, offCanHarvest ? offStack : ItemStack.field_190927_a)) {
                                    stack = this.blockling.getEquipment().addItem(stack);
                                    this.blockling.dropItemStack(stack);
                                }
                            }
                            this.world.func_175655_b(surroundingPos, false);
                        }
                    }
                    if (this.blockling.getSkills().getSkill(WoodcuttingSkills.LUMBER_AXE).isBought()) {
                        for (BlockPos surroundingPos : BlockUtil.getSurroundingBlockPositions(targetPos)) {
                            Block saplingBlock2;
                            Block surroundingBlock = this.world.func_180495_p(surroundingPos).func_177230_c();
                            if (!this.isValidTarget(surroundingPos)) continue;
                            for (ItemStack stack : DropUtil.getDrops(DropUtil.Context.WOODCUTTING, this.blockling, surroundingPos, mainCanHarvest ? mainStack : ItemStack.field_190927_a, offCanHarvest ? offStack : ItemStack.field_190927_a)) {
                                stack = this.blockling.getEquipment().addItem(stack);
                                this.blockling.dropItemStack(stack);
                            }
                            this.world.func_175655_b(surroundingPos, false);
                            if (!this.blockling.getSkills().getSkill(WoodcuttingSkills.REPLANTER).isBought() || (saplingBlock2 = BlockUtil.getSaplingFromLog(surroundingBlock)) == null || !BlockUtil.canPlaceAt(this.world, saplingBlock2, surroundingPos)) continue;
                            ItemStack itemStack = new ItemStack((IItemProvider)saplingBlock2);
                            if (!this.blockling.getEquipment().has(itemStack)) continue;
                            this.blockling.getEquipment().take(itemStack);
                            this.world.func_180501_a(surroundingPos, saplingBlock2.func_176223_P(), 3);
                        }
                    }
                    if (this.blockling.getSkills().getSkill(WoodcuttingSkills.REPLANTER).isBought() && (saplingBlock = BlockUtil.getSaplingFromLog(targetBlock)) != null && BlockUtil.canPlaceAt(this.world, saplingBlock, targetPos)) {
                        ItemStack itemStack = new ItemStack((IItemProvider)saplingBlock);
                        if (this.blockling.getEquipment().has(itemStack)) {
                            this.blockling.getEquipment().take(itemStack);
                            this.world.func_180501_a(targetPos, saplingBlock.func_176223_P(), 3);
                        }
                    }
                } else {
                    this.world.func_175715_c(this.blockling.func_145782_y(), targetPos, BlockUtil.calcBlockBreakProgress(this.blockling.getActions().gather.getCount()));
                }
            }
        } else {
            this.world.func_175715_c(this.blockling.func_145782_y(), targetPos, -1);
            this.blockling.getActions().gather.stop();
        }
    }

    @Override
    public void checkForAndRemoveInvalidTargets() {
        for (BlockPos blockPos : new ArrayList<BlockPos>(this.tree.logs)) {
            if (this.isValidTarget(blockPos)) continue;
            this.markBad(blockPos);
        }
    }

    @Override
    public boolean tryRecalcTarget() {
        if (super.tryRecalcTarget()) {
            return true;
        }
        if (this.tree.logs.isEmpty()) {
            if (!this.tryFindTree()) {
                return false;
            }
            Pair<BlockPos, Path> pathToTree = this.findPathToTree();
            if (pathToTree == null) {
                return false;
            }
            this.setPathTargetPos((BlockPos)pathToTree.getKey(), (Path)pathToTree.getValue());
        }
        this.setTarget((BlockPos)this.tree.logs.toArray()[this.tree.logs.size() - 1]);
        return true;
    }

    @Override
    public void markEntireTargetBad() {
        while (!this.tree.logs.isEmpty()) {
            this.markBad(this.tree.logs.get(0));
        }
        while (!this.tree.leaves.isEmpty()) {
            this.markBad(this.tree.leaves.get(0));
        }
    }

    @Override
    public void markBad(@Nonnull BlockPos blockPos) {
        super.markBad(blockPos);
        this.tree.logs.remove(blockPos);
        this.tree.leaves.remove(blockPos);
    }

    @Override
    protected boolean isValidTargetBlock(@Nonnull Block block) {
        return this.logWhitelist.isEntryWhitelisted(block);
    }

    @Override
    @Nonnull
    protected ToolType getToolType() {
        return ToolType.AXE;
    }

    private boolean tryFindTree() {
        BlockPos blocklingBlockPos = this.blockling.func_233580_cy_();
        WorldUtil.Tree tree = new WorldUtil.Tree();
        ArrayList<BlockPos> testedBlockPositions = new ArrayList<BlockPos>();
        double closestTreeDistSq = 3.4028234663852886E38;
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                block2: for (int k = -8; k <= 8; ++k) {
                    WorldUtil.Tree treeToTest;
                    BlockPos testBlockPos = blocklingBlockPos.func_177982_a(i, j, k);
                    if (testedBlockPositions.contains(testBlockPos) || !this.isValidTarget(testBlockPos) || !(treeToTest = this.findTreeFrom(testBlockPos)).isValid()) continue;
                    boolean canSeeTree = false;
                    for (BlockPos logBlockPos : treeToTest.logs) {
                        if (!testedBlockPositions.contains(logBlockPos)) {
                            testedBlockPositions.add(logBlockPos);
                        }
                        if (canSeeTree || !EntityUtil.canSee((LivingEntity)this.blockling, logBlockPos)) continue;
                        canSeeTree = true;
                    }
                    for (BlockPos leafBlockPos : treeToTest.leaves) {
                        if (!testedBlockPositions.contains(leafBlockPos)) {
                            testedBlockPositions.add(leafBlockPos);
                        }
                        if (canSeeTree || !EntityUtil.canSee((LivingEntity)this.blockling, leafBlockPos)) continue;
                        canSeeTree = true;
                    }
                    if (!canSeeTree) continue;
                    for (BlockPos logBlockPos : treeToTest.logs) {
                        float distanceSq = (float)this.blockling.func_70092_e((float)logBlockPos.func_177958_n() + 0.5f, (float)logBlockPos.func_177956_o() + 0.5f, (float)logBlockPos.func_177952_p() + 0.5f);
                        if (!((double)distanceSq < closestTreeDistSq)) continue;
                        closestTreeDistSq = distanceSq;
                        tree = treeToTest;
                        continue block2;
                    }
                }
            }
        }
        if (!tree.logs.isEmpty()) {
            this.tree.logs.clear();
            this.tree.leaves.clear();
            this.tree.logs.addAll(tree.logs);
            this.tree.leaves.addAll(tree.leaves);
            return true;
        }
        return false;
    }

    @Nonnull
    private WorldUtil.Tree findTreeFrom(@Nonnull BlockPos blockPos) {
        return WorldUtil.findTreeFromPos(this.world, blockPos, 30, this::isValidTarget, this::isValidLeavesPos);
    }

    @Nullable
    public Pair<BlockPos, Path> findPathToTree() {
        for (BlockPos logBlockPos : this.tree.logs) {
            Path path;
            if (BlockUtil.areAllAdjacentBlocksSolid(this.world, logBlockPos) || (path = EntityUtil.createPathTo((MobEntity)this.blockling, logBlockPos, this.getRangeSq())) == null) continue;
            return new MutablePair((Object)logBlockPos, (Object)path);
        }
        return null;
    }

    public void changeTreeRootTo(@Nonnull BlockPos blockPos) {
        this.tree.logs.clear();
        this.tree.leaves.clear();
        WorldUtil.Tree newTree = this.findTreeFrom(blockPos);
        this.tree.logs.addAll(newTree.logs);
        this.tree.leaves.addAll(newTree.leaves);
    }

    private boolean isValidLeavesPos(@Nonnull BlockPos blockPos) {
        return this.isValidLeaves(this.world.func_180495_p(blockPos));
    }

    private boolean isValidLeaves(@Nonnull BlockState blockState) {
        return this.isValidLeaves(blockState.func_177230_c()) && (!(blockState.func_177230_c() instanceof LeavesBlock) || (Boolean)blockState.func_177229_b((Property)LeavesBlock.field_208495_b) == false);
    }

    private boolean isValidLeaves(@Nonnull Block block) {
        return BlockUtil.isLeaves(block);
    }

    @Override
    protected boolean recalcPath(boolean force) {
        if (force) {
            Pair<BlockPos, Path> result = this.findPathToTree();
            if (result == null) {
                this.setPathTargetPos(null, null);
                return false;
            }
            this.setPathTargetPos((BlockPos)result.getKey(), (Path)result.getValue());
            return true;
        }
        for (BlockPos logBlockPos : this.tree.logs) {
            if (this.pathTargetPositionsTested.contains(logBlockPos)) continue;
            this.pathTargetPositionsTested.add(logBlockPos);
            if (BlockUtil.areAllAdjacentBlocksSolid(this.world, logBlockPos)) continue;
            Path path = EntityUtil.createPathTo((MobEntity)this.blockling, logBlockPos, this.getRangeSq());
            if (path != null && path.func_224769_l() < this.path.func_224769_l()) {
                this.setPathTargetPos(logBlockPos, path);
                return true;
            }
            return this.hasPath();
        }
        this.pathTargetPositionsTested.clear();
        return false;
    }

    @Override
    protected boolean isValidPathTargetPos(@Nonnull BlockPos blockPos) {
        return this.tree.logs.contains(blockPos);
    }

    @Override
    public void setPathTargetPos(@Nullable BlockPos blockPos, @Nullable Path pathToPos) {
        super.setPathTargetPos(blockPos, pathToPos);
        if (this.hasPathTargetPos()) {
            this.changeTreeRootTo(this.getPathTargetPos());
        }
    }

    @Override
    public float getRangeSq() {
        return ((Float)this.blockling.getStats().woodcuttingRangeSq.getValue()).floatValue();
    }
}

