/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.skill;

import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.skill.Skill;
import com.willr27.blocklings.entity.blockling.skill.SkillGroup;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGroupInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillInfo;
import com.willr27.blocklings.entity.blockling.skill.skills.CombatSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.FarmingSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.GeneralSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.MiningSkills;
import com.willr27.blocklings.entity.blockling.skill.skills.WoodcuttingSkills;
import com.willr27.blocklings.util.IReadWriteNBT;
import com.willr27.blocklings.util.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class BlocklingSkills
implements IReadWriteNBT {
    @Nonnull
    private final BlocklingEntity blockling;
    @Nonnull
    private final List<SkillGroup> skillGroups = new ArrayList<SkillGroup>();

    public static void unlockExistingWhitelists(@Nonnull Skill skill, @Nonnull String whitelistId) {
        skill.blockling.getTasks().getPrioritisedTasks().forEach(task -> {
            if (task.isConfigured()) {
                task.getGoal().whitelists.forEach(goalWhitelist -> {
                    if (goalWhitelist.id.toString().equals(whitelistId)) {
                        goalWhitelist.setIsUnlocked(true, false);
                    }
                });
            }
        });
    }

    public BlocklingSkills(@Nonnull BlocklingEntity blockling) {
        this.blockling = blockling;
        this.reset();
    }

    public void reset() {
        this.skillGroups.clear();
        SkillGroup general = new SkillGroup(this.blockling, Groups.GENERAL);
        general.addSkills(GeneralSkills.SKILLS.stream().map(createSkill -> (Skill)createSkill.apply(general)).collect(Collectors.toList()));
        this.skillGroups.add(general);
        SkillGroup combat = new SkillGroup(this.blockling, Groups.COMBAT);
        combat.addSkills(CombatSkills.SKILLS.stream().map(createSkill -> (Skill)createSkill.apply(combat)).collect(Collectors.toList()));
        this.skillGroups.add(combat);
        SkillGroup mining = new SkillGroup(this.blockling, Groups.MINING);
        mining.addSkills(MiningSkills.SKILLS.stream().map(createSkill -> (Skill)createSkill.apply(mining)).collect(Collectors.toList()));
        this.skillGroups.add(mining);
        SkillGroup woodcutting = new SkillGroup(this.blockling, Groups.WOODCUTTING);
        woodcutting.addSkills(WoodcuttingSkills.SKILLS.stream().map(createSkill -> (Skill)createSkill.apply(woodcutting)).collect(Collectors.toList()));
        this.skillGroups.add(woodcutting);
        SkillGroup farming = new SkillGroup(this.blockling, Groups.FARMING);
        farming.addSkills(FarmingSkills.SKILLS.stream().map(createSkill -> (Skill)createSkill.apply(farming)).collect(Collectors.toList()));
        this.skillGroups.add(farming);
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT skillsTag) {
        for (SkillGroup skillGroup : this.skillGroups) {
            CompoundNBT groupTag = new CompoundNBT();
            for (Skill skill : skillGroup.getSkills()) {
                CompoundNBT skillTag = new CompoundNBT();
                skillTag.func_74768_a("state", skill.getState().ordinal());
                groupTag.func_218657_a(skill.info.id.toString(), (INBT)skillTag);
            }
            skillsTag.func_218657_a(skillGroup.info.id.toString(), (INBT)groupTag);
        }
        return skillsTag;
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT skillsTag, @Nonnull Version tagVersion) {
        for (SkillGroup skillGroup : this.skillGroups) {
            CompoundNBT groupTag = (CompoundNBT)skillsTag.func_74781_a(skillGroup.info.id.toString());
            if (groupTag == null) continue;
            for (Skill skill : skillGroup.getSkills()) {
                CompoundNBT skillTag = (CompoundNBT)groupTag.func_74781_a(skill.info.id.toString());
                if (skillTag == null) continue;
                skill.setState(Skill.State.values()[skillTag.func_74762_e("state")], false);
            }
        }
    }

    public void encode(@Nonnull PacketBuffer buf) {
        for (SkillGroup skillGroup : this.skillGroups) {
            for (Skill skill : skillGroup.getSkills()) {
                buf.func_179249_a((Enum)skill.getState());
            }
        }
    }

    public void decode(@Nonnull PacketBuffer buf) {
        for (SkillGroup skillGroup : this.skillGroups) {
            for (Skill skill : skillGroup.getSkills()) {
                skill.setState((Skill.State)buf.func_179257_a(Skill.State.class), false);
            }
        }
    }

    public void tick() {
        for (SkillGroup skillGroup : this.skillGroups) {
            skillGroup.getSkills().stream().filter(Skill::isBought).forEach(skill -> skill.info.tick((Skill)skill));
        }
    }

    @Nonnull
    public SkillGroup findGroup(@Nonnull SkillInfo skillInfo) {
        return this.skillGroups.stream().filter(group -> group.getSkills().stream().filter(skill -> skill.info == skillInfo).findFirst().orElse(null) != null).findFirst().get();
    }

    @Nonnull
    public SkillGroup getGroup(@Nonnull SkillGroupInfo groupInfo) {
        return this.getGroup(groupInfo.id);
    }

    @Nonnull
    public SkillGroup getGroup(@Nonnull UUID groupId) {
        return this.skillGroups.stream().filter(group -> group.info.id.equals(groupId)).findFirst().get();
    }

    @Nonnull
    public Skill getSkill(@Nonnull SkillInfo skillInfo) {
        return this.findGroup(skillInfo).getSkill(skillInfo);
    }

    public static class Groups {
        @Nonnull
        public static final SkillGroupInfo GENERAL = new SkillGroupInfo("cf5f4d12-03c1-475c-a4a6-fee8484e8ec4", "general", GuiTextures.GENERAL_BACKGROUND);
        @Nonnull
        public static final SkillGroupInfo COMBAT = new SkillGroupInfo("adfab53d-03e7-47e1-8dbe-cf40ee597045", "combat", GuiTextures.COMBAT_BACKGROUND);
        @Nonnull
        public static final SkillGroupInfo MINING = new SkillGroupInfo("c28f70f5-e775-489f-ba08-5d53d1e4200f", "mining", GuiTextures.MINING_BACKGROUND);
        @Nonnull
        public static final SkillGroupInfo WOODCUTTING = new SkillGroupInfo("2297bd04-0ea9-401f-a690-9774a9785f75", "woodcutting", GuiTextures.WOODCUTTING_BACKGROUND);
        @Nonnull
        public static final SkillGroupInfo FARMING = new SkillGroupInfo("e71f5788-1a88-41df-8311-c397d5174d51", "farming", GuiTextures.FARMING_BACKGROUND);
    }
}

