/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.skill;

import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.entity.blockling.skill.SkillGroup;
import com.willr27.blocklings.entity.blockling.skill.info.SkillInfo;
import com.willr27.blocklings.network.messages.SkillStateMessage;
import com.willr27.blocklings.network.messages.SkillTryBuyMessage;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class Skill {
    @Nonnull
    public final BlocklingEntity blockling;
    @Nonnull
    public final SkillInfo info;
    @Nonnull
    public final SkillGroup group;
    private State state;

    public Skill(@Nonnull SkillInfo info, @Nonnull SkillGroup group) {
        this.blockling = group.blockling;
        this.info = info;
        this.group = group;
        this.state = info.defaults.defaultState;
        info.init(this);
    }

    public boolean canBuy() {
        if (this.state != State.UNLOCKED) {
            return false;
        }
        if (this.info.requirements.levels.keySet().stream().anyMatch(level -> this.group.blockling.getStats().getLevelAttribute((BlocklingAttributes.Level)((Object)level)).getValue() < this.info.requirements.levels.get(level))) {
            return false;
        }
        if (!this.areParentsBought()) {
            return false;
        }
        return !this.hasConflict();
    }

    public boolean tryBuy() {
        return this.tryBuy(true);
    }

    public boolean tryBuy(boolean sync) {
        if (!this.canBuy()) {
            return false;
        }
        if (!this.info.onTryBuy(this)) {
            return false;
        }
        this.buy();
        if (sync) {
            new SkillTryBuyMessage(this.blockling, this).sync();
        }
        return true;
    }

    private void buy() {
        this.setState(State.BOUGHT, false);
    }

    public boolean isBought() {
        return this.state == State.BOUGHT;
    }

    @Nonnull
    public State getState() {
        return this.state;
    }

    public void setState(@Nonnull State state) {
        this.setState(state, true);
    }

    public void setState(@Nonnull State state, boolean sync) {
        this.state = state;
        if (sync) {
            new SkillStateMessage(this.blockling, this).sync();
        }
        if (state == State.BOUGHT) {
            for (Skill child : this.children()) {
                if (child.state == State.BOUGHT || child.state == State.UNLOCKED || !child.parents().stream().noneMatch(skill -> skill.state == State.LOCKED)) continue;
                child.setState(State.UNLOCKED, sync);
            }
        }
    }

    @Nonnull
    public List<Skill> children() {
        return this.group.getSkills().stream().filter(skill -> skill.info.parents().contains(this.info)).collect(Collectors.toList());
    }

    @Nonnull
    public List<Skill> parents() {
        return this.group.getSkills().stream().filter(skill -> this.info.parents().contains(skill.info)).collect(Collectors.toList());
    }

    public boolean areParentsBought() {
        return this.parents().stream().noneMatch(skill -> skill.getState() != State.BOUGHT);
    }

    @Nonnull
    public List<Skill> conflicts() {
        return this.group.getSkills().stream().filter(skill -> this.info.conflicts().contains(skill.info)).collect(Collectors.toList());
    }

    public boolean hasConflict() {
        return this.conflicts().stream().anyMatch(skill -> skill.getState() == State.BOUGHT);
    }

    public static enum State {
        LOCKED(0x343434),
        UNLOCKED(0xF4F4F4),
        BOUGHT(16761865);

        @Nonnull
        public final Color colour;

        private State(int colour) {
            this.colour = new Color(colour);
        }
    }

    public static enum Type {
        STAT(0),
        AI(1),
        UTILITY(2),
        OTHER(3);

        @Nonnull
        public final GuiTexture texture;

        private Type(int textureX) {
            this.texture = new GuiTexture(GuiTextures.SKILLS_WIDGETS, textureX * 24, 0, 24, 24);
        }
    }
}

