/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.skill;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.skill.Skill;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGroupInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SkillGroup {
    @Nonnull
    public final BlocklingEntity blockling;
    @Nonnull
    public final SkillGroupInfo info;
    @Nonnull
    private List<Skill> skills = new ArrayList<Skill>();

    public SkillGroup(@Nonnull BlocklingEntity blockling, @Nonnull SkillGroupInfo info) {
        this.blockling = blockling;
        this.info = info;
    }

    public boolean contains(@Nullable Skill ability) {
        return this.skills.contains(ability);
    }

    @Nonnull
    public List<Skill> getSkills() {
        return this.skills;
    }

    @Nullable
    public Skill getSkill(@Nonnull SkillInfo skillInfo) {
        return this.getSkill(skillInfo.id);
    }

    @Nullable
    public Skill getSkill(@Nonnull UUID skillId) {
        for (Skill skill : this.skills) {
            if (!skill.info.id.equals(skillId)) continue;
            return skill;
        }
        return null;
    }

    public void addSkill(@Nonnull Skill skill) {
        this.skills.add(skill);
    }

    public void addSkills(List<Skill> skills) {
        for (Skill skill : skills) {
            this.addSkill(skill);
        }
    }
}

