/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.skill.skills;

import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.controls.skills.SkillControl;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.entity.blockling.skill.BlocklingSkills;
import com.willr27.blocklings.entity.blockling.skill.Skill;
import com.willr27.blocklings.entity.blockling.skill.SkillGroup;
import com.willr27.blocklings.entity.blockling.skill.info.SkillDefaultsInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGeneralInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGuiInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillRequirementsInfo;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class CombatSkills {
    public static final SkillInfo NOVICE_GUARD = new SkillInfo("dcbf7cc1-8bef-49aa-a5a0-cd70cb40cbac", new SkillGeneralInfo(Skill.Type.AI, "combat.novice_guard"), new SkillDefaultsInfo(Skill.State.UNLOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){}), new SkillGuiInfo(0, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 0xDDDDDD, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 0, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getTasks().setIsUnlocked(BlocklingTasks.MELEE_ATTACK_OWNER_HURT_BY, true);
            skill.blockling.getTasks().setIsUnlocked(BlocklingTasks.MELEE_ATTACK_OWNER_HURT, true);
            return true;
        }
    };
    public static final SkillInfo WHITELIST = new SkillInfo("9065aad7-70df-4ae1-88f3-40ef702b7212", new SkillGeneralInfo(Skill.Type.OTHER, "combat.whitelist"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 5);
        }
    }), new SkillGuiInfo(0, 70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 14742015, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 1, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            BlocklingSkills.unlockExistingWhitelists(skill, "540241cd-085a-4c1f-9e90-8aea973568a8");
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_GUARD);
        }
    };
    public static final SkillInfo SHARPNESS = new SkillInfo("1aac1132-6cde-4c1d-8292-1cffe93a7f5a", new SkillGeneralInfo(Skill.Type.STAT, "combat.sharpness"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 10);
        }
    }), new SkillGuiInfo(70, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 16766317, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 2, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().attackDamageSkillSharpnessModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_GUARD);
        }
    };
    public static final SkillInfo BERSERKER = new SkillInfo("dfcfc9df-608b-4d6e-b6a7-ba20c55191b6", new SkillGeneralInfo(Skill.Type.STAT, "combat.berserker"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 25);
        }
    }), new SkillGuiInfo(140, -50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 12002854, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 3, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().attackDamageSkillBerserkerModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        public void tick(@Nonnull Skill skill) {
            skill.blockling.getStats().attackDamageSkillBerserkerModifier.setValue(Float.valueOf(10.0f * (1.0f - Math.max(skill.blockling.func_110143_aJ() - 1.0f, 0.0f) / (skill.blockling.func_110138_aP() - 1.0f))), false);
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(SHARPNESS);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(MOMENTUM, WRECKLESS, PHOTOPHILE);
        }
    };
    public static final SkillInfo MOMENTUM = new SkillInfo("31c6169c-605a-4d88-b4ea-71210afcd028", new SkillGeneralInfo(Skill.Type.STAT, "combat.momentum"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 25);
        }
    }), new SkillGuiInfo(140, 50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 11368885, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 4, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().attackSpeedSkillMomentumModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(SHARPNESS);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(BERSERKER, WRECKLESS, PHOTOPHILE);
        }
    };
    public static final SkillInfo WRECKLESS = new SkillInfo("662b0efa-e150-44c7-aaf8-2cf61bcef330", new SkillGeneralInfo(Skill.Type.STAT, "combat.wreckless"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 25);
        }
    }), new SkillGuiInfo(210, -50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 5157546, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 5, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().attackDamageSkillWrecklessModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(SHARPNESS);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(BERSERKER, MOMENTUM, PHOTOPHILE);
        }
    };
    public static final SkillInfo PHOTOPHILE = new SkillInfo("07ccf340-a3c1-406e-81fc-3622ee0e9463", new SkillGeneralInfo(Skill.Type.STAT, "combat.photophile"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 25);
        }
    }), new SkillGuiInfo(210, 50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 13874736, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 6, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().attackSpeedSkillPhotophileModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        public void tick(@Nonnull Skill skill) {
            float value;
            if (!skill.blockling.field_70170_p.field_72995_K && (value = 5.0f * ((float)skill.blockling.field_70170_p.func_201696_r(skill.blockling.func_233580_cy_()) / 15.0f)) != skill.blockling.getStats().attackSpeedSkillPhotophileModifier.getValue().floatValue()) {
                skill.blockling.getStats().attackSpeedSkillPhotophileModifier.setValue(Float.valueOf(value), true);
            }
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(SHARPNESS);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(BERSERKER, MOMENTUM, WRECKLESS);
        }
    };
    public static final SkillInfo REGENERATION_1 = new SkillInfo("0b1a72e4-486a-46a6-80f3-4a98694d99ea", new SkillGeneralInfo(Skill.Type.OTHER, "combat.regeneration_1"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 10);
        }
    }), new SkillGuiInfo(-140, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 11259489, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 7, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_GUARD);
        }
    };
    public static final SkillInfo REGENERATION_2 = new SkillInfo("f790d1a7-f680-4ea1-a3e1-18bac656614d", new SkillGeneralInfo(Skill.Type.OTHER, "combat.regeneration_2"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 30);
        }
    }), new SkillGuiInfo(-210, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 12910407, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 8, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(REGENERATION_1);
        }
    };
    public static final SkillInfo REGENERATION_3 = new SkillInfo("1330ddfe-9405-4bde-b870-831b999bce18", new SkillGeneralInfo(Skill.Type.OTHER, "combat.regeneration_3"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 50);
        }
    }), new SkillGuiInfo(-280, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 7733045, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 9, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(REGENERATION_2);
        }
    };
    public static final SkillInfo HUNTER = new SkillInfo("c08277df-5985-4d24-985c-f6d6cb579082", new SkillGeneralInfo(Skill.Type.AI, "combat.hunter"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 25);
        }
    }), new SkillGuiInfo(0, -140, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 0x8E0000, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 0, 1))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getTasks().setIsUnlocked(BlocklingTasks.MELEE_ATTACK_HUNT, true);
            return super.onTryBuy(skill);
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_GUARD);
        }
    };
    public static final SkillInfo ANIMAL_HUNTER = new SkillInfo("a623122a-04f2-41a1-ac70-c5cb7fb04ee4", new SkillGeneralInfo(Skill.Type.STAT, "combat.animal_hunter"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 50);
        }
    }), new SkillGuiInfo(-70, -210, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 14380457, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 1, 1))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(HUNTER);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Collections.singletonList(MONSTER_HUNTER);
        }
    };
    public static final SkillInfo MONSTER_HUNTER = new SkillInfo("7af5b098-eada-40b5-9c57-595a436fcd47", new SkillGeneralInfo(Skill.Type.STAT, "combat.monster_hunter"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 50);
        }
    }), new SkillGuiInfo(70, -210, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 1992735, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 2, 1))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(HUNTER);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Collections.singletonList(ANIMAL_HUNTER);
        }
    };
    public static final SkillInfo POISON_ATTACKS = new SkillInfo("f0c1678b-712d-4496-9227-1edceca022b2", new SkillGeneralInfo(Skill.Type.OTHER, "combat.poison_attacks"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 30);
        }
    }), new SkillGuiInfo(-70, -70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 3829272, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 3, 1))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_GUARD);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Collections.singletonList(WITHER_ATTACKS);
        }
    };
    public static final SkillInfo WITHER_ATTACKS = new SkillInfo("81e85a99-9167-4138-8733-3870fbffeb45", new SkillGeneralInfo(Skill.Type.OTHER, "combat.wither_attacks"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.COMBAT, 30);
        }
    }), new SkillGuiInfo(-70, 70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 0x2D2122, new SkillGuiInfo.SkillIconTexture(GuiTextures.COMBAT_ICONS, 4, 1))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_GUARD);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Collections.singletonList(POISON_ATTACKS);
        }
    };
    public static final List<Function<SkillGroup, Skill>> SKILLS = new ArrayList<Function<SkillGroup, Skill>>(){
        {
            this.add(group -> new Skill(NOVICE_GUARD, (SkillGroup)group));
            this.add(group -> new Skill(WHITELIST, (SkillGroup)group));
            this.add(group -> new Skill(SHARPNESS, (SkillGroup)group));
            this.add(group -> new Skill(BERSERKER, (SkillGroup)group));
            this.add(group -> new Skill(MOMENTUM, (SkillGroup)group));
            this.add(group -> new Skill(WRECKLESS, (SkillGroup)group));
            this.add(group -> new Skill(PHOTOPHILE, (SkillGroup)group));
            this.add(group -> new Skill(REGENERATION_1, (SkillGroup)group));
            this.add(group -> new Skill(REGENERATION_2, (SkillGroup)group));
            this.add(group -> new Skill(REGENERATION_3, (SkillGroup)group));
            this.add(group -> new Skill(HUNTER, (SkillGroup)group));
            this.add(group -> new Skill(ANIMAL_HUNTER, (SkillGroup)group));
            this.add(group -> new Skill(MONSTER_HUNTER, (SkillGroup)group));
            this.add(group -> new Skill(POISON_ATTACKS, (SkillGroup)group));
            this.add(group -> new Skill(WITHER_ATTACKS, (SkillGroup)group));
        }
    };
}

