/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.skill.skills;

import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.controls.skills.SkillControl;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.entity.blockling.skill.BlocklingSkills;
import com.willr27.blocklings.entity.blockling.skill.Skill;
import com.willr27.blocklings.entity.blockling.skill.SkillGroup;
import com.willr27.blocklings.entity.blockling.skill.info.SkillDefaultsInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGeneralInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGuiInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillRequirementsInfo;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class FarmingSkills {
    public static final SkillInfo NOVICE_FARMER = new SkillInfo("d70e08ef-25e0-4639-8af5-4b7d55893568", new SkillGeneralInfo(Skill.Type.AI, "farming.novice_farmer"), new SkillDefaultsInfo(Skill.State.UNLOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){}), new SkillGuiInfo(0, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 0xDDDDDD, new SkillGuiInfo.SkillIconTexture(GuiTextures.FARMING_ICONS, 0, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getTasks().setIsUnlocked(BlocklingTasks.FARM, true, false);
            return true;
        }
    };
    public static final SkillInfo CROP_WHITELIST = new SkillInfo("0d9f7b71-3930-4848-9329-8994b0ce7cd1", new SkillGeneralInfo(Skill.Type.OTHER, "farming.crop_whitelist"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.FARMING, 5);
        }
    }), new SkillGuiInfo(0, 70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 14742015, new SkillGuiInfo.SkillIconTexture(GuiTextures.FARMING_ICONS, 1, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            BlocklingSkills.unlockExistingWhitelists(skill, "25140edf-f60e-459e-b1f0-9ff82108ec0b");
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_FARMER);
        }
    };
    public static final SkillInfo EFFICIENCY = new SkillInfo("a7a02e05-c349-4a6c-9822-f05025c73bb5", new SkillGeneralInfo(Skill.Type.STAT, "farming.efficiency"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.FARMING, 10);
        }
    }), new SkillGuiInfo(70, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 16766317, new SkillGuiInfo.SkillIconTexture(GuiTextures.FARMING_ICONS, 2, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().farmingSpeedSkillEfficiencyModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_FARMER);
        }
    };
    public static final SkillInfo REPLANTER = new SkillInfo("25e708f5-fc53-452f-b882-9d31f754235c", new SkillGeneralInfo(Skill.Type.AI, "farming.replanter"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.FARMING, 10);
        }
    }), new SkillGuiInfo(-70, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 6610448, new SkillGuiInfo.SkillIconTexture(GuiTextures.FARMING_ICONS, 3, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_FARMER);
        }
    };
    public static final SkillInfo SEED_WHITELIST = new SkillInfo("8595c654-a19c-4c58-a9c1-a7a5087c397f", new SkillGeneralInfo(Skill.Type.OTHER, "farming.seed_whitelist"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.FARMING, 15);
        }
    }), new SkillGuiInfo(-70, 70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 14742015, new SkillGuiInfo.SkillIconTexture(GuiTextures.FARMING_ICONS, 1, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(REPLANTER);
        }

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            BlocklingSkills.unlockExistingWhitelists(skill, "d77bf1c1-7718-4733-b763-298b03340eea");
            return true;
        }
    };
    public static final SkillInfo ADRENALINE = new SkillInfo("51bb0230-e484-47ae-9c7f-8a4ec7868683", new SkillGeneralInfo(Skill.Type.STAT, "farming.adrenaline"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.FARMING, 25);
        }
    }), new SkillGuiInfo(140, -50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 12002854, new SkillGuiInfo.SkillIconTexture(GuiTextures.FARMING_ICONS, 4, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().farmingSpeedSkillAdrenalineModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        public void tick(@Nonnull Skill skill) {
            skill.blockling.getStats().farmingSpeedSkillAdrenalineModifier.setValue(Float.valueOf(10.0f * (1.0f - Math.max(skill.blockling.func_110143_aJ() - 1.0f, 0.0f) / (skill.blockling.func_110138_aP() - 1.0f))), false);
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(MOMENTUM, HASTY, NIGHT_OWL);
        }
    };
    public static final SkillInfo MOMENTUM = new SkillInfo("e2c8db1a-bc32-482e-9225-54027196f7d2", new SkillGeneralInfo(Skill.Type.STAT, "farming.momentum"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.FARMING, 25);
        }
    }), new SkillGuiInfo(140, 50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 0x39BB39, new SkillGuiInfo.SkillIconTexture(GuiTextures.FARMING_ICONS, 5, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().farmingSpeedSkillMomentumModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(ADRENALINE, HASTY, NIGHT_OWL);
        }
    };
    public static final SkillInfo HASTY = new SkillInfo("da1bd12f-044b-434c-a627-ef7146013d9a", new SkillGeneralInfo(Skill.Type.STAT, "farming.hasty"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.FARMING, 25);
        }
    }), new SkillGuiInfo(210, -50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 5157546, new SkillGuiInfo.SkillIconTexture(GuiTextures.FARMING_ICONS, 6, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().farmingSpeedSkillHastyModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(ADRENALINE, MOMENTUM, NIGHT_OWL);
        }
    };
    public static final SkillInfo NIGHT_OWL = new SkillInfo("b06bfa1b-8b01-4802-a980-cad92b537273", new SkillGeneralInfo(Skill.Type.STAT, "farming.night_owl"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.FARMING, 25);
        }
    }), new SkillGuiInfo(210, 50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 2828861, new SkillGuiInfo.SkillIconTexture(GuiTextures.FARMING_ICONS, 7, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().farmingSpeedSkillNightOwlModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        public void tick(@Nonnull Skill skill) {
            float value;
            if (!skill.blockling.field_70170_p.field_72995_K && (value = 15.0f * (1.0f - (float)skill.blockling.field_70170_p.func_201696_r(skill.blockling.func_233580_cy_()) / 15.0f)) != skill.blockling.getStats().farmingSpeedSkillNightOwlModifier.getValue().floatValue()) {
                skill.blockling.getStats().farmingSpeedSkillNightOwlModifier.setValue(Float.valueOf(value), true);
            }
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(ADRENALINE, MOMENTUM, HASTY);
        }
    };
    public static final SkillInfo SCYTHE = new SkillInfo("b5131481-6530-4733-bfa2-ab6b3cfeb76e", new SkillGeneralInfo(Skill.Type.AI, "farming.scythe"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.FARMING, 50);
        }
    }), new SkillGuiInfo(0, -70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 7032393, new SkillGuiInfo.SkillIconTexture(GuiTextures.FARMING_ICONS, 8, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_FARMER);
        }
    };
    public static final List<Function<SkillGroup, Skill>> SKILLS = new ArrayList<Function<SkillGroup, Skill>>(){
        {
            this.add(group -> new Skill(NOVICE_FARMER, (SkillGroup)group));
            this.add(group -> new Skill(CROP_WHITELIST, (SkillGroup)group));
            this.add(group -> new Skill(EFFICIENCY, (SkillGroup)group));
            this.add(group -> new Skill(REPLANTER, (SkillGroup)group));
            this.add(group -> new Skill(SEED_WHITELIST, (SkillGroup)group));
            this.add(group -> new Skill(ADRENALINE, (SkillGroup)group));
            this.add(group -> new Skill(MOMENTUM, (SkillGroup)group));
            this.add(group -> new Skill(HASTY, (SkillGroup)group));
            this.add(group -> new Skill(NIGHT_OWL, (SkillGroup)group));
            this.add(group -> new Skill(SCYTHE, (SkillGroup)group));
        }
    };
}

