/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.skill.skills;

import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.controls.skills.SkillControl;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.entity.blockling.skill.BlocklingSkills;
import com.willr27.blocklings.entity.blockling.skill.Skill;
import com.willr27.blocklings.entity.blockling.skill.SkillGroup;
import com.willr27.blocklings.entity.blockling.skill.info.SkillDefaultsInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGeneralInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGuiInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillRequirementsInfo;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class MiningSkills {
    public static final SkillInfo NOVICE_MINER = new SkillInfo("dcbf7cc1-8be-49aa-a5a0-cd70cb40cbac", new SkillGeneralInfo(Skill.Type.AI, "mining.novice_miner"), new SkillDefaultsInfo(Skill.State.UNLOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){}), new SkillGuiInfo(0, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 0xDDDDDD, new SkillGuiInfo.SkillIconTexture(GuiTextures.MINING_ICONS, 0, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getTasks().setIsUnlocked(BlocklingTasks.MINE, true);
            return true;
        }
    };
    public static final SkillInfo WHITELIST = new SkillInfo("8963cddd-06dd-4b5a-8c1e-b1e38a99b25f", new SkillGeneralInfo(Skill.Type.OTHER, "mining.whitelist"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.MINING, 5);
        }
    }), new SkillGuiInfo(0, 70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 14742015, new SkillGuiInfo.SkillIconTexture(GuiTextures.MINING_ICONS, 1, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            BlocklingSkills.unlockExistingWhitelists(skill, "24d7135e-607b-413b-a2a7-00d19119b9de");
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_MINER);
        }
    };
    public static final SkillInfo EFFICIENCY = new SkillInfo("19253148-ff6e-4395-9464-289e081b442b", new SkillGeneralInfo(Skill.Type.STAT, "mining.efficiency"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.MINING, 10);
        }
    }), new SkillGuiInfo(70, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 16766317, new SkillGuiInfo.SkillIconTexture(GuiTextures.MINING_ICONS, 2, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().miningSpeedSkillEfficiencyModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_MINER);
        }
    };
    public static final SkillInfo ADRENALINE = new SkillInfo("9cd9212d-0f3b-47c3-85f1-9fe18388a42b", new SkillGeneralInfo(Skill.Type.STAT, "mining.adrenaline"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.MINING, 25);
        }
    }), new SkillGuiInfo(140, -50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 12002854, new SkillGuiInfo.SkillIconTexture(GuiTextures.MINING_ICONS, 3, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().miningSpeedSkillAdrenalineModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        public void tick(@Nonnull Skill skill) {
            skill.blockling.getStats().miningSpeedSkillAdrenalineModifier.setValue(Float.valueOf(10.0f * (1.0f - Math.max(skill.blockling.func_110143_aJ() - 1.0f, 0.0f) / (skill.blockling.func_110138_aP() - 1.0f))), false);
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(MOMENTUM, HASTY, NIGHT_OWL);
        }
    };
    public static final SkillInfo MOMENTUM = new SkillInfo("656aaacb-3c87-4b36-b12c-6ab970f09279", new SkillGeneralInfo(Skill.Type.STAT, "mining.momentum"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.MINING, 25);
        }
    }), new SkillGuiInfo(140, 50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 11368885, new SkillGuiInfo.SkillIconTexture(GuiTextures.MINING_ICONS, 4, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().miningSpeedSkillMomentumModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(ADRENALINE, HASTY, NIGHT_OWL);
        }
    };
    public static final SkillInfo HASTY = new SkillInfo("1cfca8ba-d518-4403-b0ed-8da83e350de3", new SkillGeneralInfo(Skill.Type.STAT, "mining.hasty"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.MINING, 25);
        }
    }), new SkillGuiInfo(210, -50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 5157546, new SkillGuiInfo.SkillIconTexture(GuiTextures.MINING_ICONS, 5, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().miningSpeedSkillHastyModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(ADRENALINE, MOMENTUM, NIGHT_OWL);
        }
    };
    public static final SkillInfo NIGHT_OWL = new SkillInfo("1a2fca9b-c745-4274-9f35-a577dfe65c8d", new SkillGeneralInfo(Skill.Type.STAT, "mining.night_owl"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.MINING, 25);
        }
    }), new SkillGuiInfo(210, 50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 2828861, new SkillGuiInfo.SkillIconTexture(GuiTextures.MINING_ICONS, 6, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().miningSpeedSkillNightOwlModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        public void tick(@Nonnull Skill skill) {
            float value;
            if (!skill.blockling.field_70170_p.field_72995_K && (value = 15.0f * (1.0f - (float)skill.blockling.field_70170_p.func_201696_r(skill.blockling.func_233580_cy_()) / 15.0f)) != skill.blockling.getStats().miningSpeedSkillNightOwlModifier.getValue().floatValue()) {
                skill.blockling.getStats().miningSpeedSkillNightOwlModifier.setValue(Float.valueOf(value), true);
            }
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(ADRENALINE, MOMENTUM, HASTY);
        }
    };
    public static final SkillInfo HOT_HANDS = new SkillInfo("6ddccec1-af7b-4e8a-90a0-3962ef422858", new SkillGeneralInfo(Skill.Type.OTHER, "mining.hot_hands"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.MINING, 40);
        }
    }), new SkillGuiInfo(-70, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 0xDD3355, new SkillGuiInfo.SkillIconTexture(GuiTextures.MINING_ICONS, 7, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_MINER);
        }
    };
    public static final SkillInfo HAMMER = new SkillInfo("f3f2a413-5324-4a87-9d5f-83a5a2df0b5e", new SkillGeneralInfo(Skill.Type.OTHER, "mining.hammer"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.MINING, 50);
        }
    }), new SkillGuiInfo(0, -70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 7032393, new SkillGuiInfo.SkillIconTexture(GuiTextures.MINING_ICONS, 8, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_MINER);
        }
    };
    public static final List<Function<SkillGroup, Skill>> SKILLS = new ArrayList<Function<SkillGroup, Skill>>(){
        {
            this.add(group -> new Skill(NOVICE_MINER, (SkillGroup)group));
            this.add(group -> new Skill(WHITELIST, (SkillGroup)group));
            this.add(group -> new Skill(EFFICIENCY, (SkillGroup)group));
            this.add(group -> new Skill(ADRENALINE, (SkillGroup)group));
            this.add(group -> new Skill(MOMENTUM, (SkillGroup)group));
            this.add(group -> new Skill(HASTY, (SkillGroup)group));
            this.add(group -> new Skill(NIGHT_OWL, (SkillGroup)group));
            this.add(group -> new Skill(HOT_HANDS, (SkillGroup)group));
            this.add(group -> new Skill(HAMMER, (SkillGroup)group));
        }
    };
}

