/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.skill.skills;

import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.controls.skills.SkillControl;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.entity.blockling.skill.BlocklingSkills;
import com.willr27.blocklings.entity.blockling.skill.Skill;
import com.willr27.blocklings.entity.blockling.skill.SkillGroup;
import com.willr27.blocklings.entity.blockling.skill.info.SkillDefaultsInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGeneralInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGuiInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillInfo;
import com.willr27.blocklings.entity.blockling.skill.info.SkillRequirementsInfo;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class WoodcuttingSkills {
    public static final SkillInfo NOVICE_LUMBERJACK = new SkillInfo("c70f6e84-b82f-4a2d-8cbf-5914c589e8b6", new SkillGeneralInfo(Skill.Type.AI, "woodcutting.novice_lumberjack"), new SkillDefaultsInfo(Skill.State.UNLOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){}), new SkillGuiInfo(0, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 0xDDDDDD, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 0, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getTasks().setIsUnlocked(BlocklingTasks.WOODCUT, true, false);
            return true;
        }
    };
    public static final SkillInfo WHITELIST = new SkillInfo("6c1c96c3-c784-4022-bcdd-432618f5d33d", new SkillGeneralInfo(Skill.Type.OTHER, "woodcutting.whitelist"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.WOODCUTTING, 5);
        }
    }), new SkillGuiInfo(0, 70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 14742015, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 1, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            BlocklingSkills.unlockExistingWhitelists(skill, "fbfbfd44-c1b0-4420-824a-270b34c866f7");
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_LUMBERJACK);
        }
    };
    public static final SkillInfo EFFICIENCY = new SkillInfo("3dae8614-511c-4378-9c8a-2ae0d3cddc97", new SkillGeneralInfo(Skill.Type.STAT, "woodcutting.efficiency"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.WOODCUTTING, 10);
        }
    }), new SkillGuiInfo(70, 0, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 16766317, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 2, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().woodcuttingSpeedSkillEfficiencyModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_LUMBERJACK);
        }
    };
    public static final SkillInfo ADRENALINE = new SkillInfo("bdb58fa2-174e-4be6-880b-c355ee76aab6", new SkillGeneralInfo(Skill.Type.STAT, "woodcutting.adrenaline"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.WOODCUTTING, 25);
        }
    }), new SkillGuiInfo(140, -50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 12002854, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 3, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().woodcuttingSpeedSkillAdrenalineModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        public void tick(@Nonnull Skill skill) {
            skill.blockling.getStats().woodcuttingSpeedSkillAdrenalineModifier.setValue(Float.valueOf(10.0f * (1.0f - Math.max(skill.blockling.func_110143_aJ() - 1.0f, 0.0f) / (skill.blockling.func_110138_aP() - 1.0f))), false);
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(MOMENTUM, HASTY, NIGHT_OWL);
        }
    };
    public static final SkillInfo MOMENTUM = new SkillInfo("7b7ce4aa-8f05-48b9-a2c1-f3b714ba339a", new SkillGeneralInfo(Skill.Type.STAT, "woodcutting.momentum"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.WOODCUTTING, 25);
        }
    }), new SkillGuiInfo(140, 50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 10447382, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 4, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().woodcuttingSpeedSkillMomentumModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(ADRENALINE, HASTY, NIGHT_OWL);
        }
    };
    public static final SkillInfo HASTY = new SkillInfo("a7f1ab81-e057-4f6a-a978-f10e8ee98005", new SkillGeneralInfo(Skill.Type.STAT, "woodcutting.hasty"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.WOODCUTTING, 25);
        }
    }), new SkillGuiInfo(210, -50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 5157546, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 5, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().woodcuttingSpeedSkillHastyModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(ADRENALINE, MOMENTUM, NIGHT_OWL);
        }
    };
    public static final SkillInfo NIGHT_OWL = new SkillInfo("1476e2be-9d0f-40cf-901d-b5ba18dea16f", new SkillGeneralInfo(Skill.Type.STAT, "woodcutting.night_owl"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.WOODCUTTING, 25);
        }
    }), new SkillGuiInfo(210, 50, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 2828861, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 6, 0))){

        @Override
        public boolean onTryBuy(@Nonnull Skill skill) {
            skill.blockling.getStats().woodcuttingSpeedSkillNightOwlModifier.setIsEnabled(true, false);
            return true;
        }

        @Override
        public void tick(@Nonnull Skill skill) {
            float value;
            if (!skill.blockling.field_70170_p.field_72995_K && (value = 15.0f * (1.0f - (float)skill.blockling.field_70170_p.func_201696_r(skill.blockling.func_233580_cy_()) / 15.0f)) != skill.blockling.getStats().woodcuttingSpeedSkillNightOwlModifier.getValue().floatValue()) {
                skill.blockling.getStats().woodcuttingSpeedSkillNightOwlModifier.setValue(Float.valueOf(value), true);
            }
        }

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(EFFICIENCY);
        }

        @Override
        @Nonnull
        public List<SkillInfo> conflicts() {
            return Arrays.asList(ADRENALINE, MOMENTUM, HASTY);
        }
    };
    public static final SkillInfo LEAF_BLOWER = new SkillInfo("c4443300-1004-4527-904f-ef097b65e816", new SkillGeneralInfo(Skill.Type.OTHER, "woodcutting.leaf_blower"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.WOODCUTTING, 15);
        }
    }), new SkillGuiInfo(-70, -70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 2256912, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 7, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_LUMBERJACK);
        }
    };
    public static final SkillInfo TREE_SURGEON = new SkillInfo("07168fe8-6434-446a-ad37-09f41fa9b9d9", new SkillGeneralInfo(Skill.Type.OTHER, "woodcutting.tree_surgeon"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.WOODCUTTING, 30);
        }
    }), new SkillGuiInfo(-70, -140, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 6253848, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 8, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(LEAF_BLOWER);
        }
    };
    public static final SkillInfo REPLANTER = new SkillInfo("47db8c56-3a95-44a4-8389-210e0de84d5a", new SkillGeneralInfo(Skill.Type.OTHER, "woodcutting.replanter"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.WOODCUTTING, 20);
        }
    }), new SkillGuiInfo(-70, 70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 11453952, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 9, 0))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_LUMBERJACK);
        }
    };
    public static final SkillInfo LUMBER_AXE = new SkillInfo("e28a9248-7265-478c-8fbf-044b9f9db5e6", new SkillGeneralInfo(Skill.Type.OTHER, "woodcutting.lumber_axe"), new SkillDefaultsInfo(Skill.State.LOCKED), new SkillRequirementsInfo((Map<BlocklingAttributes.Level, Integer>)new HashMap<BlocklingAttributes.Level, Integer>(){
        {
            this.put(BlocklingAttributes.Level.WOODCUTTING, 50);
        }
    }), new SkillGuiInfo(0, -70, SkillControl.ConnectionType.SINGLE_LONGEST_FIRST, 7032393, new SkillGuiInfo.SkillIconTexture(GuiTextures.WOODCUTTING_ICONS, 0, 1))){

        @Override
        @Nonnull
        public List<SkillInfo> parents() {
            return Collections.singletonList(NOVICE_LUMBERJACK);
        }
    };
    public static final List<Function<SkillGroup, Skill>> SKILLS = new ArrayList<Function<SkillGroup, Skill>>(){
        {
            this.add(group -> new Skill(NOVICE_LUMBERJACK, (SkillGroup)group));
            this.add(group -> new Skill(WHITELIST, (SkillGroup)group));
            this.add(group -> new Skill(EFFICIENCY, (SkillGroup)group));
            this.add(group -> new Skill(ADRENALINE, (SkillGroup)group));
            this.add(group -> new Skill(MOMENTUM, (SkillGroup)group));
            this.add(group -> new Skill(HASTY, (SkillGroup)group));
            this.add(group -> new Skill(NIGHT_OWL, (SkillGroup)group));
            this.add(group -> new Skill(LEAF_BLOWER, (SkillGroup)group));
            this.add(group -> new Skill(TREE_SURGEON, (SkillGroup)group));
            this.add(group -> new Skill(REPLANTER, (SkillGroup)group));
            this.add(group -> new Skill(LUMBER_AXE, (SkillGroup)group));
        }
    };
}

