/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.task;

import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.goal.BlocklingGoal;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingFarmGoal;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingFollowGoal;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingMeleeAttackHuntGoal;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingMeleeAttackHurtByGoal;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingMeleeAttackOwnerHurtByGoal;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingMeleeAttackOwnerHurtGoal;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingMineGoal;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingSitGoal;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingWanderGoal;
import com.willr27.blocklings.entity.blockling.goal.goals.BlocklingWoodcutGoal;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.entity.blockling.task.TaskType;
import com.willr27.blocklings.entity.blockling.task.config.Property;
import com.willr27.blocklings.entity.blockling.whitelist.GoalWhitelist;
import com.willr27.blocklings.network.messages.TaskCreateMessage;
import com.willr27.blocklings.network.messages.TaskRemoveMessage;
import com.willr27.blocklings.network.messages.TaskTypeIsUnlockedMessage;
import com.willr27.blocklings.util.IReadWriteNBT;
import com.willr27.blocklings.util.PacketBufferUtils;
import com.willr27.blocklings.util.Version;
import com.willr27.blocklings.util.event.Event;
import com.willr27.blocklings.util.event.EventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class BlocklingTasks
implements IReadWriteNBT {
    public static final TaskType NULL = new TaskType("1c330075-19af-4c12-ac20-6de50e7b84a9", "null", false, false, new GuiTexture(GuiTextures.TASKS, 176, 166, 20, 20), (i, b, t) -> null);
    public static final TaskType MELEE_ATTACK_HURT_BY = new TaskType("2888dde5-f6ee-439d-ab8d-ea9a91470c64", "hurt_by_melee", true, true, new GuiTexture.GoalGuiTexture(3, 0), BlocklingMeleeAttackHurtByGoal::new);
    public static final TaskType MELEE_ATTACK_OWNER_HURT_BY = new TaskType("72b27eb1-e5bd-48e0-b562-74dece3d144a", "owner_hurt_by_melee", false, false, new GuiTexture.GoalGuiTexture(4, 0), BlocklingMeleeAttackOwnerHurtByGoal::new);
    public static final TaskType MELEE_ATTACK_OWNER_HURT = new TaskType("51d0ae15-8605-4240-a515-89f47b2f450a", "owner_hurt_melee", false, false, new GuiTexture.GoalGuiTexture(5, 0), BlocklingMeleeAttackOwnerHurtGoal::new);
    public static final TaskType MELEE_ATTACK_HUNT = new TaskType("283e92b8-5cb8-4d19-afc7-88869a60a214", "hunt_melee", false, false, new GuiTexture.GoalGuiTexture(6, 0), BlocklingMeleeAttackHuntGoal::new);
    public static final TaskType MINE = new TaskType("657c60cf-9fac-408e-ad8d-3335409301d6", "mine_ores", false, false, new GuiTexture.GoalGuiTexture(7, 0), BlocklingMineGoal::new);
    public static final TaskType WOODCUT = new TaskType("9701e1f6-99e0-4772-88a1-906778499a8c", "chop_trees", false, false, new GuiTexture.GoalGuiTexture(8, 0), BlocklingWoodcutGoal::new);
    public static final TaskType FARM = new TaskType("190bb949-6fb0-456b-9009-991c8db9be10", "farm_crops", false, false, new GuiTexture.GoalGuiTexture(9, 0), BlocklingFarmGoal::new);
    public static final TaskType SIT = new TaskType("d64385ca-9306-4e38-b4ac-5aa8800e5e02", "sit", true, false, new GuiTexture.GoalGuiTexture(0, 0), BlocklingSitGoal::new);
    public static final TaskType FOLLOW = new TaskType("299ad70d-350b-43da-8f55-ec502ac360bd", "follow", true, false, new GuiTexture.GoalGuiTexture(1, 0), BlocklingFollowGoal::new);
    public static final TaskType WANDER = new TaskType("39246a4f-3341-4e99-a3a6-450f9501daeb", "wander", true, true, new GuiTexture.GoalGuiTexture(2, 0), BlocklingWanderGoal::new);
    public static final List<TaskType> TASK_TYPES = new ArrayList<TaskType>(){
        {
            this.add(MELEE_ATTACK_HURT_BY);
            this.add(MELEE_ATTACK_OWNER_HURT_BY);
            this.add(MELEE_ATTACK_OWNER_HURT);
            this.add(MELEE_ATTACK_HUNT);
            this.add(MINE);
            this.add(WOODCUT);
            this.add(FARM);
            this.add(SIT);
            this.add(FOLLOW);
            this.add(WANDER);
        }
    };
    public final Map<TaskType, Boolean> taskTypeUnlockedMap = new HashMap<TaskType, Boolean>();
    private final BlocklingEntity blockling;
    private final GoalSelector goalSelector;
    private final GoalSelector targetSelector;
    private TaskList prioritisedTasks = new TaskList();
    public final EventHandler<CreateTaskEvent> onCreateTask = new EventHandler();
    public final EventHandler<RemoveTaskEvent> onRemoveTask = new EventHandler();

    public static TaskType getTaskType(UUID id) {
        return TASK_TYPES.stream().filter(type -> type.id.equals(id)).findFirst().orElse(NULL);
    }

    public BlocklingTasks(@Nonnull BlocklingEntity blockling) {
        this.blockling = blockling;
        this.goalSelector = blockling.field_70714_bg;
        this.targetSelector = blockling.field_70715_bh;
        TASK_TYPES.forEach(type -> this.taskTypeUnlockedMap.put((TaskType)type, type.isUnlockedByDefault));
    }

    public void initDefaultTasks() {
        if (!this.blockling.field_70170_p.field_72995_K) {
            this.prioritisedTasks = new TaskList(TASK_TYPES.stream().filter(type -> type.isActiveByDefault && this.taskTypeUnlockedMap.get(type) != false).map(type -> new Task(UUID.randomUUID(), (TaskType)type, this.blockling, this)).collect(Collectors.toList()));
            this.reapplyGoals();
        }
    }

    public void reapplyGoals() {
        Set goals = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)this.goalSelector, (String)"field_220892_d");
        Set targets = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)this.targetSelector, (String)"field_220892_d");
        goals.forEach(PrioritizedGoal::func_75251_c);
        goals.clear();
        targets.forEach(PrioritizedGoal::func_75251_c);
        targets.clear();
        Map goalLockedFlags = (Map)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)this.goalSelector, (String)"field_220891_c");
        Map targetLockedFlags = (Map)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)this.targetSelector, (String)"field_220891_c");
        goalLockedFlags.clear();
        targetLockedFlags.clear();
        this.goalSelector.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this.blockling));
        for (Task task : this.prioritisedTasks) {
            if (!task.isConfigured()) continue;
            this.goalSelector.func_75776_a(task.getPriority(), (Goal)task.getGoal());
        }
    }

    public void tick() {
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT tasksTag) {
        CompoundNBT unlockedTypesTag = new CompoundNBT();
        for (TaskType type : this.taskTypeUnlockedMap.keySet()) {
            unlockedTypesTag.func_74757_a(type.id.toString(), this.taskTypeUnlockedMap.get(type).booleanValue());
        }
        CompoundNBT taskListTag = new CompoundNBT();
        for (Task task : this.prioritisedTasks) {
            CompoundNBT taskTag = new CompoundNBT();
            taskTag.func_186854_a("type_id", task.getType().id);
            taskTag.func_74768_a("priority", task.getPriority());
            taskTag.func_74778_a("custom_name", task.getActualCustomName());
            if (task.isConfigured()) {
                CompoundNBT whitelistsTag = new CompoundNBT();
                for (GoalWhitelist whitelist : task.getGoal().whitelists) {
                    whitelistsTag.func_218657_a(whitelist.id.toString(), (INBT)whitelist.writeToNBT());
                }
                ListNBT propertiesTag = new ListNBT();
                for (Property property : task.getGoal().properties) {
                    propertiesTag.add((Object)property.writeToNBT());
                }
                taskTag.func_218657_a("whitelists", (INBT)whitelistsTag);
                taskTag.func_218657_a("properties", (INBT)propertiesTag);
                taskTag.func_74768_a("state", task.getGoal().getState().ordinal());
            }
            taskListTag.func_218657_a(task.id.toString(), (INBT)taskTag);
        }
        tasksTag.func_218657_a("unlocked_task_types", (INBT)unlockedTypesTag);
        tasksTag.func_218657_a("tasks", (INBT)taskListTag);
        return tasksTag;
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT tasksTag, @Nonnull Version versionTag) {
        CompoundNBT taskListTag;
        CompoundNBT unlockedTypesTag = (CompoundNBT)tasksTag.func_74781_a("unlocked_task_types");
        if (unlockedTypesTag != null) {
            for (String typeIdString : unlockedTypesTag.func_150296_c()) {
                this.taskTypeUnlockedMap.put(BlocklingTasks.getTaskType(UUID.fromString(typeIdString)), unlockedTypesTag.func_74767_n(typeIdString));
            }
        }
        if ((taskListTag = (CompoundNBT)tasksTag.func_74781_a("tasks")) != null) {
            this.prioritisedTasks.clear();
            ArrayList<UUID> taskIds = new ArrayList<UUID>();
            ArrayList<Integer> taskPriorities = new ArrayList<Integer>();
            for (String taskIdString : taskListTag.func_150296_c()) {
                CompoundNBT taskTag = (CompoundNBT)taskListTag.func_74781_a(taskIdString);
                UUID taskId = UUID.fromString(taskIdString);
                TaskType type = BlocklingTasks.getTaskType(taskTag.func_186857_a("type_id"));
                this.createTask(type, taskId, false);
                taskIds.add(taskId);
                taskPriorities.add(taskTag.func_74762_e("priority"));
                Task task = this.getTask(taskId);
                task.setCustomName(taskTag.func_74779_i("custom_name"), false);
                if (!task.isConfigured()) continue;
                CompoundNBT whitelistsTag = (CompoundNBT)taskTag.func_74781_a("whitelists");
                for (GoalWhitelist whitelist : task.getGoal().whitelists) {
                    CompoundNBT whitelistTag = (CompoundNBT)whitelistsTag.func_74781_a(whitelist.id.toString());
                    if (whitelistTag == null) continue;
                    whitelist.readFromNBT(whitelistTag, versionTag);
                }
                ListNBT propertiesTag = (ListNBT)taskTag.func_74781_a("properties");
                if (propertiesTag != null) {
                    for (INBT tag : propertiesTag) {
                        CompoundNBT propertyTag = (CompoundNBT)tag;
                        task.getGoal().properties.stream().filter(property -> property.id.equals(propertyTag.func_186857_a("id"))).findFirst().ifPresent(property -> property.readFromNBT(propertyTag, versionTag));
                    }
                }
                task.getGoal().setState(BlocklingGoal.State.values()[taskTag.func_74762_e("state")], false);
            }
            this.prioritisedTasks = new TaskList(this.prioritisedTasks.stream().sorted((o1, o2) -> (Integer)taskPriorities.get(taskIds.indexOf(o1.id)) > (Integer)taskPriorities.get(taskIds.indexOf(o2.id)) ? 1 : -1).collect(Collectors.toList()));
            this.reapplyGoals();
        }
    }

    public void encode(PacketBuffer buf) {
        for (TaskType type : TASK_TYPES) {
            buf.writeBoolean(this.taskTypeUnlockedMap.get(type).booleanValue());
        }
        buf.writeInt(this.prioritisedTasks.size());
        for (Task task : this.prioritisedTasks) {
            buf.func_179252_a(task.getType().id);
            buf.func_179252_a(task.id);
            PacketBufferUtils.writeString(buf, task.getActualCustomName());
            if (!task.isConfigured()) continue;
            for (GoalWhitelist whitelist : task.getGoal().whitelists) {
                whitelist.encode(buf);
            }
            for (Property property : task.getGoal().properties) {
                property.encode(buf);
            }
            buf.func_179249_a((Enum)task.getGoal().getState());
        }
    }

    public void decode(PacketBuffer buf) {
        for (TaskType type : TASK_TYPES) {
            this.taskTypeUnlockedMap.put(type, buf.readBoolean());
        }
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            UUID taskTypeId = buf.func_179253_g();
            UUID taskId = buf.func_179253_g();
            this.createTask(BlocklingTasks.getTaskType(taskTypeId), taskId, false);
            Task task = this.getTask(taskId);
            task.setCustomName(PacketBufferUtils.readString(buf), false);
            if (!task.isConfigured()) continue;
            for (GoalWhitelist whitelist : task.getGoal().whitelists) {
                whitelist.decode(buf);
            }
            for (Property property : task.getGoal().properties) {
                property.decode(buf);
            }
            task.getGoal().setState((BlocklingGoal.State)buf.func_179257_a(BlocklingGoal.State.class), false);
        }
    }

    public TaskList getPrioritisedTasks() {
        return this.prioritisedTasks;
    }

    public Task getTask(UUID id) {
        return this.prioritisedTasks.stream().filter(task -> task.id.equals(id)).findFirst().orElse(null);
    }

    public void createTask(TaskType type) {
        this.createTask(type, null, true);
    }

    public void createTask(TaskType type, UUID taskId, boolean sync) {
        if (taskId != null && this.getTask(taskId) == null) {
            Task task = new Task(taskId, type, this.blockling, this);
            this.prioritisedTasks.add(task);
            this.onCreateTask.handle(new CreateTaskEvent(task));
            this.reapplyGoals();
        }
        if (sync) {
            new TaskCreateMessage(this.blockling, type.id, taskId == null ? UUID.randomUUID() : taskId).sync();
        }
    }

    public void removeTask(Task task) {
        this.removeTask(task.id, true);
    }

    public void removeTask(UUID id, boolean sync) {
        Task task = this.getTask(id);
        this.prioritisedTasks.remove(task);
        this.onRemoveTask.handle(new RemoveTaskEvent(task));
        this.reapplyGoals();
        if (sync) {
            new TaskRemoveMessage(this.blockling, id).sync();
        }
    }

    public boolean isUnlocked(TaskType type) {
        return this.taskTypeUnlockedMap.get(type);
    }

    public void setIsUnlocked(TaskType type, boolean isUnlocked) {
        this.setIsUnlocked(type, isUnlocked, true);
    }

    public void setIsUnlocked(TaskType type, boolean isUnlocked, boolean sync) {
        this.taskTypeUnlockedMap.put(type, isUnlocked);
        if (sync) {
            new TaskTypeIsUnlockedMessage(this.blockling, type, isUnlocked).sync();
        }
    }

    public int getTaskPriority(Task task) {
        return this.prioritisedTasks.indexOf(task);
    }

    public void swapTaskPriorities(Task task1, Task task2) {
        this.prioritisedTasks.swap(task1, task2);
        this.reapplyGoals();
    }

    public void setGoalPriority(Task task, int priority) {
        this.prioritisedTasks.moveTo(task, priority);
        this.reapplyGoals();
    }

    public static class RemoveTaskEvent
    extends Event {
        @Nonnull
        public final Task task;

        public RemoveTaskEvent(@Nonnull Task task) {
            this.task = task;
        }
    }

    public static class CreateTaskEvent
    extends Event {
        @Nonnull
        public final Task task;

        public CreateTaskEvent(@Nonnull Task task) {
            this.task = task;
        }
    }

    public class TaskList
    extends ArrayList<Task> {
        public TaskList() {
        }

        public TaskList(List<Task> tasks) {
            tasks.stream().forEach((? super T goal) -> this.add(goal));
        }

        public void insertAtFront(Task task) {
            if (this.isEmpty()) {
                this.add(task);
            } else {
                this.add(task);
                this.moveTo(task, this.indexOf(this.get(0)));
            }
        }

        public void insertBefore(Task task, Task target) {
            this.moveTo(task, this.indexOf(target));
        }

        public void insertAfter(Task task, Task target) {
            this.moveTo(task, this.indexOf(target) + 1);
        }

        public void moveTo(Task task, int index) {
            int oldIndex = this.indexOf(task);
            this.ensureCapacity(index + 1);
            this.set(oldIndex, null);
            this.add(index > oldIndex ? index + 1 : index, task);
            this.remove(null);
        }

        public void swap(Task task1, Task task2) {
            int oldIndex = this.indexOf(task2);
            this.set(this.indexOf(task1), task2);
            this.set(oldIndex, task1);
        }
    }
}

