/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.task;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.goal.BlocklingGoal;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.task.TaskType;
import com.willr27.blocklings.network.messages.TaskCustomNameMessage;
import com.willr27.blocklings.network.messages.TaskPriorityMessage;
import com.willr27.blocklings.network.messages.TaskSwapPriorityMessage;
import com.willr27.blocklings.network.messages.TaskTypeMessage;
import java.util.UUID;

public class Task {
    public final UUID id;
    public final BlocklingEntity blockling;
    public final BlocklingTasks tasks;
    private TaskType type;
    private String customName = "";
    private BlocklingGoal goal;

    public Task(UUID id, TaskType type, BlocklingEntity blockling, BlocklingTasks tasks) {
        this.id = id != null ? id : UUID.randomUUID();
        this.blockling = blockling;
        this.tasks = tasks;
        this.setType(type, false);
    }

    public boolean isConfigured() {
        return this.type != BlocklingTasks.NULL;
    }

    public TaskType getType() {
        return this.type;
    }

    public void setType(TaskType type) {
        this.setType(type, true);
    }

    public void setType(TaskType type, boolean sync) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.goal = type.createGoal.apply(this.id, this.blockling, this.tasks);
        this.tasks.reapplyGoals();
        if (sync) {
            new TaskTypeMessage(this.blockling, this.id, type.id).sync();
        }
    }

    public String getActualCustomName() {
        return this.customName;
    }

    public String getCustomName() {
        return !this.customName.equals("") ? this.customName : this.type.name.getString();
    }

    public void setCustomName(String customName) {
        this.setCustomName(customName, true);
    }

    public void setCustomName(String customName, boolean sync) {
        this.customName = customName;
        if (sync) {
            new TaskCustomNameMessage(this.blockling, this.id, customName).sync();
        }
    }

    public BlocklingGoal getGoal() {
        return this.goal;
    }

    public int getPriority() {
        return this.tasks.getTaskPriority(this);
    }

    public void swapPriority(Task task) {
        this.swapPriority(task, true);
    }

    public void swapPriority(Task task, boolean sync) {
        this.tasks.swapTaskPriorities(this, task);
        if (sync) {
            new TaskSwapPriorityMessage(this.blockling, this.id, task.id).sync();
        }
    }

    public void setPriority(int priority) {
        this.setPriority(priority, true);
    }

    public void setPriority(int priority, boolean sync) {
        this.tasks.setGoalPriority(this, priority);
        if (sync) {
            new TaskPriorityMessage(this.blockling, this.id, priority).sync();
        }
    }
}

