/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.task.config;

import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.goal.BlocklingGoal;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.network.BlocklingMessage;
import com.willr27.blocklings.util.IReadWriteNBT;
import com.willr27.blocklings.util.Version;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Property
implements IReadWriteNBT {
    @Nonnull
    public final UUID id;
    @Nonnull
    public final BlocklingGoal goal;
    @Nonnull
    public final ITextComponent name;
    @Nonnull
    public final ITextComponent desc;

    public Property(@Nonnull String id, @Nonnull BlocklingGoal goal, @Nonnull ITextComponent name, @Nonnull ITextComponent desc) {
        this.id = UUID.fromString(id);
        this.goal = goal;
        this.name = name;
        this.desc = desc;
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT propertyTag) {
        propertyTag.func_186854_a("id", this.id);
        return propertyTag;
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT propertyTag, @Nonnull Version tagVersion) {
    }

    public void encode(@Nonnull PacketBuffer buf) {
    }

    public void decode(@Nonnull PacketBuffer buf) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public abstract IControl createControl(@Nonnull IControl var1);

    public static class TaskPropertyMessage
    extends BlocklingMessage<TaskPropertyMessage> {
        @Nullable
        private PacketBuffer buf;
        @Nullable
        protected Property property;
        @Nullable
        private UUID taskId;
        private int propertyIndex;

        public TaskPropertyMessage() {
            super(null);
        }

        public TaskPropertyMessage(@Nonnull Property property) {
            super(property.goal.blockling);
            this.property = property;
        }

        @Override
        public void encode(@Nonnull PacketBuffer buf) {
            super.encode(buf);
            buf.func_179252_a(this.property.goal.getTask().id);
            buf.writeInt(this.property.goal.getTask().getGoal().properties.indexOf(this.property));
            this.property.encode(buf);
        }

        @Override
        public void decode(@Nonnull PacketBuffer buf) {
            super.decode(buf);
            this.taskId = buf.func_179253_g();
            this.propertyIndex = buf.readInt();
            this.buf = buf;
        }

        @Override
        protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
            Task task = blockling.getTasks().getTask(this.taskId);
            if (task != null && task.isConfigured()) {
                this.property = task.getGoal().properties.get(this.propertyIndex);
                this.property.decode(Objects.requireNonNull(this.buf));
            }
        }
    }
}

