/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.task.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.common.RangeControl;
import com.willr27.blocklings.entity.blockling.goal.BlocklingGoal;
import com.willr27.blocklings.entity.blockling.task.config.Property;
import com.willr27.blocklings.util.Version;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RangeProperty
extends Property {
    public int min;
    public int max;
    public int value;

    public RangeProperty(@Nonnull String id, @Nonnull BlocklingGoal goal, @Nonnull ITextComponent name, @Nonnull ITextComponent desc, int min, int max, int startingValue) {
        super(id, goal, name, desc);
        this.min = min;
        this.max = max;
        this.value = startingValue;
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT propertyTag) {
        propertyTag.func_74768_a("min", this.min);
        propertyTag.func_74768_a("max", this.max);
        propertyTag.func_74768_a("value", this.value);
        return super.writeToNBT(propertyTag);
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT propertyTag, @Nonnull Version tagVersion) {
        this.min = propertyTag.func_74762_e("min");
        this.max = propertyTag.func_74762_e("max");
        this.value = propertyTag.func_74762_e("value");
    }

    @Override
    public void encode(@Nonnull PacketBuffer buf) {
        buf.writeInt(this.min);
        buf.writeInt(this.max);
        buf.writeInt(this.value);
    }

    @Override
    public void decode(@Nonnull PacketBuffer buf) {
        this.min = buf.readInt();
        this.max = buf.readInt();
        this.value = buf.readInt();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public IControl createControl(@Nonnull IControl parent) {
        return new RangeControl(parent, this.min, this.max, this.value, 20){

            @Override
            public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
                if (!this.grabberControl.isPressed()) {
                    List<StringTextComponent> tooltip = GuiUtil.splitText(this.font, RangeProperty.this.desc, 200);
                    tooltip.add(0, new StringTextComponent(""));
                    tooltip.add(0, new StringTextComponent(TextFormatting.GOLD + RangeProperty.this.name.getString()));
                    this.screen.func_238654_b_(matrixStack, GuiUtil.toReorderingProcessorList(tooltip), mouseX, mouseY);
                }
            }

            @Override
            public void setValue(int value) {
                super.setValue(value);
                RangeProperty.this.setValue(this.getValue(), true);
            }
        };
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value, boolean sync) {
        this.value = value;
        if (sync) {
            new Property.TaskPropertyMessage(this).sync();
        }
    }
}

