/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.entity.blockling.whitelist;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.goal.BlocklingGoal;
import com.willr27.blocklings.entity.blockling.whitelist.Whitelist;
import com.willr27.blocklings.network.messages.WhitelistAllMessage;
import com.willr27.blocklings.network.messages.WhitelistIsUnlockedMessage;
import com.willr27.blocklings.network.messages.WhitelistSingleMessage;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import com.willr27.blocklings.util.IReadWriteNBT;
import com.willr27.blocklings.util.PacketBufferUtils;
import com.willr27.blocklings.util.Version;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class GoalWhitelist
extends Whitelist<ResourceLocation>
implements IReadWriteNBT {
    public final UUID id;
    public final String key;
    public final Whitelist.Type type;
    public final BlocklingGoal goal;
    public final BlocklingEntity blockling;
    public final TranslationTextComponent name;
    private boolean isUnlocked = true;

    public GoalWhitelist(String id, String key, Whitelist.Type type, BlocklingGoal goal) {
        this.id = UUID.fromString(id);
        this.key = key;
        this.type = type;
        this.blockling = goal.blockling;
        this.goal = goal;
        this.name = new BlocklingsTranslationTextComponent("whitelist." + key);
    }

    public GoalWhitelist(String id, String key, Whitelist.Type type, BlocklingGoal goal, Map whitelist) {
        this(id, key, type, goal);
        this.clear();
        this.putAll(whitelist);
    }

    public void setWhitelist(Whitelist<ResourceLocation> whitelist, boolean sync) {
        this.clear();
        this.putAll(whitelist);
        if (sync) {
            new WhitelistAllMessage(this.blockling, this.goal.id, this.goal.whitelists.indexOf(this), this).sync();
        }
    }

    @Override
    @Nonnull
    public CompoundNBT writeToNBT(CompoundNBT whitelistTag) {
        whitelistTag.func_74757_a("is_unlocked", this.isUnlocked);
        for (Map.Entry entry : this.entrySet()) {
            whitelistTag.func_74757_a(((ResourceLocation)entry.getKey()).toString(), ((Boolean)entry.getValue()).booleanValue());
        }
        return whitelistTag;
    }

    @Override
    @Nonnull
    public void readFromNBT(@Nonnull CompoundNBT whitelistTag, @Nonnull Version tagVersion) {
        this.setIsUnlocked(whitelistTag.func_74767_n("is_unlocked"), false);
        for (Map.Entry entry : this.entrySet()) {
            if (!whitelistTag.func_74764_b(((ResourceLocation)entry.getKey()).toString())) continue;
            this.put(entry.getKey(), whitelistTag.func_74767_n(((ResourceLocation)entry.getKey()).toString()));
        }
    }

    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.isUnlocked);
        buf.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            PacketBufferUtils.writeString(buf, ((ResourceLocation)entry.getKey()).toString());
            buf.writeBoolean(((Boolean)entry.getValue()).booleanValue());
        }
    }

    public void decode(PacketBuffer buf) {
        this.setIsUnlocked(buf.readBoolean(), false);
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(new ResourceLocation(PacketBufferUtils.readString(buf)), buf.readBoolean());
        }
    }

    public boolean isEntryWhitelisted(Object entry) {
        Boolean result = null;
        result = entry instanceof Block ? (Boolean)this.get(((Block)entry).getRegistryName()) : (entry instanceof Item ? (Boolean)this.get(((Item)entry).getRegistryName()) : (entry instanceof Entity ? (Boolean)this.get(((Entity)entry).func_200600_R().getRegistryName()) : (Boolean)this.get(entry)));
        return result != null ? result : false;
    }

    public boolean isEntryBlacklisted(Object entry) {
        return !this.isEntryWhitelisted(entry);
    }

    @Override
    public void setEntry(ResourceLocation entry, boolean value) {
        this.setEntry(entry, value, true);
    }

    public void setEntry(ResourceLocation entry, boolean value, boolean sync) {
        super.setEntry(entry, value);
        if (sync) {
            new WhitelistSingleMessage(this.blockling, this.goal.id, this.goal.whitelists.indexOf(this), entry, value).sync();
        }
    }

    @Override
    public void toggleEntry(ResourceLocation entry) {
        this.toggleEntry(entry, true);
    }

    public void toggleEntry(ResourceLocation entry, boolean sync) {
        this.setEntry(entry, (Boolean)this.get(entry) == false, sync);
    }

    @Override
    public void setAll(boolean value) {
        this.setAll(value, true);
    }

    public void setAll(boolean value, boolean sync) {
        for (ResourceLocation entry : this.keySet()) {
            this.setEntry(entry, value, false);
        }
        if (sync) {
            new WhitelistAllMessage(this.blockling, this.goal.id, this.goal.whitelists.indexOf(this), this).sync();
        }
    }

    @Override
    public void toggleAll() {
        this.toggleAll(true);
    }

    public void toggleAll(boolean sync) {
        for (ResourceLocation entry : this.keySet()) {
            this.toggleEntry(entry, false);
        }
        if (sync) {
            new WhitelistAllMessage(this.blockling, this.goal.id, this.goal.whitelists.indexOf(this), this).sync();
        }
    }

    public boolean isUnlocked() {
        return this.isUnlocked;
    }

    public void setIsUnlocked(boolean isUnlocked) {
        this.setIsUnlocked(isUnlocked, true);
    }

    public void setIsUnlocked(boolean isUnlocked, boolean sync) {
        this.isUnlocked = isUnlocked;
        if (sync) {
            new WhitelistIsUnlockedMessage(this.blockling, this.goal.id, this.goal.whitelists.indexOf(this), isUnlocked).sync();
        }
    }
}

