/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.event;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingType;
import com.willr27.blocklings.entity.blockling.skill.skills.CombatSkills;
import com.willr27.blocklings.item.BlocklingWhistleItem;
import com.willr27.blocklings.util.EntityUtil;
import com.willr27.blocklings.util.ToolUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blocklings", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventBusEvents {
    @SubscribeEvent
    public static void onWorldLoad(@Nonnull WorldEvent.Load event) {
        EntityUtil.latestWorld = (World)event.getWorld();
        BlocklingType.init();
        ToolUtil.init();
        BlocklingWhistleItem.BLOCKLINGS_TO_WHISTLES.clear();
    }

    @SubscribeEvent
    public static void onEntitySize(@Nonnull EntityEvent.Size event) {
        if (event.getEntity() instanceof BlocklingEntity) {
            float scale = ((BlocklingEntity)event.getEntity()).func_213355_cm();
            event.setNewSize(new EntitySize(scale * 1.0f, scale * 1.0f, true), true);
        }
    }

    @SubscribeEvent
    public static void onLootingLevelEvent(@Nonnull LootingLevelEvent event) {
        BlocklingEntity blockling;
        if (event.getDamageSource().func_76346_g() instanceof BlocklingEntity && (blockling = (BlocklingEntity)event.getDamageSource().func_76346_g()) != null && (blockling.getNaturalBlocklingType() == BlocklingType.LAPIS || blockling.getBlocklingType() == BlocklingType.LAPIS)) {
            event.setLootingLevel(event.getLootingLevel() + 1);
        }
    }

    @SubscribeEvent
    public static void onLivingDropsEvent(@Nonnull LivingDropsEvent event) {
        BlocklingEntity blockling;
        if (event.getSource().func_76346_g() instanceof BlocklingEntity && (blockling = (BlocklingEntity)event.getSource().func_76346_g()).getSkills().getSkill(CombatSkills.HUNTER).isBought() && blockling.wasLastAttackHunt) {
            for (ItemEntity itemEntity : event.getDrops()) {
                ItemStack itemStack = blockling.getEquipment().addItem(itemEntity.func_92059_d());
                if (blockling.getSkills().getSkill(CombatSkills.ANIMAL_HUNTER).isBought() && event.getEntity() instanceof AnimalEntity) {
                    itemStack.func_190920_e(itemStack.func_190916_E() * 2);
                } else if (blockling.getSkills().getSkill(CombatSkills.MONSTER_HUNTER).isBought() && event.getEntity() instanceof MonsterEntity) {
                    itemStack.func_190920_e(itemStack.func_190916_E() * 2);
                }
                if ((itemStack = blockling.getEquipment().addItem(itemStack)).func_190926_b()) continue;
                blockling.dropItemStack(itemStack);
            }
            event.setCanceled(true);
        }
    }
}

