/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.event;

import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.config.BlocklingsConfig;
import com.willr27.blocklings.entity.BlocklingsEntityTypes;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingType;
import com.willr27.blocklings.util.BlocklingsResourceLocation;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.EntityType;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blocklings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEventBusEvents {
    private static boolean blocklingTextureStitched = false;

    @SubscribeEvent
    public static void addEntityAttributes(@Nonnull EntityAttributeCreationEvent event) {
        event.put((EntityType)BlocklingsEntityTypes.BLOCKLING.get(), BlocklingEntity.createAttributes().func_233813_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onTextureStitch(@Nonnull TextureStitchEvent.Post event) {
        if (blocklingTextureStitched) {
            return;
        }
        blocklingTextureStitched = true;
        if (((Boolean)BlocklingsConfig.CLIENT.disableDirtyBlocklings.get()).booleanValue()) {
            Blocklings.LOGGER.info("Skipping texture creation for merged blockling textures.");
            return;
        }
        BlocklingsResourceLocation texture = null;
        for (int mask = 0; mask < 3; ++mask) {
            NativeImage maskNativeImage;
            try {
                texture = new BlocklingsResourceLocation("textures/entity/blockling/blockling_mask_" + mask + ".png");
                maskNativeImage = SimpleTexture.TextureData.func_217799_a((IResourceManager)Minecraft.func_71410_x().func_195551_G(), (ResourceLocation)texture).func_217800_b();
            }
            catch (IOException e) {
                Blocklings.LOGGER.warn("Couldn't find texture: " + texture);
                continue;
            }
            for (BlocklingType baseBlocklingType : BlocklingType.TYPES) {
                NativeImage baseNativeImage;
                try {
                    baseNativeImage = SimpleTexture.TextureData.func_217799_a((IResourceManager)Minecraft.func_71410_x().func_195551_G(), (ResourceLocation)baseBlocklingType.entityTexture).func_217800_b();
                }
                catch (IOException e) {
                    Blocklings.LOGGER.warn("Couldn't find texture: " + baseBlocklingType.entityTexture);
                    continue;
                }
                for (BlocklingType outerBlocklingType : BlocklingType.TYPES) {
                    NativeImage outerNativeImage;
                    try {
                        outerNativeImage = SimpleTexture.TextureData.func_217799_a((IResourceManager)Minecraft.func_71410_x().func_195551_G(), (ResourceLocation)outerBlocklingType.entityTexture).func_217800_b();
                    }
                    catch (IOException e) {
                        Blocklings.LOGGER.warn("Couldn't find texture: " + outerBlocklingType.entityTexture);
                        continue;
                    }
                    for (int i = 0; i < baseNativeImage.func_195702_a(); ++i) {
                        for (int j = 0; j < baseNativeImage.func_195714_b(); ++j) {
                            float maskAlpha = (float)(maskNativeImage.func_195709_a(i, j) >> 24 & 0xFF) / 255.0f;
                            int baseColour = baseNativeImage.func_195709_a(i, j);
                            int baseBlue = baseColour >> 16 & 0xFF;
                            int baseGreen = baseColour >> 8 & 0xFF;
                            int baseRed = baseColour & 0xFF;
                            int outerColour = outerNativeImage.func_195709_a(i, j);
                            int outerBlue = outerColour >> 16 & 0xFF;
                            int outerGreen = outerColour >> 8 & 0xFF;
                            int outerRed = outerColour & 0xFF;
                            int a = 255;
                            int b = (int)((float)baseBlue * maskAlpha + (float)outerBlue * (1.0f - maskAlpha));
                            int g = (int)((float)baseGreen * maskAlpha + (float)outerGreen * (1.0f - maskAlpha));
                            int r = (int)((float)baseRed * maskAlpha + (float)outerRed * (1.0f - maskAlpha));
                            int colour = (a << 24) + (b << 16) + (g << 8) + r;
                            outerNativeImage.func_195700_a(i, j, colour);
                        }
                    }
                    Minecraft.func_71410_x().field_71446_o.func_229263_a_(baseBlocklingType.getCombinedTexture(outerBlocklingType, mask), (Texture)new DynamicTexture(outerNativeImage));
                }
            }
        }
    }
}

