/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.interop;

import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.interop.Proxy;
import java.lang.reflect.Field;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class ModProxies {
    public static void init() {
        for (ModFileScanData modFileScanData : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotationData : modFileScanData.getAnnotations()) {
                if (!annotationData.getAnnotationType().equals((Object)Type.getType(Proxy.class))) continue;
                try {
                    Class<?> proxyClass = Class.forName(annotationData.getClassType().getClassName());
                    Proxy proxyAnnotation = proxyClass.getAnnotation(Proxy.class);
                    if (proxyAnnotation == null) continue;
                    Field instanceField = proxyClass.getDeclaredField("instance");
                    String activeClassName = proxyAnnotation.activeClassName();
                    if (activeClassName.isEmpty()) {
                        activeClassName = proxyClass.getPackage().getName() + ".Active" + proxyClass.getSimpleName();
                    }
                    if (!ModList.get().isLoaded(proxyAnnotation.modid())) continue;
                    instanceField.set(null, Class.forName(activeClassName).asSubclass(proxyClass).newInstance());
                }
                catch (Exception ex) {
                    Blocklings.LOGGER.error(String.format("Failed to create mod proxy for \"%s\" : %s", annotationData.getClassType().getClassName(), ex));
                }
            }
        }
    }
}

