/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.inventory;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.util.IReadWriteNBT;
import com.willr27.blocklings.util.Version;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;

public abstract class AbstractInventory
implements IInventory,
IReadWriteNBT {
    public final int invSize;
    protected BlocklingEntity blockling;
    protected World world;
    protected ItemStack[] stacks;
    protected ItemStack[] stacksCopy;
    private boolean dirty = false;

    public AbstractInventory(BlocklingEntity blockling, int invSize) {
        this.blockling = blockling;
        this.world = blockling.field_70170_p;
        this.invSize = invSize;
        this.stacks = new ItemStack[invSize];
        this.stacksCopy = new ItemStack[invSize];
        this.func_174888_l();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.stacksCopy[i] = ItemStack.field_190927_a;
        }
    }

    @Override
    public CompoundNBT writeToNBT(@Nonnull CompoundNBT equipmentInvTag) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.stacks[i];
            if (stack.func_190926_b()) continue;
            CompoundNBT stackTag = new CompoundNBT();
            stackTag.func_74768_a("slot", i);
            stack.func_77955_b(stackTag);
            list.add((Object)stackTag);
        }
        equipmentInvTag.func_218657_a("slots", (INBT)list);
        return equipmentInvTag;
    }

    @Override
    public void readFromNBT(@Nonnull CompoundNBT invTag, @Nonnull Version tagVersion) {
        ListNBT list = (ListNBT)invTag.func_74781_a("slots");
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT stackTag = list.func_150305_b(i);
                int slot = stackTag.func_74762_e("slot");
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)stackTag);
                if (slot >= this.stacks.length) continue;
                this.func_70299_a(slot, stack);
            }
        }
    }

    public void encode(PacketBuffer buf) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            buf.writeItemStack(this.stacks[i], false);
        }
    }

    public void decode(PacketBuffer buf) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, buf.func_150791_c());
        }
    }

    public void func_70296_d() {
    }

    public int func_70302_i_() {
        return this.invSize;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.stacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        ItemStack copy = stack.func_77946_l();
        stack.func_190918_g(count);
        this.func_70299_a(index, stack);
        copy.func_190920_e(count);
        return copy;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.stacks[index] = ItemStack.field_190927_a;
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks[index] = stack;
    }

    public void swapItems(int slot1, int slot2) {
        ItemStack stack1 = this.func_70301_a(slot1);
        this.func_70299_a(slot1, this.func_70301_a(slot2));
        this.func_70299_a(slot2, stack1);
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70304_b(i);
        }
    }

    public int find(Item item) {
        return this.find(item, 0, this.func_70302_i_() - 1);
    }

    public int find(Item item, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex + 1; ++i) {
            if (this.func_70301_a(i).func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public boolean has(ItemStack stack) {
        return this.has(stack, 0, this.func_70302_i_() - 1);
    }

    public boolean has(ItemStack stack, int startIndex, int endIndex) {
        int count = 0;
        for (int i = startIndex; i < endIndex + 1; ++i) {
            ItemStack slotStack = this.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)slotStack, (ItemStack)stack) || (count += slotStack.func_190916_E()) < stack.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public boolean take(ItemStack stack) {
        return this.take(stack, 0, this.func_70302_i_() - 1);
    }

    public boolean take(ItemStack stack, int startIndex, int endIndex) {
        if (!this.has(stack)) {
            return false;
        }
        int remainder = stack.func_190916_E();
        for (int i = startIndex; i < endIndex + 1; ++i) {
            ItemStack slotStack = this.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)slotStack, (ItemStack)stack)) continue;
            int slotCount = slotStack.func_190916_E();
            if (slotCount >= remainder) {
                slotStack.func_190918_g(remainder);
                break;
            }
            remainder -= slotCount;
            slotStack.func_190918_g(slotCount);
        }
        return true;
    }

    public boolean couldAddItem(ItemStack stack, int slot) {
        boolean couldAdd = true;
        ItemStack slotStack = this.func_70301_a(slot);
        if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)slotStack)) {
            couldAdd = slotStack.func_190916_E() + stack.func_190916_E() <= slotStack.func_77976_d();
        }
        return couldAdd;
    }

    public ItemStack addItem(ItemStack stack, int slot) {
        ItemStack slotStack = this.func_70301_a(slot);
        if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)slotStack)) {
            int amountToAdd = stack.func_190916_E();
            amountToAdd = Math.min(amountToAdd, slotStack.func_77976_d() - slotStack.func_190916_E());
            stack.func_190918_g(amountToAdd);
            slotStack.func_190917_f(amountToAdd);
            this.func_70299_a(slot, slotStack);
        } else {
            this.func_70299_a(slot, stack.func_77946_l());
            stack.func_190918_g(stack.func_190916_E());
        }
        return stack;
    }

    public ItemStack addItem(ItemStack stack) {
        ItemStack slotStack;
        int i;
        int maxStackSize = stack.func_77976_d();
        for (i = 0; i < this.invSize && !stack.func_190926_b(); ++i) {
            slotStack = this.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)slotStack)) continue;
            int amountToAdd = stack.func_190916_E();
            amountToAdd = Math.min(amountToAdd, maxStackSize - slotStack.func_190916_E());
            stack.func_190918_g(amountToAdd);
            slotStack.func_190917_f(amountToAdd);
            this.func_70299_a(i, slotStack);
        }
        for (i = 0; i < this.invSize && !stack.func_190926_b(); ++i) {
            slotStack = this.func_70301_a(i);
            if (!slotStack.func_190926_b()) continue;
            this.func_70299_a(i, stack.func_77946_l());
            stack.func_190920_e(0);
            break;
        }
        return stack;
    }
}

