/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.inventory;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.inventory.AbstractInventory;
import com.willr27.blocklings.network.messages.EquipmentInventoryMessage;
import com.willr27.blocklings.util.ToolContext;
import com.willr27.blocklings.util.ToolType;
import com.willr27.blocklings.util.ToolUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jline.utils.Log;

public class EquipmentInventory
extends AbstractInventory {
    public static final int TOOL_MAIN_HAND = 0;
    public static final int TOOL_OFF_HAND = 1;

    public EquipmentInventory(@Nonnull BlocklingEntity blockling) {
        super(blockling, 26);
    }

    @Nonnull
    public BlocklingHand findHandToolEquipped(@Nonnull ToolType toolType) {
        boolean hasInMain = this.hasToolEquipped(Hand.MAIN_HAND);
        boolean hasInOff = this.hasToolEquipped(Hand.OFF_HAND);
        if (hasInMain && hasInOff) {
            return BlocklingHand.BOTH;
        }
        if (hasInMain) {
            return BlocklingHand.MAIN;
        }
        if (hasInOff) {
            return BlocklingHand.OFF;
        }
        return BlocklingHand.NONE;
    }

    public boolean hasToolEquipped(@Nonnull Hand hand) {
        return ToolUtil.isTool(this.getHandStack(hand));
    }

    public boolean hasToolEquipped(@Nonnull ToolType toolType) {
        return this.hasToolEquipped(Hand.MAIN_HAND, toolType) || this.hasToolEquipped(Hand.OFF_HAND, toolType);
    }

    public boolean hasToolEquipped(@Nonnull Hand hand, @Nonnull ToolType toolType) {
        return toolType.is(this.getHandStack(hand));
    }

    @Nonnull
    public ItemStack getHandStack(@Nonnull Hand hand) {
        return hand == Hand.MAIN_HAND ? this.func_70301_a(0) : this.func_70301_a(1);
    }

    public void setHandStack(@Nonnull Hand hand, @Nonnull ItemStack stack) {
        if (hand == Hand.MAIN_HAND) {
            this.func_70299_a(0, stack);
        } else if (hand == Hand.OFF_HAND) {
            this.func_70299_a(1, stack);
        }
    }

    public boolean isAttackingWith(@Nonnull BlocklingHand hand) {
        BlocklingHand attackingHand = this.findAttackingHand();
        if (hand == BlocklingHand.BOTH && attackingHand == BlocklingHand.BOTH) {
            return true;
        }
        if (hand == BlocklingHand.MAIN && (attackingHand == BlocklingHand.BOTH || attackingHand == BlocklingHand.MAIN)) {
            return true;
        }
        if (hand == BlocklingHand.OFF && (attackingHand == BlocklingHand.BOTH || attackingHand == BlocklingHand.OFF)) {
            return true;
        }
        return hand == BlocklingHand.NONE && attackingHand == BlocklingHand.NONE;
    }

    @Nonnull
    public BlocklingHand findAttackingHand() {
        if (this.hasUseableWeapon(Hand.MAIN_HAND) && this.hasUseableWeapon(Hand.OFF_HAND)) {
            return BlocklingHand.BOTH;
        }
        if (this.hasUseableWeapon(Hand.MAIN_HAND) && !this.hasUseableWeapon(Hand.OFF_HAND)) {
            return BlocklingHand.MAIN;
        }
        if (!this.hasUseableWeapon(Hand.MAIN_HAND) && this.hasUseableWeapon(Hand.OFF_HAND)) {
            return BlocklingHand.OFF;
        }
        if (this.hasUseableTool(Hand.MAIN_HAND) && !this.hasUseableTool(Hand.OFF_HAND)) {
            return BlocklingHand.MAIN;
        }
        if (!this.hasUseableTool(Hand.MAIN_HAND) && this.hasUseableTool(Hand.OFF_HAND)) {
            return BlocklingHand.OFF;
        }
        return BlocklingHand.BOTH;
    }

    public boolean hasUseableWeapon(@Nonnull Hand hand) {
        return this.hasToolEquipped(hand, ToolType.WEAPON) && ToolUtil.isUseableTool(this.getHandStack(hand));
    }

    public boolean hasUseableTool(@Nonnull Hand hand) {
        return ToolUtil.isUseableTool(this.getHandStack(hand));
    }

    public boolean canHarvestBlockWithEquippedTools(@Nonnull BlockState blockState) {
        return this.canHarvestBlockWithEquippedTool(Hand.MAIN_HAND, blockState) || this.canHarvestBlockWithEquippedTool(Hand.OFF_HAND, blockState);
    }

    public boolean canHarvestBlockWithEquippedTool(@Nonnull Hand hand, @Nonnull BlockState blockState) {
        return ToolUtil.canToolHarvest(this.getHandStack(hand), blockState);
    }

    public boolean trySwitchToBestTool(@Nonnull BlocklingHand hand, @Nonnull ToolContext context) {
        Pair<SwitchedTools, SwitchedTools> bestToolSlots = this.findBestToolSlotsToSwitchTo(hand, context);
        int mainHandSlot = ((SwitchedTools)bestToolSlots.getKey()).originalSlot;
        int mainBestSlot = ((SwitchedTools)bestToolSlots.getKey()).bestSlot;
        int offHandSlot = ((SwitchedTools)bestToolSlots.getValue()).originalSlot;
        int offBestSlot = ((SwitchedTools)bestToolSlots.getValue()).bestSlot;
        boolean result = false;
        if (mainHandSlot != mainBestSlot) {
            this.swapItems(mainHandSlot, mainBestSlot);
            result = true;
        }
        if (offHandSlot != offBestSlot) {
            this.swapItems(offHandSlot, offBestSlot);
            result = true;
        }
        return result;
    }

    @Nonnull
    public Pair<ItemStack, ItemStack> findBestToolsToSwitchTo(@Nonnull BlocklingHand hand, @Nonnull ToolContext context) {
        Pair<SwitchedTools, SwitchedTools> bestTools = this.findBestToolSlotsToSwitchTo(hand, context);
        return new MutablePair((Object)this.func_70301_a(((SwitchedTools)bestTools.getKey()).bestSlot), (Object)this.func_70301_a(((SwitchedTools)bestTools.getValue()).bestSlot));
    }

    @Nonnull
    public Pair<SwitchedTools, SwitchedTools> findBestToolSlotsToSwitchTo(@Nonnull BlocklingHand hand, @Nonnull ToolContext context) {
        if (hand == BlocklingHand.MAIN) {
            return new MutablePair((Object)this.findBestToolSlotToSwitchTo(BlocklingHand.MAIN, context), (Object)new SwitchedTools(1, 1));
        }
        if (hand == BlocklingHand.OFF) {
            return new MutablePair((Object)new SwitchedTools(0, 0), (Object)this.findBestToolSlotToSwitchTo(BlocklingHand.OFF, context));
        }
        if (hand == BlocklingHand.BOTH) {
            SwitchedTools toolSlotsMain = this.findBestToolSlotToSwitchTo(BlocklingHand.MAIN, context);
            if (toolSlotsMain.bestSlot != 0) {
                this.swapItems(toolSlotsMain.originalSlot, toolSlotsMain.bestSlot);
            }
            SwitchedTools toolSlotsOff = this.findBestToolSlotToSwitchTo(BlocklingHand.OFF, context);
            if (toolSlotsMain.bestSlot != 0) {
                this.swapItems(toolSlotsMain.originalSlot, toolSlotsMain.bestSlot);
            }
            return new MutablePair((Object)toolSlotsMain, (Object)toolSlotsOff);
        }
        return new MutablePair((Object)new SwitchedTools(0, 0), (Object)new SwitchedTools(1, 1));
    }

    @Nonnull
    public SwitchedTools findBestToolSlotToSwitchTo(@Nonnull BlocklingHand hand, @Nonnull ToolContext context) {
        int bestSlot;
        if (hand != BlocklingHand.MAIN && hand != BlocklingHand.OFF) {
            Log.warn((Object[])new Object[]{"Tried to find the best tool to switch to with a hand that wasn't MAIN or OFF!"});
            return new SwitchedTools(1, 1);
        }
        int handSlot = bestSlot = hand == BlocklingHand.MAIN ? 0 : 1;
        ItemStack handStack = this.func_70301_a(handSlot);
        if (context.toolType == ToolType.WEAPON) {
            float bestAttackPower = ToolUtil.getToolAttackSpeed(handStack, context.entity) * ToolUtil.getToolBaseDamage(handStack, context.entity);
            for (int i = 2; i < this.func_70302_i_(); ++i) {
                ItemStack stack = this.stacks[i];
                float attackPower = ToolUtil.getToolAttackSpeed(stack, context.entity) * ToolUtil.getToolBaseDamage(stack, context.entity);
                if (!(attackPower > bestAttackPower)) continue;
                bestSlot = i;
                bestAttackPower = attackPower;
            }
        } else {
            float bestSpeed = context.toolType.is(handStack) ? ToolUtil.getToolHarvestSpeedWithEnchantments(handStack, context.blockState) : 0.0f;
            for (int i = 2; i < this.func_70302_i_(); ++i) {
                float speed;
                ItemStack stack = this.stacks[i];
                if (!context.toolType.is(stack) || !ToolUtil.canToolHarvest(stack, context.blockState) || !((speed = ToolUtil.getToolHarvestSpeedWithEnchantments(stack, context.blockState)) > bestSpeed)) continue;
                bestSlot = i;
                bestSpeed = speed;
            }
        }
        return new SwitchedTools(handSlot, bestSlot);
    }

    @Override
    public ItemStack addItem(@Nonnull ItemStack stack) {
        ItemStack slotStack;
        int i;
        int maxStackSize = stack.func_77976_d();
        for (i = 0; i < this.invSize && !stack.func_190926_b(); ++i) {
            if (i >= 0 && i <= 1 && !ToolUtil.isTool(stack) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)(slotStack = this.func_70301_a(i)))) continue;
            int amountToAdd = stack.func_190916_E();
            amountToAdd = Math.min(amountToAdd, maxStackSize - slotStack.func_190916_E());
            stack.func_190918_g(amountToAdd);
            slotStack.func_190917_f(amountToAdd);
            this.func_70299_a(i, slotStack);
        }
        for (i = 0; i < this.invSize && !stack.func_190926_b(); ++i) {
            if (i >= 0 && i <= 1 && !ToolUtil.isTool(stack) || !(slotStack = this.func_70301_a(i)).func_190926_b()) continue;
            this.func_70299_a(i, stack.func_77946_l());
            stack.func_190920_e(0);
            break;
        }
        return stack;
    }

    @Override
    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        super.func_70299_a(index, stack);
        if (index == 0 || index == 1) {
            this.updateToolAttributes();
        }
    }

    public void updateToolAttributes() {
        BlocklingAttributes stats = this.blockling.getStats();
        stats.mainHandAttackDamageToolModifier.setValue(Float.valueOf(0.0f), false);
        stats.offHandAttackDamageToolModifier.setValue(Float.valueOf(0.0f), false);
        stats.attackSpeedMainHandModifier.setValue(Float.valueOf(0.0f), false);
        stats.attackSpeedOffHandModifier.setValue(Float.valueOf(0.0f), false);
        stats.miningSpeedMainHandModifier.setValue(Float.valueOf(0.0f), false);
        stats.miningSpeedOffHandModifier.setValue(Float.valueOf(0.0f), false);
        stats.woodcuttingSpeedMainHandModifier.setValue(Float.valueOf(0.0f), false);
        stats.woodcuttingSpeedOffHandModifier.setValue(Float.valueOf(0.0f), false);
        stats.farmingSpeedMainHandModifier.setValue(Float.valueOf(0.0f), false);
        stats.farmingSpeedOffHandModifier.setValue(Float.valueOf(0.0f), false);
        if (this.isAttackingWith(BlocklingHand.MAIN) && this.hasToolEquipped(Hand.MAIN_HAND)) {
            stats.mainHandAttackDamageToolModifier.setValue(Float.valueOf(ToolUtil.getDefaultToolBaseDamage(this.blockling.func_184614_ca())), false);
            stats.attackSpeedMainHandModifier.setValue(Float.valueOf(ToolUtil.getDefaultToolAttackSpeed(this.blockling.func_184614_ca())), false);
        }
        if (this.isAttackingWith(BlocklingHand.OFF) && this.hasToolEquipped(Hand.OFF_HAND)) {
            stats.offHandAttackDamageToolModifier.setValue(Float.valueOf(ToolUtil.getDefaultToolBaseDamage(this.blockling.func_184592_cb())), false);
            stats.attackSpeedOffHandModifier.setValue(Float.valueOf(ToolUtil.getDefaultToolAttackSpeed(this.blockling.func_184592_cb())), false);
        }
        if (this.hasToolEquipped(Hand.MAIN_HAND, ToolType.PICKAXE)) {
            stats.miningSpeedMainHandModifier.setValue(Float.valueOf(ToolUtil.getDefaultToolMiningSpeed(this.blockling.func_184614_ca())), false);
        } else if (this.hasToolEquipped(Hand.MAIN_HAND, ToolType.AXE)) {
            stats.woodcuttingSpeedMainHandModifier.setValue(Float.valueOf(ToolUtil.getDefaultToolWoodcuttingSpeed(this.blockling.func_184614_ca())), false);
        } else if (this.hasToolEquipped(Hand.MAIN_HAND, ToolType.HOE)) {
            stats.farmingSpeedMainHandModifier.setValue(Float.valueOf(ToolUtil.getDefaultToolFarmingSpeed(this.blockling.func_184614_ca())), false);
        }
        if (this.hasToolEquipped(Hand.OFF_HAND, ToolType.PICKAXE)) {
            stats.miningSpeedOffHandModifier.setValue(Float.valueOf(ToolUtil.getDefaultToolMiningSpeed(this.blockling.func_184592_cb())), false);
        } else if (this.hasToolEquipped(Hand.OFF_HAND, ToolType.AXE)) {
            stats.woodcuttingSpeedOffHandModifier.setValue(Float.valueOf(ToolUtil.getDefaultToolWoodcuttingSpeed(this.blockling.func_184592_cb())), false);
        } else if (this.hasToolEquipped(Hand.OFF_HAND, ToolType.HOE)) {
            stats.farmingSpeedOffHandModifier.setValue(Float.valueOf(ToolUtil.getDefaultToolFarmingSpeed(this.blockling.func_184592_cb())), false);
        }
    }

    public void detectAndSendChanges() {
        if (!this.world.field_72995_K) {
            for (int i = 0; i < this.invSize; ++i) {
                ItemStack oldStack = this.stacksCopy[i];
                ItemStack newStack = this.stacks[i];
                if (ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack)) continue;
                if (newStack.func_190926_b() && oldStack.func_190926_b()) {
                    this.stacks[i] = ItemStack.field_190927_a;
                    this.stacksCopy[i] = ItemStack.field_190927_a;
                    continue;
                }
                new EquipmentInventoryMessage(this.blockling, i, newStack).sync();
                this.stacksCopy[i] = newStack.func_77946_l();
            }
        }
    }

    public static class SwitchedTools {
        public final int originalSlot;
        public final int bestSlot;

        public SwitchedTools(int originalSlot, int bestSlot) {
            this.originalSlot = originalSlot;
            this.bestSlot = bestSlot;
        }
    }
}

