/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.item;

import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.entity.BlocklingsEntityTypes;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingType;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.item.BlocklingsItems;
import com.willr27.blocklings.util.BlocklingsResourceLocation;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import com.willr27.blocklings.util.ObjectUtil;
import com.willr27.blocklings.util.Version;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.DeferredWorkQueue;

public class BlocklingItem
extends Item {
    public BlocklingItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
    }

    @Nonnull
    public static ItemStack create(@Nonnull BlocklingEntity blockling) {
        ItemStack stack = new ItemStack((IItemProvider)BlocklingsItems.BLOCKLING.get(), 1);
        stack.func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + blockling.func_200201_e().getString()));
        CompoundNBT stackTag = stack.func_196082_o();
        CompoundNBT entityTag = new CompoundNBT();
        blockling.func_213281_b(entityTag);
        stackTag.func_218657_a("entity", (INBT)entityTag);
        stackTag.func_74778_a("custom_name", blockling.func_200201_e().getString());
        stackTag.func_74768_a("health", blockling.getStats().getHealth());
        stackTag.func_74768_a("max_health", blockling.getStats().getMaxHealth());
        stackTag.func_74768_a("combat_level", blockling.getStats().getLevelAttribute(BlocklingAttributes.Level.COMBAT).getValue().intValue());
        stackTag.func_74768_a("mining_level", blockling.getStats().getLevelAttribute(BlocklingAttributes.Level.MINING).getValue().intValue());
        stackTag.func_74768_a("woodcutting_level", blockling.getStats().getLevelAttribute(BlocklingAttributes.Level.WOODCUTTING).getValue().intValue());
        stackTag.func_74768_a("farming_level", blockling.getStats().getLevelAttribute(BlocklingAttributes.Level.FARMING).getValue().intValue());
        stackTag.func_74768_a("total_level", blockling.getStats().getLevelAttribute(BlocklingAttributes.Level.TOTAL).getValue().intValue());
        return stack;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            ItemStack stack = context.func_195996_i();
            BlockPos blockpos = context.func_195995_a();
            Direction direction = context.func_196000_l();
            BlockState blockstate = world.func_180495_p(blockpos);
            if (!blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b()) {
                blockpos = blockpos.func_177972_a(direction);
            }
            BlocklingEntity blockling = new BlocklingEntity((EntityType<? extends BlocklingEntity>)((EntityType)BlocklingsEntityTypes.BLOCKLING.get()), world);
            CompoundNBT stackTag = stack.func_77978_p();
            CompoundNBT entityTag = null;
            if (stackTag != null && stackTag.func_74764_b("entity")) {
                entityTag = stackTag.func_74775_l("entity");
            }
            blockling.func_213386_a((IServerWorld)world, world.func_175649_E(blockpos), SpawnReason.SPAWN_EGG, null, entityTag);
            if (entityTag == null || !entityTag.func_74764_b("blockling")) {
                for (Task task : blockling.getTasks().getPrioritisedTasks()) {
                    if (!task.isConfigured() || task.getType() != BlocklingTasks.WANDER) continue;
                    task.setType(BlocklingTasks.FOLLOW, false);
                }
            }
            blockling.func_70107_b((double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5);
            blockling.func_193101_c(context.func_195999_j());
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("custom_name")) {
                blockling.func_200203_b((ITextComponent)new StringTextComponent(stack.func_77978_p().func_74779_i("custom_name")));
            }
            world.func_217376_c((Entity)blockling);
            if (!context.func_195999_j().field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        CompoundNBT stackTag = stack.func_77978_p();
        if (stackTag != null && stackTag.func_74764_b("entity")) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + new BlocklingsTranslationTextComponent("attribute.health.name").getString() + ": " + stackTag.func_74762_e("health") + "/" + stackTag.func_74762_e("max_health")));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + new BlocklingsTranslationTextComponent("attribute.combat_level.name").getString() + ": " + stackTag.func_74762_e("combat_level")));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + new BlocklingsTranslationTextComponent("attribute.mining_level.name").getString() + ": " + stackTag.func_74762_e("mining_level")));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + new BlocklingsTranslationTextComponent("attribute.woodcutting_level.name").getString() + ": " + stackTag.func_74762_e("woodcutting_level")));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + new BlocklingsTranslationTextComponent("attribute.farming_level.name").getString() + ": " + stackTag.func_74762_e("farming_level")));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + new BlocklingsTranslationTextComponent("attribute.total_level.name").getString() + ": " + stackTag.func_74762_e("total_level")));
            tooltip.add((ITextComponent)new StringTextComponent(""));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public static void registerItemModelsProperties() {
        DeferredWorkQueue.runLater(() -> ItemModelsProperties.func_239418_a_((Item)((Item)BlocklingsItems.BLOCKLING.get()), (ResourceLocation)new BlocklingsResourceLocation("type"), (stack, world, entity) -> {
            CompoundNBT blocklingTag;
            CompoundNBT entityTag;
            CompoundNBT stackTag = stack.func_77978_p();
            if (stackTag != null && (entityTag = stackTag.func_74775_l("entity")) != null && (blocklingTag = entityTag.func_74775_l("blockling")) != null) {
                return BlocklingType.TYPES.indexOf(BlocklingType.find(blocklingTag.func_74779_i("type"), ObjectUtil.coalesce(new Version(blocklingTag.func_74779_i("blocklings_version")), Blocklings.VERSION)));
            }
            return 0.0f;
        }));
    }
}

