/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.item;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.sound.BlocklingsSounds;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class BlocklingWhistleItem
extends Item {
    @Nonnull
    public static final String BLOCKLING_UUID_KEY = "blockling_uuid";
    @Nonnull
    public static final String BLOCKLING_NAME_KEY = "blockling_name";
    @Nonnull
    public static final Map<BlocklingEntity, Set<ItemStack>> BLOCKLINGS_TO_WHISTLES = new HashMap<BlocklingEntity, Set<ItemStack>>();

    public BlocklingWhistleItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1).func_200918_c(64).setNoRepair());
    }

    public static void setBlockling(@Nonnull ItemStack stack, @Nonnull BlocklingEntity blockling) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_186854_a(BLOCKLING_UUID_KEY, blockling.func_110124_au());
        BlocklingWhistleItem.addStackToMap(blockling, stack);
    }

    public static void addStackToMap(@Nonnull BlocklingEntity blockling, @Nonnull ItemStack stack) {
        Set stacks = BLOCKLINGS_TO_WHISTLES.getOrDefault(blockling, new HashSet());
        stacks.add(stack);
        BLOCKLINGS_TO_WHISTLES.put(blockling, stacks);
    }

    public static void onBlocklingDestroyed(@Nonnull BlocklingEntity blockling) {
        Set<ItemStack> stacks = BLOCKLINGS_TO_WHISTLES.get(blockling);
        if (stacks != null) {
            for (ItemStack stack : stacks) {
                CompoundNBT stackTag = stack.func_77978_p();
                if (stackTag == null) continue;
                stackTag.func_82580_o(BLOCKLING_UUID_KEY);
                stackTag.func_82580_o(BLOCKLING_NAME_KEY);
            }
        }
        BLOCKLINGS_TO_WHISTLES.remove(blockling);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world instanceof ServerWorld) {
            BlocklingEntity blockling;
            UUID blocklingId;
            Entity entity;
            CompoundNBT stackTag;
            ServerWorld serverWorld = (ServerWorld)world;
            if (stack.func_77942_o() && (stackTag = stack.func_77978_p()).func_186855_b(BLOCKLING_UUID_KEY) && (entity = serverWorld.func_217461_a(blocklingId = stackTag.func_186857_a(BLOCKLING_UUID_KEY))) instanceof BlocklingEntity && player == (blockling = (BlocklingEntity)entity).func_70902_q()) {
                blockling.func_70634_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                stack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(hand));
                serverWorld.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)BlocklingsSounds.BLOCKLING_WHISTLE.get(), SoundCategory.PLAYERS, 1.0f, 1.5f);
            }
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int something, boolean somethingElse) {
        super.func_77663_a(stack, world, entity, something, somethingElse);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(BLOCKLING_UUID_KEY)) {
            if (world.field_72995_K) {
                String name;
                BlocklingEntity blockling = this.findBlockling(stack, (ClientWorld)world);
                if (blockling != null) {
                    BlocklingWhistleItem.addStackToMap(blockling, stack);
                }
                if ((name = this.findBlocklingName(stack, (ClientWorld)world)) != null) {
                    stack.func_77978_p().func_74778_a(BLOCKLING_NAME_KEY, name);
                }
            } else {
                BlocklingEntity blockling = (BlocklingEntity)((ServerWorld)world).func_217461_a(stack.func_77978_p().func_186857_a(BLOCKLING_UUID_KEY));
                if (blockling != null) {
                    BlocklingWhistleItem.addStackToMap(blockling, stack);
                    stack.func_77978_p().func_74778_a(BLOCKLING_NAME_KEY, blockling.func_200201_e().getString());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private BlocklingEntity findBlockling(@Nonnull ItemStack stack, @Nonnull ClientWorld world) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(BLOCKLING_UUID_KEY)) {
            Int2ObjectMap entitiesById = (Int2ObjectMap)ObfuscationReflectionHelper.getPrivateValue(ClientWorld.class, (Object)world, (String)"field_217429_b");
            Entity blockling = entitiesById.values().stream().filter(e -> e.func_110124_au().equals(stack.func_77978_p().func_186857_a(BLOCKLING_UUID_KEY))).findFirst().orElse(null);
            return (BlocklingEntity)blockling;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private String findBlocklingName(@Nonnull ItemStack stack, @Nonnull ClientWorld world) {
        ITextComponent customName;
        BlocklingEntity blockling = this.findBlockling(stack, world);
        if (blockling != null && (customName = blockling.func_200201_e()) != null) {
            return customName.getString();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private String findBlocklingLocation(@Nonnull ItemStack stack, @Nonnull ClientWorld world) {
        BlocklingEntity blockling = this.findBlockling(stack, world);
        if (blockling != null) {
            return String.format("%d %d %d", (int)blockling.func_226277_ct_(), (int)blockling.func_226278_cu_(), (int)blockling.func_226281_cx_());
        }
        return null;
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(BLOCKLING_NAME_KEY)) {
            return new StringTextComponent(TextFormatting.LIGHT_PURPLE + super.func_200295_i(stack).getString() + " (" + stack.func_77978_p().func_74779_i(BLOCKLING_NAME_KEY) + ")");
        }
        return super.func_200295_i(stack);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        String location;
        if (world != null && (location = this.findBlocklingLocation(stack, (ClientWorld)world)) != null) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + new TranslationTextComponent(this.func_77658_a() + ".location").getString() + location));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

