/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network;

import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.network.Message;
import com.willr27.blocklings.network.NetworkHandler;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class BlocklingMessage<T extends BlocklingMessage<T>>
extends Message {
    @Nullable
    protected BlocklingEntity blockling;
    protected int blocklingId;
    @Nonnull
    private UUID clientPlayerId = new UUID(0L, 0L);
    private boolean syncBackToClients = true;

    protected BlocklingMessage(@Nullable BlocklingEntity blockling) {
        this.blockling = blockling;
        if (blockling != null) {
            this.blocklingId = blockling.func_145782_y();
            if (blockling.field_70170_p.func_201670_d()) {
                this.clientPlayerId = this.getClientPlayerId();
            }
        }
    }

    protected BlocklingMessage(@Nullable BlocklingEntity blockling, boolean syncBackToClients) {
        this(blockling);
        this.syncBackToClients = syncBackToClients;
    }

    public void encode(@Nonnull PacketBuffer buf) {
        buf.writeInt(this.blocklingId);
        buf.func_179252_a(this.clientPlayerId);
        buf.writeBoolean(this.syncBackToClients);
    }

    public void decode(@Nonnull PacketBuffer buf) {
        this.blocklingId = buf.readInt();
        this.clientPlayerId = buf.func_179253_g();
        this.syncBackToClients = buf.readBoolean();
    }

    @Override
    public void handle(@Nonnull Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            boolean isClient = context.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
            PlayerEntity player = isClient ? this.getClientPlayer() : context.getSender();
            Objects.requireNonNull(player, "No player entity found when handling message.");
            this.blockling = (BlocklingEntity)player.field_70170_p.func_73045_a(this.blocklingId);
            if (this.blockling == null) {
                return;
            }
            this.handle(player, this.blockling);
            if (!isClient && this.syncBackToClients) {
                this.sendToAllClients(this.blockling.field_70170_p.func_217369_A().stream().filter(serverPlayer -> serverPlayer.func_110124_au().equals(this.clientPlayerId)).collect(Collectors.toList()));
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        context.setPacketHandled(true);
    }

    protected abstract void handle(@Nonnull PlayerEntity var1, @Nonnull BlocklingEntity var2);

    public void sync() {
        NetworkHandler.sync(this.blockling.field_70170_p, this);
    }

    public void sendToServer() {
        NetworkHandler.sendToServer(this);
    }

    public void sendToClient(PlayerEntity player) {
        NetworkHandler.sendToClient(player, this);
    }

    public void sendToAllClients(List<PlayerEntity> playersToIgnore) {
        NetworkHandler.sendToAllClients(this.blockling.field_70170_p, this, playersToIgnore);
    }
}

