/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.network;

import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.client.gui.BlocklingGuiHandler;
import com.willr27.blocklings.entity.blockling.action.Action;
import com.willr27.blocklings.entity.blockling.attribute.Attribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.EnumAttribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.FloatAttribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.IntAttribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.ModifiableFloatAttribute;
import com.willr27.blocklings.entity.blockling.attribute.attributes.numbers.ModifiableIntAttribute;
import com.willr27.blocklings.entity.blockling.task.config.Property;
import com.willr27.blocklings.network.BlocklingMessage;
import com.willr27.blocklings.network.Message;
import com.willr27.blocklings.network.messages.BlocklingAttackTargetMessage;
import com.willr27.blocklings.network.messages.BlocklingNameMessage;
import com.willr27.blocklings.network.messages.BlocklingScaleMessage;
import com.willr27.blocklings.network.messages.BlocklingTypeMessage;
import com.willr27.blocklings.network.messages.EquipmentInventoryMessage;
import com.willr27.blocklings.network.messages.GoalStateMessage;
import com.willr27.blocklings.network.messages.SetLevelCommandMessage;
import com.willr27.blocklings.network.messages.SetTypeCommandMessage;
import com.willr27.blocklings.network.messages.SetXpCommandMessage;
import com.willr27.blocklings.network.messages.SkillStateMessage;
import com.willr27.blocklings.network.messages.SkillTryBuyMessage;
import com.willr27.blocklings.network.messages.TaskCreateMessage;
import com.willr27.blocklings.network.messages.TaskCustomNameMessage;
import com.willr27.blocklings.network.messages.TaskPriorityMessage;
import com.willr27.blocklings.network.messages.TaskRemoveMessage;
import com.willr27.blocklings.network.messages.TaskSwapPriorityMessage;
import com.willr27.blocklings.network.messages.TaskTypeIsUnlockedMessage;
import com.willr27.blocklings.network.messages.TaskTypeMessage;
import com.willr27.blocklings.network.messages.WhitelistAllMessage;
import com.willr27.blocklings.network.messages.WhitelistIsUnlockedMessage;
import com.willr27.blocklings.network.messages.WhitelistSingleMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("blocklings", "channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static int id = 0;

    public static void init() {
        HANDLER.registerMessage(id++, SetLevelCommandMessage.class, SetLevelCommandMessage::encode, SetLevelCommandMessage::decode, SetLevelCommandMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        HANDLER.registerMessage(id++, SetTypeCommandMessage.class, SetTypeCommandMessage::encode, SetTypeCommandMessage::decode, SetTypeCommandMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        HANDLER.registerMessage(id++, SetXpCommandMessage.class, SetXpCommandMessage::encode, SetXpCommandMessage::decode, SetXpCommandMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NetworkHandler.registerMessage(Attribute.IsEnabledMessage.class);
        NetworkHandler.registerMessage(EnumAttribute.Message.class);
        NetworkHandler.registerMessage(FloatAttribute.ValueMessage.class);
        NetworkHandler.registerMessage(ModifiableFloatAttribute.BaseValueMessage.class);
        NetworkHandler.registerMessage(IntAttribute.ValueMessage.class);
        NetworkHandler.registerMessage(ModifiableIntAttribute.BaseValueMessage.class);
        NetworkHandler.registerMessage(Action.CountMessage.class);
        NetworkHandler.registerMessage(BlocklingAttackTargetMessage.class);
        NetworkHandler.registerMessage(BlocklingGuiHandler.OpenMessage.class);
        NetworkHandler.registerMessage(BlocklingNameMessage.class);
        NetworkHandler.registerMessage(BlocklingScaleMessage.class);
        NetworkHandler.registerMessage(BlocklingTypeMessage.class);
        NetworkHandler.registerMessage(EquipmentInventoryMessage.class);
        NetworkHandler.registerMessage(GoalStateMessage.class);
        NetworkHandler.registerMessage(SkillStateMessage.class);
        NetworkHandler.registerMessage(SkillTryBuyMessage.class);
        NetworkHandler.registerMessage(TaskCreateMessage.class);
        NetworkHandler.registerMessage(TaskPriorityMessage.class);
        NetworkHandler.registerMessage(TaskRemoveMessage.class);
        NetworkHandler.registerMessage(TaskCustomNameMessage.class);
        NetworkHandler.registerMessage(Property.TaskPropertyMessage.class);
        NetworkHandler.registerMessage(TaskSwapPriorityMessage.class);
        NetworkHandler.registerMessage(TaskTypeMessage.class);
        NetworkHandler.registerMessage(TaskTypeIsUnlockedMessage.class);
        NetworkHandler.registerMessage(WhitelistAllMessage.class);
        NetworkHandler.registerMessage(WhitelistIsUnlockedMessage.class);
        NetworkHandler.registerMessage(WhitelistSingleMessage.class);
    }

    public static <T extends BlocklingMessage<T>> void registerMessage(@Nonnull Class<T> messageType) {
        Function<PacketBuffer, BlocklingMessage> decoder = buf -> {
            try {
                BlocklingMessage message = (BlocklingMessage)messageType.newInstance();
                message.decode((PacketBuffer)buf);
                return message;
            }
            catch (IllegalAccessException | InstantiationException e) {
                Blocklings.LOGGER.warn(e.getLocalizedMessage());
                return null;
            }
        };
        HANDLER.registerMessage(id++, messageType, BlocklingMessage::encode, decoder, BlocklingMessage::handle);
    }

    public static void sendToServer(Message message) {
        HANDLER.sendToServer((Object)message);
    }

    public static void sendToClient(PlayerEntity player, Message message) {
        HANDLER.sendTo((Object)message, ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToAllClients(World world, Message message, List<PlayerEntity> playersToIgnore) {
        for (PlayerEntity player : world.func_217369_A()) {
            if (playersToIgnore.contains(player)) continue;
            NetworkHandler.sendToClient(player, message);
        }
    }

    public static void sync(World world, Message message) {
        if (world.field_72995_K) {
            NetworkHandler.sendToServer(message);
        } else {
            NetworkHandler.sendToAllClients(world, message, new ArrayList<PlayerEntity>());
        }
    }
}

